/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.mixin.AbstractContainerAccessor;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;

public class StringResultScreenHandler
extends AnvilMenu {
    private final Consumer<String> cons;
    private final Runnable ret;
    private boolean init;
    private String name;

    private StringResultScreenHandler(int syncId, Inventory playerInventory, Consumer<String> cons, Runnable ret) {
        super(syncId, playerInventory);
        ItemStack stack = ServerScreenHelper.createStack(Items.PAPER, (Component)ClaimUtils.translatedText("", new Object[0]));
        this.inputSlots.setItem(0, stack);
        ItemStack out = ServerScreenHelper.createStack(Items.BOOK, (Component)ServerScreenHelper.coloredGuiText("flan.stringScreenReturn", new Object[0]));
        this.resultSlots.setItem(0, out);
        this.cons = cons;
        this.ret = ret;
    }

    public static void createNewStringResult(Player player, final Consumer<String> cons, final Runnable ret) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new StringResultScreenHandler(syncId, inv, cons, ret);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText("", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected boolean mayPickup(Player player, boolean present) {
        return true;
    }

    public void clicked(int i, int j, ClickType actionType, Player player) {
        if (i < 0 || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Slot slot = (Slot)this.slots.get(i);
        if (((AbstractContainerAccessor)((Object)this)).containerSync() != null) {
            ((AbstractContainerAccessor)((Object)this)).containerSync().sendCarriedChange((AbstractContainerMenu)this, this.getCarried().copy());
        }
        if (i == 0) {
            this.ret.run();
        } else if (i == 2) {
            ComponentContents componentContents;
            Component name = (Component)slot.getItem().get(DataComponents.CUSTOM_NAME);
            if (name != null && (componentContents = name.getContents()) instanceof PlainTextContents) {
                PlainTextContents text = (PlainTextContents)componentContents;
                this.cons.accept(text.text());
            }
            serverPlayer.connection.send((Packet)new ClientboundSetExperiencePacket(serverPlayer.experienceProgress, serverPlayer.totalExperience, serverPlayer.experienceLevel));
        }
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!(player instanceof ServerPlayer)) {
            return ItemStack.EMPTY;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (index == 0) {
            this.ret.run();
        } else if (index == 2) {
            ComponentContents componentContents;
            Slot slot = (Slot)this.slots.get(index);
            Component name = (Component)slot.getItem().get(DataComponents.CUSTOM_NAME);
            if (name != null && (componentContents = name.getContents()) instanceof PlainTextContents) {
                PlainTextContents text = (PlainTextContents)componentContents;
                this.cons.accept(text.text());
            }
            serverPlayer.connection.send((Packet)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        }
        this.broadcastChanges();
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        for (int j = 0; j < this.slots.size(); ++j) {
            ItemStack stack = ((Slot)this.slots.get(j)).getItem();
            for (ContainerListener screenHandlerListener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
                screenHandlerListener.slotChanged((AbstractContainerMenu)this, j, stack.copy());
            }
        }
    }

    public void createResult() {
        if (!this.init) {
            this.init = true;
        } else {
            ItemStack stack = ((Slot)this.slots.get(2)).getItem();
            if (StringUtils.isBlank((CharSequence)this.name)) {
                stack.remove(DataComponents.CUSTOM_NAME);
            } else if (!this.name.equals(stack.getHoverName().getString())) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name));
            }
        }
        this.broadcastChanges();
    }

    public boolean setItemName(String string) {
        this.name = string;
        this.createResult();
        return true;
    }
}

