/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.mixin;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.utils.IOwnedItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Allay.class})
public abstract class AllayMixin {
    @Inject(method={"wantsToPickUp(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onWantingPickup(ItemStack stack, CallbackInfoReturnable<Boolean> info) {
        Allay allay = (Allay)this;
        if (AllayAi.getLikedPlayer((LivingEntity)allay).map(p -> {
            Claim claim = ClaimStorage.get(p.serverLevel()).getClaimAt(allay.blockPosition());
            return claim != null && !claim.canInteract((ServerPlayer)p, BuiltinPermission.PICKUP, allay.blockPosition(), false);
        }).orElse(false).booleanValue()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickupItem(ItemEntity itemEntity, CallbackInfo info) {
        if (AllayAi.getLikedPlayer((LivingEntity)((Allay)this)).map(p -> {
            IOwnedItem ownedItem = (IOwnedItem)itemEntity;
            if (p.getUUID().equals(ownedItem.flan$getPlayerOrigin())) {
                return false;
            }
            Claim claim = ClaimStorage.get(p.serverLevel()).getClaimAt(itemEntity.blockPosition());
            return claim != null && !claim.canInteract((ServerPlayer)p, BuiltinPermission.PICKUP, itemEntity.blockPosition(), false);
        }).orElse(false).booleanValue()) {
            info.cancel();
        }
    }
}

