/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.mixin;

import io.github.flemmli97.flan.event.BlockInteractEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChestBlock.class})
public abstract class ChestBlockMixin {
    @Inject(method={"candidatePartnerFacing(Lnet/minecraft/world/item/context/BlockPlaceContext;Lnet/minecraft/core/Direction;)Lnet/minecraft/core/Direction;"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkCandidate(BlockPlaceContext context, Direction direction, CallbackInfoReturnable<Direction> info) {
        BlockPos pos = context.getClickedPos().relative(direction);
        if (BlockInteractEvents.useBlocks(context.getPlayer(), context.getLevel(), context.getHand(), new BlockHitResult(context.getClickLocation(), direction, pos, false)) == InteractionResult.FAIL) {
            info.setReturnValue(null);
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getServer().tell((Runnable)new TickTask(1, () -> player.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, context.getLevel().getBlockState(pos)))));
            }
        }
    }
}

