/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.webmap;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class BluemapIntegration {
    private static final String MARKER_3D = "flan.claims";
    private static final String MARKER_2D = "flan.claims.2d";

    public static void reg(MinecraftServer server) {
        BlueMapAPI.onEnable(api -> {
            for (ServerLevel level : server.getAllLevels()) {
                api.getWorld((Object)level).ifPresent(world -> world.getMaps().forEach(map -> {
                    MarkerSet markerSet = MarkerSet.builder().label("Claims (3D)").defaultHidden(Boolean.valueOf(true)).build();
                    MarkerSet markerSet2 = MarkerSet.builder().label("Claims (2D)").build();
                    map.getMarkerSets().put(MARKER_3D, markerSet);
                    map.getMarkerSets().put(MARKER_2D, markerSet2);
                }));
                BluemapIntegration.processClaims(level);
            }
            WebmapCalls.bluemapLoaded = true;
        });
    }

    public static void processClaims(ServerLevel level) {
        ClaimStorage claimStorage = ClaimStorage.get(level);
        Map<UUID, Set<Claim>> claimMap = claimStorage.getClaims();
        claimMap.forEach((uuid, claims) -> claims.forEach(BluemapIntegration::addClaimMarker));
    }

    public static void addClaimMarker(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getLevel())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                MarkerSet markerSet = (MarkerSet)map.getMarkerSets().get(MARKER_3D);
                ClaimBox dim = claim.getDimensions();
                ExtrudeMarker marker = ((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(BluemapIntegration.claimLabel(claim))).depthTestEnabled(false).shape(Shape.createRect((double)dim.minX(), (double)dim.minZ(), (double)(dim.maxX() + 1), (double)(dim.maxZ() + 1)), (float)dim.minY(), (float)dim.maxY()).lineColor(new Color(BluemapIntegration.lineColor(claim.isAdminClaim()), 0.8f)).lineWidth(3).fillColor(new Color(BluemapIntegration.fillColor(claim.isAdminClaim()), 0.2f)).build();
                markerSet.put(claim.getClaimID().toString(), (Marker)marker);
                MarkerSet markerSet2 = (MarkerSet)map.getMarkerSets().get(MARKER_2D);
                ShapeMarker shapeMarker = ((ShapeMarker.Builder)ShapeMarker.builder().label(BluemapIntegration.claimLabel(claim))).depthTestEnabled(false).shape(Shape.createRect((double)dim.minX(), (double)dim.minZ(), (double)(dim.maxX() + 1), (double)(dim.maxZ() + 1)), (float)dim.minY()).lineColor(new Color(BluemapIntegration.lineColor(claim.isAdminClaim()), 0.8f)).lineWidth(3).fillColor(new Color(BluemapIntegration.fillColor(claim.isAdminClaim()), 0.2f)).build();
                markerSet2.put(claim.getClaimID().toString(), (Marker)shapeMarker);
            }
        });
    }

    public static void removeMarker(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getLevel())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                BluemapIntegration.updateMarkers(map, markerSet -> markerSet.remove(claim.getClaimID().toString()));
            }
        });
    }

    public static void changeClaimName(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getLevel())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                BluemapIntegration.updateMarkers(map, markerSet -> {
                    Marker marker = markerSet.get(claim.getClaimID().toString());
                    marker.setLabel(BluemapIntegration.claimLabel(claim));
                });
            }
        });
    }

    public static void changeClaimOwner(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getLevel())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                BluemapIntegration.updateMarkers(map, markerSet -> {
                    Marker marker = markerSet.get(claim.getClaimID().toString());
                    marker.setLabel(BluemapIntegration.claimLabel(claim));
                });
            }
        });
    }

    private static int lineColor(boolean admin) {
        return admin ? 11864329 : 16753152;
    }

    private static int fillColor(boolean admin) {
        return admin ? 0xFF0000 : 14737437;
    }

    private static String claimLabel(Claim claim) {
        String name = claim.getClaimName();
        if (claim.isAdminClaim()) {
            if (name == null || name.isEmpty()) {
                return "Admin Claim";
            }
            return name + " - Admin Claim";
        }
        Optional<String> prof = ClaimUtils.fetchUsername(claim.getOwner(), claim.getLevel().getServer());
        if (name == null || name.isEmpty()) {
            return prof.orElse("UNKNOWN") + "'s Claim";
        }
        return name + " - " + prof.orElse("UNKNOWN") + "'s Claim";
    }

    private static void updateMarkers(BlueMapMap map, Consumer<MarkerSet> cons) {
        cons.accept((MarkerSet)map.getMarkerSets().get(MARKER_3D));
        cons.accept((MarkerSet)map.getMarkerSets().get(MARKER_2D));
    }
}

