/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.api.render;

import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.BarRenderManager;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class CustomArmorBar {
    public static CustomArmorBar DEFAULT = new CustomArmorBar(itemStack -> new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(63, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(54, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(9, 0), new TextureOffset(27, 0)));
    public static CustomArmorBar EMPTY = new CustomArmorBar(itemStack -> {
        if (DetailArmorBar.getConfig().getOptions().toggleEmptyBar) {
            return new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(45, 0), new TextureOffset(45, 0), new TextureOffset(9, 0), new TextureOffset(27, 0));
        }
        return new ArmorBarRenderManager(DetailArmorBar.GUI_ARMOR_BAR, 128, 128, new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0));
    });
    private final Function<class_1799, ? extends BarRenderManager> predicate;

    public CustomArmorBar(Function<class_1799, ? extends BarRenderManager> predicate) {
        this.predicate = predicate;
    }

    public void draw(class_1799 itemStack, class_332 context, int xPos, int yPos, boolean isHalf, boolean isMirror) {
        BarRenderManager.Texture textureInfo;
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isHidden()) {
            return;
        }
        BarRenderManager.Texture texture = textureInfo = isHalf ? renderInfo.getTextureHalf() : renderInfo.getTextureFull();
        if (isHalf) {
            InGameDrawer.drawTexture(textureInfo.location(), context, xPos, yPos, textureInfo.offset().x, textureInfo.offset().y, textureInfo.width(), textureInfo.height(), renderInfo.getColor(), isMirror);
        } else {
            InGameDrawer.drawTexture(textureInfo.location(), context, xPos, yPos, textureInfo.offset().x, textureInfo.offset().y, textureInfo.width(), textureInfo.height(), renderInfo.getColor(), false);
        }
    }

    public void drawOutLine(class_1799 itemStack, class_332 context, int xPos, int yPos, boolean isHalf, boolean isMirror, Color color) {
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isHidden()) {
            return;
        }
        BarRenderManager.Texture textureInfo = isHalf ? renderInfo.getTextureOutlineHalf() : renderInfo.getTextureOutline();
        TextureOffset offset = textureInfo.offset();
        if (isHalf) {
            if (renderInfo instanceof ItemBarRenderManager) {
                InGameDrawer.drawTexture(textureInfo.location(), context, xPos + 4, yPos, offset.x + 4, offset.y, 5, 9, textureInfo.width(), textureInfo.height(), color, false);
            } else {
                InGameDrawer.drawTexture(textureInfo.location(), context, xPos, yPos, offset.x, offset.y, textureInfo.width(), textureInfo.height(), color, isMirror);
            }
        } else {
            InGameDrawer.drawTexture(textureInfo.location(), context, xPos, yPos, offset.x, offset.y, textureInfo.width(), textureInfo.height(), color, false);
        }
    }
}

