/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.CustomArmorBar;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9323;

public class ArmorBarLoader
extends class_4309<JsonElement>
implements IdentifiableResourceReloadListener {
    private static final Codec<JsonElement> JSON_CODEC = Codec.PASSTHROUGH.xmap(dynamic -> (JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue(), json -> new Dynamic((DynamicOps)JsonOps.INSTANCE, json));
    private Map<class_1792, CustomArmorBar> armorList;
    private Map<class_1792, CustomArmorBar> itemList;

    public ArmorBarLoader() {
        super(JSON_CODEC, class_7654.method_45114((String)"armor_bar"));
    }

    public Map<class_1792, CustomArmorBar> getArmorList() {
        return this.armorList;
    }

    public Map<class_1792, CustomArmorBar> getItemList() {
        return this.itemList;
    }

    public boolean isLoaded() {
        return this.armorList != null && this.itemList != null;
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)DetailArmorBar.MOD_ID, (String)"armor");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder armorBuilder = ImmutableMap.builder().putAll(DetailArmorBarAPI.getStaticArmorBarList());
        ImmutableMap.Builder itemBarBuilder = ImmutableMap.builder().putAll(DetailArmorBarAPI.getStaticItemBarList());
        prepared.forEach((id, json) -> {
            block6: {
                try {
                    JsonObject root = json.getAsJsonObject();
                    JsonElement itemsJson = root.get("items");
                    JsonElement rendererJson = root.get("render");
                    String type = root.get("type").getAsString();
                    if (!itemsJson.isJsonArray()) {
                        DetailArmorBar.LOGGER.error("Missing or broken item list in armor definition {}", id);
                        return;
                    }
                    if (!rendererJson.isJsonObject()) {
                        DetailArmorBar.LOGGER.error("Missing or broken renderer in armor definition {}", id);
                        return;
                    }
                    if (type.equals("armor")) {
                        Optional<class_1792[]> items = Codec.list((Codec)class_2960.field_25139).decode((DynamicOps)JsonOps.INSTANCE, (Object)itemsJson).resultOrPartial(err -> DetailArmorBar.LOGGER.error("Invalid items in armor definition [{}]: {}", id, err)).map(pair -> (class_1792[])((List)pair.getFirst()).stream().map(itemId -> new class_1799((class_1935)class_7923.field_41178.method_63535(itemId))).filter(this::filterAndLogArmor).toArray(class_1792[]::new));
                        Optional<ArmorBarRenderManager> renderer = ArmorBarRenderManager.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)rendererJson).resultOrPartial(err -> DetailArmorBar.LOGGER.error("Failed to load render manager [{}]: {}", id, err)).map(Pair::getFirst);
                        Optional<CustomArmorBar> barOpt = renderer.map(r -> new CustomArmorBar(stack -> r));
                        items.ifPresentOrElse(list -> barOpt.ifPresentOrElse(bar -> {
                            for (class_1792 item : list) {
                                armorBuilder.put((Object)item, bar);
                            }
                        }, () -> DetailArmorBar.LOGGER.error("Armor definition {} is missing a renderer!", id)), () -> DetailArmorBar.LOGGER.error("Invalid or empty item list in armor definition {}", id));
                        break block6;
                    }
                    if (type.equals("item")) {
                        Optional<class_1792[]> items = Codec.list((Codec)class_2960.field_25139).decode((DynamicOps)JsonOps.INSTANCE, (Object)itemsJson).resultOrPartial(err -> DetailArmorBar.LOGGER.error("Invalid items in item definition [{}]: {}", id, err)).map(pair -> (class_1792[])((List)pair.getFirst()).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).toArray(class_1792[]::new));
                        Optional<ItemBarRenderManager> renderer = ItemBarRenderManager.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)rendererJson).resultOrPartial(err -> DetailArmorBar.LOGGER.error("Failed to load item render manager [{}]: {}", id, err)).map(Pair::getFirst);
                        Optional<CustomArmorBar> barOpt = renderer.map(r -> new CustomArmorBar(stack -> r));
                        items.ifPresentOrElse(list -> barOpt.ifPresentOrElse(bar -> {
                            for (class_1792 item : list) {
                                itemBarBuilder.put((Object)item, bar);
                            }
                        }, () -> DetailArmorBar.LOGGER.error("Item definition {} is missing a renderer!", id)), () -> DetailArmorBar.LOGGER.error("Invalid or empty item list in item definition {}", id));
                        break block6;
                    }
                    throw new IllegalArgumentException("Invalid type " + type);
                }
                catch (Exception ex) {
                    DetailArmorBar.LOGGER.error("Failed to load armor definition [{}]: {}", id, (Object)ex);
                }
            }
        });
        this.armorList = armorBuilder.buildKeepingLast();
        this.itemList = itemBarBuilder.buildKeepingLast();
    }

    private boolean filterAndLogArmor(class_1799 stack) {
        class_9323 eqComp = stack.method_57353();
        if (eqComp != null) {
            DetailArmorBar.LOGGER.info("Equippable component for {}: {}", (Object)stack, (Object)eqComp);
            return true;
        }
        DetailArmorBar.LOGGER.warn("Non-armor item: {}", (Object)stack.method_7909());
        return false;
    }
}

