/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.render;

import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.CustomArmorBar;
import com.redlimerl.detailab.config.ConfigEnumType;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class ArmorBarRenderer {
    public static final ArmorBarRenderer INSTANCE = new ArmorBarRenderer();
    public static long LAST_THORNS = 0L;
    public static long LAST_MENDING = 0L;
    private final class_310 client = class_310.method_1551();
    private final class_329 hud;

    public ArmorBarRenderer() {
        this.hud = this.client.field_1705;
    }

    private static int getAnimationSpeed() {
        return switch (DetailArmorBar.getConfig().getOptions().effectSpeed) {
            case ConfigEnumType.EffectSpeed.VERY_SLOW -> 45;
            case ConfigEnumType.EffectSpeed.SLOW -> 37;
            case ConfigEnumType.EffectSpeed.FAST -> 23;
            case ConfigEnumType.EffectSpeed.VERY_FAST -> 15;
            default -> 30;
        };
    }

    private static Color getProtectColor(int g, int p, int e, int f, int a) {
        long time;
        int speed = ArmorBarRenderer.getAnimationSpeed();
        int alpha = DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA ? 80 : (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE ? ((time = DetailArmorBar.getTicks()) % ((long)speed * 4L) < (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.0f, (float)0.65f) * 255.0f) : Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.65f, (float)0.0f) * 255.0f))) : 0);
        if (g > 0) {
            return new Color(153, 255, 255, alpha);
        }
        if (p > 0) {
            return new Color(112, 51, 173, alpha);
        }
        if (e > 0) {
            return new Color(255, 255, 0, alpha);
        }
        if (f > 0) {
            return new Color(210, 56, 0, alpha);
        }
        if (a > 0) {
            return new Color(255, 255, 255, alpha);
        }
        return Color.WHITE;
    }

    private static Color getProtectColor(int[] s) {
        if (s == null || s.length < 5) {
            return Color.WHITE;
        }
        return ArmorBarRenderer.getProtectColor(s[0], s[1], s[2], s[3], s[4]);
    }

    private static Color getAnimatedUniformColor(Color baseColor) {
        long time;
        int speed = ArmorBarRenderer.getAnimationSpeed();
        int alpha = DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA ? 80 : (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE ? ((time = DetailArmorBar.getTicks()) % ((long)speed * 4L) < (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.0f, (float)0.65f) * 255.0f) : Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.65f, (float)0.0f) * 255.0f))) : 0);
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private static Color getLowDurabilityColor() {
        int speed = ArmorBarRenderer.getAnimationSpeed();
        long time = DetailArmorBar.getTicks();
        int alpha = time % ((long)speed * 4L) >= (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.0f, (float)0.65f) * 255.0f) : Math.round(class_3532.method_16439((float)((float)(time % (long)speed) / ((float)speed - 1.0f)), (float)0.65f, (float)0.0f) * 255.0f));
        return new Color(255, 25, 25, alpha);
    }

    private static Color getThornColor() {
        if (DetailArmorBar.getConfig().getOptions().effectThorn == ConfigEnumType.Animation.STATIC) {
            return Color.WHITE;
        }
        long currentTime = DetailArmorBar.getTicks();
        long timeSinceLastHit = currentTime - LAST_THORNS;
        int totalDuration = switch (DetailArmorBar.getConfig().getOptions().effectSpeed) {
            case ConfigEnumType.EffectSpeed.VERY_SLOW -> 20;
            case ConfigEnumType.EffectSpeed.SLOW -> 16;
            case ConfigEnumType.EffectSpeed.FAST -> 8;
            case ConfigEnumType.EffectSpeed.VERY_FAST -> 4;
            default -> 12;
        };
        int phase1Duration = totalDuration / 2;
        int phase2Duration = phase1Duration + totalDuration / 4;
        if (LAST_THORNS == 0L || timeSinceLastHit > (long)totalDuration) {
            return Color.WHITE;
        }
        if (timeSinceLastHit < (long)phase1Duration) {
            return new Color(255, 0, 0);
        }
        if (timeSinceLastHit < (long)phase2Duration) {
            return new Color(255, 60, 60);
        }
        return new Color(255, 150, 150);
    }

    private static Map<class_5321<class_1887>, LevelData> getEnchantments(Iterable<class_1799> equipment) {
        HashMap<class_5321<class_1887>, LevelData> result = new HashMap<class_5321<class_1887>, LevelData>();
        for (class_1799 itemStack : equipment) {
            if (itemStack.method_7960()) continue;
            class_1890.method_57532((class_1799)itemStack).method_57539().forEach(enchantment -> {
                class_5321 enchantType = ((class_6880)enchantment.getKey()).method_40230().orElse(null);
                LevelData enchantData = result.getOrDefault(enchantType, new LevelData(0, 0));
                ++enchantData.count;
                enchantData.level += enchantment.getIntValue();
                if (enchantType == class_1893.field_9097) {
                    enchantData.level += enchantment.getIntValue() - 1;
                }
                result.put(enchantType, enchantData);
            });
        }
        return result;
    }

    private static LevelData getEnchantLevel(Iterable<class_1799> equipment, class_5321<class_1887> type) {
        return ArmorBarRenderer.getEnchantments(equipment).getOrDefault(type, new LevelData(0, 0));
    }

    private int getLowDurabilityItem(Iterable<class_3545<class_1304, class_1799>> equipment) {
        int count = 0;
        for (class_3545<class_1304, class_1799> pair : equipment) {
            class_1799 itemStack = (class_1799)pair.method_15441();
            class_1304 slot = (class_1304)pair.method_15442();
            if (itemStack.method_7960() || itemStack.method_7936() == 0 || !((float)itemStack.method_7919() * 100.0f / ((float)itemStack.method_7936() * 100.0f) >= 0.92f) || !itemStack.method_57826(class_9334.field_49636)) continue;
            class_9285 component = (class_9285)itemStack.method_58694(class_9334.field_49636);
            assert (component != null);
            count = (int)((double)count + component.comp_2393().stream().filter(attr -> attr.comp_2395().equals((Object)class_5134.field_23724) && attr.comp_2397().method_66665().contains(slot)).findFirst().map(x -> x.comp_2396().comp_2449()).orElse(0.0));
        }
        return count;
    }

    private static List<class_3545<class_1799, CustomArmorBar>> getArmorPoints(class_1657 player) {
        ArrayList<class_3545<class_1799, CustomArmorBar>> armorPoints = new ArrayList<class_3545<class_1799, CustomArmorBar>>();
        ArrayList<class_3545> itemPoints = new ArrayList<class_3545>();
        int sumArmor = 0;
        for (class_1304 slot : class_1304.field_54086) {
            class_10192 equippableComponent;
            class_1799 itemStack = player.method_6118(slot);
            if (itemStack.method_7960()) continue;
            class_9285 component = (class_9285)itemStack.method_58694(class_9334.field_49636);
            if (component != null) {
                CustomArmorBar barData = DetailArmorBar.getConfig().getOptions().toggleArmorTypes ? DetailArmorBarAPI.getArmorBarList().getOrDefault(itemStack.method_7909(), CustomArmorBar.DEFAULT) : CustomArmorBar.DEFAULT;
                int defense = ArmorBarRenderer.getDefense(itemStack, slot);
                sumArmor += defense;
                for (int i = 0; i < defense; ++i) {
                    armorPoints.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)itemStack, (Object)barData));
                }
            }
            if (!DetailArmorBar.getConfig().getOptions().toggleItemBar || !DetailArmorBarAPI.getItemBarList().containsKey(itemStack.method_7909()) || (equippableComponent = (class_10192)itemStack.method_58694(class_9334.field_54196)) != null && equippableComponent.comp_3174() != slot) continue;
            CustomArmorBar barData = DetailArmorBarAPI.getItemBarList().get(itemStack.method_7909());
            class_3545 pair = new class_3545((Object)itemStack, (Object)barData);
            if (DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem) {
                itemPoints.add(pair);
                itemPoints.add(pair);
                continue;
            }
            if (armorPoints.size() % 2 == 1) {
                armorPoints.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.EMPTY));
            }
            armorPoints.add((class_3545<class_1799, CustomArmorBar>)pair);
            armorPoints.add((class_3545<class_1799, CustomArmorBar>)pair);
        }
        double baseArmor = player.method_45326(class_5134.field_23724);
        sumArmor = (int)((double)sumArmor + baseArmor);
        int i = 0;
        while ((double)i < baseArmor) {
            armorPoints.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.DEFAULT));
            ++i;
        }
        if (DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem) {
            if (armorPoints.size() % 2 == 1) {
                armorPoints.add((class_3545<class_1799, CustomArmorBar>)new class_3545((Object)class_1799.field_8037, (Object)CustomArmorBar.EMPTY));
            }
            armorPoints.addAll(itemPoints);
        }
        return armorPoints;
    }

    private static int getDefense(class_1799 itemStack, class_1304 slot) {
        class_9285 modifier = (class_9285)itemStack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : modifier.comp_2393()) {
            if (!entry.comp_2397().method_57286(slot) || !entry.comp_2395().equals((Object)class_5134.field_23724)) continue;
            return (int)entry.comp_2396().comp_2449();
        }
        return 0;
    }

    private Iterable<class_1799> getArmorItems(class_1657 player) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        Optional.ofNullable(player.method_6118(class_1304.field_6169)).ifPresent(list::add);
        Optional.ofNullable(player.method_6118(class_1304.field_6174)).ifPresent(list::add);
        Optional.ofNullable(player.method_6118(class_1304.field_6172)).ifPresent(list::add);
        Optional.ofNullable(player.method_6118(class_1304.field_6166)).ifPresent(list::add);
        return list;
    }

    private boolean hasSameProtectionEnchantments(Iterable<class_1799> equipment) {
        if (!DetailArmorBar.getConfig().getOptions().toggleUniformColor) {
            return false;
        }
        ArrayList armorPieces = new ArrayList();
        equipment.forEach(item -> {
            if (!item.method_7960()) {
                armorPieces.add(item);
            }
        });
        if (armorPieces.isEmpty()) {
            return false;
        }
        LevelData firstGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(0)), (class_5321<class_1887>)class_1893.field_9111);
        LevelData firstProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(0)), (class_5321<class_1887>)class_1893.field_9096);
        LevelData firstExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(0)), (class_5321<class_1887>)class_1893.field_9107);
        LevelData firstFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(0)), (class_5321<class_1887>)class_1893.field_9095);
        for (int i = 1; i < armorPieces.size(); ++i) {
            LevelData nextGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(i)), (class_5321<class_1887>)class_1893.field_9111);
            LevelData nextProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(i)), (class_5321<class_1887>)class_1893.field_9096);
            LevelData nextExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(i)), (class_5321<class_1887>)class_1893.field_9107);
            LevelData nextFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton((class_1799)armorPieces.get(i)), (class_5321<class_1887>)class_1893.field_9095);
            if (firstGeneric.level == nextGeneric.level && firstProjectile.level == nextProjectile.level && firstExplosive.level == nextExplosive.level && firstFire.level == nextFire.level) continue;
            return false;
        }
        return true;
    }

    public void render(class_332 context, class_1657 player, int y_base) {
        block53: {
            class_1799 nextArmorItem;
            class_1799 armorItem;
            int xPos;
            int mendingSpeed;
            long mendingTime;
            int count;
            LevelData generic = ArmorBarRenderer.getEnchantLevel(this.getArmorItems(player), (class_5321<class_1887>)class_1893.field_9111);
            LevelData projectile = ArmorBarRenderer.getEnchantLevel(this.getArmorItems(player), (class_5321<class_1887>)class_1893.field_9096);
            LevelData explosive = ArmorBarRenderer.getEnchantLevel(this.getArmorItems(player), (class_5321<class_1887>)class_1893.field_9107);
            LevelData fire = ArmorBarRenderer.getEnchantLevel(this.getArmorItems(player), (class_5321<class_1887>)class_1893.field_9095);
            int[] protectArr = new int[]{generic.level + generic.count, projectile.level, explosive.level, fire.level, 0};
            List<class_3545<class_1799, CustomArmorBar>> armorPoints = ArmorBarRenderer.getArmorPoints(player);
            LevelData thorns = ArmorBarRenderer.getEnchantLevel(this.getArmorItems(player), (class_5321<class_1887>)class_1893.field_9097);
            int totalArmorPoint = armorPoints.size();
            int totalEnchants = Arrays.stream(protectArr).sum();
            int screenWidth = this.client.method_22683().method_4486() / 2 - 91 + DetailArmorBar.getConfig().getOptions().armorBarOffsetX;
            int yPos = y_base + DetailArmorBar.getConfig().getOptions().armorBarOffsetY;
            int stackCount = (totalArmorPoint - 1) / 20;
            int stackRow = stackCount * 20;
            if (totalArmorPoint == 0 && DetailArmorBar.getConfig().getOptions().toggleEmptyBar) {
                for (int count2 = 0; count2 < 10; ++count2) {
                    int xPos2 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count2) * 8 : screenWidth + count2 * 8;
                    CustomArmorBar.EMPTY.draw(class_1799.field_8037, context, xPos2, yPos, false, false);
                }
            }
            if (totalArmorPoint > 0) {
                int maxSlots = 10;
                for (count = 0; count < maxSlots; ++count) {
                    int xPos3 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count) * 8 : screenWidth + count * 8;
                    if (count * 2 + 1 + stackRow < totalArmorPoint) {
                        class_3545<class_1799, CustomArmorBar> am1 = armorPoints.get(count * 2 + stackRow);
                        class_3545<class_1799, CustomArmorBar> am2 = armorPoints.get(count * 2 + 1 + stackRow);
                        if (am1.method_15441() == am2.method_15441()) {
                            ((CustomArmorBar)am1.method_15441()).draw((class_1799)am1.method_15442(), context, xPos3, yPos, false, false);
                        } else {
                            ((CustomArmorBar)am2.method_15441()).draw((class_1799)am2.method_15442(), context, xPos3, yPos, true, true);
                            ((CustomArmorBar)am1.method_15441()).draw((class_1799)am1.method_15442(), context, xPos3, yPos, true, false);
                        }
                        if (DetailArmorBar.getConfig().getOptions().toggleMending && (this.hasMendingEnchant((class_1799)am1.method_15442()) || this.hasMendingEnchant((class_1799)am2.method_15442()))) {
                            this.drawSparkleOverlay(context, xPos3, yPos);
                        }
                    }
                    if (count * 2 + 1 + stackRow == totalArmorPoint) {
                        CustomArmorBar.EMPTY.draw(class_1799.field_8037, context, xPos3, yPos, false, false);
                        class_3545<class_1799, CustomArmorBar> am = armorPoints.get(count * 2 + stackRow);
                        ((CustomArmorBar)am.method_15441()).draw((class_1799)am.method_15442(), context, xPos3, yPos, true, false);
                        if (DetailArmorBar.getConfig().getOptions().toggleMending && this.hasMendingEnchant((class_1799)am.method_15442())) {
                            this.drawSparkleOverlay(context, xPos3, yPos);
                        }
                    }
                    if (count * 2 + 1 + stackRow <= totalArmorPoint) continue;
                    CustomArmorBar.EMPTY.draw(class_1799.field_8037, context, xPos3, yPos, false, false);
                }
                if (armorPoints.size() > 20) {
                    for (int i = 0; i < stackCount; ++i) {
                        CustomArmorBar.DEFAULT.draw(class_1799.field_8037, context, screenWidth - 7 - (stackCount - i) * 3, yPos, false, false);
                    }
                }
            }
            if (DetailArmorBar.getConfig().getOptions().toggleDurability) {
                Color lowDurColor;
                ArrayList<class_3545<class_1304, class_1799>> equipment = new ArrayList<class_3545<class_1304, class_1799>>();
                for (class_1304 equipmentSlot : class_1304.field_54086) {
                    class_1799 itemStack = player.method_6118(equipmentSlot);
                    class_10192 equippableComponent = (class_10192)itemStack.method_58694(class_9334.field_54196);
                    if (equippableComponent == null || equippableComponent.comp_3174() != equipmentSlot) continue;
                    equipment.add((class_3545<class_1304, class_1799>)new class_3545((Object)equipmentSlot, (Object)itemStack));
                }
                int lowDur = this.getLowDurabilityItem(equipment);
                if (totalArmorPoint != 0 && lowDur != 0 && (lowDurColor = ArmorBarRenderer.getLowDurabilityColor()).getAlpha() != 0) {
                    int armorPreset = (totalArmorPoint - 1) % 20 + 1;
                    int halfArmors = (int)Math.ceil((double)armorPreset / 2.0) - 1;
                    for (int count3 = 0; count3 <= halfArmors && lowDur > 0; ++count3) {
                        int xPos4 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - (halfArmors - count3)) * 8 : screenWidth + (halfArmors - count3) * 8;
                        class_3545<class_1799, CustomArmorBar> am = armorPoints.get((halfArmors - count3) * 2 + stackRow);
                        if (armorPreset == (halfArmors - count3) * 2 + 1) {
                            if (count3 != 0) continue;
                            ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), context, xPos4, yPos, true, false, lowDurColor);
                            --lowDur;
                            continue;
                        }
                        if (lowDur == 1) {
                            ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), context, xPos4, yPos, true, true, lowDurColor);
                            lowDur = 0;
                            continue;
                        }
                        ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), context, xPos4, yPos, false, false, lowDurColor);
                        lowDur -= 2;
                    }
                }
            }
            if (DetailArmorBar.getConfig().getOptions().toggleMending && totalArmorPoint != 0 && (mendingTime = DetailArmorBar.getTicks() - LAST_MENDING) < (long)((mendingSpeed = 3) * 4)) {
                int maxSlots = 10;
                for (int count4 = 0; count4 < maxSlots; ++count4) {
                    if (mendingTime % (long)(mendingSpeed * 2) >= (long)mendingSpeed) continue;
                    xPos = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count4) * 8 : screenWidth + count4 * 8;
                    if (armorPoints.size() <= count4 * 2 + stackRow) {
                        if (!DetailArmorBar.getConfig().getOptions().toggleEmptyBar) continue;
                        CustomArmorBar.DEFAULT.drawOutLine(class_1799.field_8037, context, xPos, yPos, false, false, Color.WHITE);
                        continue;
                    }
                    class_3545<class_1799, CustomArmorBar> am = armorPoints.get(count4 * 2 + stackRow);
                    ((CustomArmorBar)am.method_15441()).drawOutLine((class_1799)am.method_15442(), context, xPos, yPos, false, false, Color.WHITE);
                }
            }
            if (DetailArmorBar.getConfig().getOptions().toggleEnchants && totalEnchants > 0 && totalArmorPoint > 0) {
                if (DetailArmorBar.getConfig().getOptions().toggleAlignEnchantments) {
                    int displayedArmorIcons = Math.min(10, (int)Math.ceil((double)totalArmorPoint / 2.0));
                    boolean useUniformColor = DetailArmorBar.getConfig().getOptions().toggleUniformColor;
                    Color baseUniformColor = useUniformColor ? DetailArmorBar.getConfig().getOptions().uniformColorType.getColor() : null;
                    Color animatedUniformColor = baseUniformColor != null ? ArmorBarRenderer.getAnimatedUniformColor(baseUniformColor) : null;
                    for (int count5 = 0; count5 < displayedArmorIcons; ++count5) {
                        boolean hasSecondPoint;
                        xPos = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count5) * 8 : screenWidth + count5 * 8;
                        int armorIndex = count5 * 2 + stackRow;
                        int nextArmorIndex = armorIndex + 1;
                        boolean hasFirstPoint = armorIndex < totalArmorPoint;
                        boolean bl = hasSecondPoint = nextArmorIndex < totalArmorPoint;
                        if (!hasFirstPoint && !hasSecondPoint) continue;
                        if (useUniformColor) {
                            if (hasFirstPoint && hasSecondPoint) {
                                this.drawEnchantTexture(context, xPos, yPos, animatedUniformColor, 0);
                                continue;
                            }
                            if (hasFirstPoint) {
                                this.drawEnchantTexture(context, xPos, yPos, animatedUniformColor, 2);
                                continue;
                            }
                            if (!hasSecondPoint) continue;
                            this.drawEnchantTexture(context, xPos, yPos, animatedUniformColor, 1);
                            continue;
                        }
                        if (hasFirstPoint && !(armorItem = (class_1799)armorPoints.get(armorIndex).method_15442()).method_7960()) {
                            LevelData armorGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem), (class_5321<class_1887>)class_1893.field_9111);
                            LevelData armorProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem), (class_5321<class_1887>)class_1893.field_9096);
                            LevelData armorExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem), (class_5321<class_1887>)class_1893.field_9107);
                            LevelData armorFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem), (class_5321<class_1887>)class_1893.field_9095);
                            int[] armorProtectArr = new int[]{armorGeneric.level, armorProjectile.level, armorExplosive.level, armorFire.level, 0};
                            if (Arrays.stream(armorProtectArr).sum() > 0) {
                                if (hasSecondPoint) {
                                    class_1799 nextArmorItem2 = (class_1799)armorPoints.get(nextArmorIndex).method_15442();
                                    if (!nextArmorItem2.method_7960()) {
                                        LevelData nextGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem2), (class_5321<class_1887>)class_1893.field_9111);
                                        LevelData nextProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem2), (class_5321<class_1887>)class_1893.field_9096);
                                        LevelData nextExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem2), (class_5321<class_1887>)class_1893.field_9107);
                                        LevelData nextFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem2), (class_5321<class_1887>)class_1893.field_9095);
                                        if (armorGeneric.level == nextGeneric.level && armorProjectile.level == nextProjectile.level && armorExplosive.level == nextExplosive.level && armorFire.level == nextFire.level) {
                                            this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(armorProtectArr), 0);
                                        } else {
                                            this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(armorProtectArr), 2);
                                        }
                                    } else {
                                        this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(armorProtectArr), 2);
                                    }
                                } else {
                                    this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(armorProtectArr), 2);
                                }
                            }
                        }
                        if (!hasSecondPoint || (nextArmorItem = (class_1799)armorPoints.get(nextArmorIndex).method_15442()).method_7960()) continue;
                        LevelData nextGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem), (class_5321<class_1887>)class_1893.field_9111);
                        LevelData nextProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem), (class_5321<class_1887>)class_1893.field_9096);
                        LevelData nextExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem), (class_5321<class_1887>)class_1893.field_9107);
                        LevelData nextFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem), (class_5321<class_1887>)class_1893.field_9095);
                        int[] nextProtectArr = new int[]{nextGeneric.level, nextProjectile.level, nextExplosive.level, nextFire.level, 0};
                        if (Arrays.stream(nextProtectArr).sum() <= 0) continue;
                        if (hasFirstPoint) {
                            class_1799 armorItem2 = (class_1799)armorPoints.get(armorIndex).method_15442();
                            if (armorItem2.method_7960()) continue;
                            LevelData armorGeneric = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem2), (class_5321<class_1887>)class_1893.field_9111);
                            LevelData armorProjectile = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem2), (class_5321<class_1887>)class_1893.field_9096);
                            LevelData armorExplosive = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem2), (class_5321<class_1887>)class_1893.field_9107);
                            LevelData armorFire = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem2), (class_5321<class_1887>)class_1893.field_9095);
                            if (armorGeneric.level == nextGeneric.level && armorProjectile.level == nextProjectile.level && armorExplosive.level == nextExplosive.level && armorFire.level == nextFire.level) continue;
                            this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(nextProtectArr), 1);
                            continue;
                        }
                        this.drawEnchantTexture(context, xPos, yPos, ArmorBarRenderer.getProtectColor(nextProtectArr), 1);
                    }
                } else {
                    int maxSlots = 10;
                    for (count = 0; count * 2 + 1 <= totalEnchants && count < maxSlots; ++count) {
                        int xPos5 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count) * 8 : screenWidth + count * 8;
                        if (count * 2 + 1 < totalEnchants) {
                            int min = -1;
                            int max = -1;
                            for (int pw = 0; pw < 5; ++pw) {
                                if (min == -1 && protectArr[pw] > 1) {
                                    min = pw;
                                    break;
                                }
                                if (min == -1 && protectArr[pw] == 1) {
                                    min = pw;
                                    continue;
                                }
                                if (min == -1 || max != -1 || protectArr[pw] < 1) continue;
                                max = pw;
                            }
                            if (min != -1 && max != -1) {
                                this.drawEnchantTexture(context, xPos5, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
                                protectArr[min] = 0;
                                this.drawEnchantTexture(context, xPos5, yPos, ArmorBarRenderer.getProtectColor(protectArr), 1);
                                int n = max;
                                protectArr[n] = protectArr[n] - 1;
                            } else {
                                this.drawEnchantTexture(context, xPos5, yPos, ArmorBarRenderer.getProtectColor(protectArr), 0);
                                int n = min;
                                protectArr[n] = protectArr[n] - 2;
                            }
                        }
                        if (count * 2 + 1 != totalEnchants) continue;
                        this.drawEnchantTexture(context, xPos5, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
                    }
                }
            }
            if (!DetailArmorBar.getConfig().getOptions().toggleThorns || thorns.level <= 0 || totalArmorPoint <= 0) break block53;
            Color thornsColor = ArmorBarRenderer.getThornColor();
            if (DetailArmorBar.getConfig().getOptions().toggleAlignEnchantments) {
                int displayedArmorIcons = Math.min(10, (int)Math.ceil((double)totalArmorPoint / 2.0));
                for (int count6 = 0; count6 < displayedArmorIcons; ++count6) {
                    LevelData thornLevel;
                    boolean hasSecondPoint;
                    int xPos6 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count6) * 8 : screenWidth + count6 * 8;
                    int armorIndex = count6 * 2 + stackRow;
                    int nextArmorIndex = armorIndex + 1;
                    boolean hasFirstPoint = armorIndex < totalArmorPoint;
                    boolean bl = hasSecondPoint = nextArmorIndex < totalArmorPoint;
                    if (!hasFirstPoint && !hasSecondPoint) continue;
                    boolean firstHasThorns = false;
                    boolean secondHasThorns = false;
                    if (hasFirstPoint && !(armorItem = (class_1799)armorPoints.get(armorIndex).method_15442()).method_7960()) {
                        thornLevel = ArmorBarRenderer.getEnchantLevel(Collections.singleton(armorItem), (class_5321<class_1887>)class_1893.field_9097);
                        boolean bl2 = firstHasThorns = thornLevel.level > 0;
                    }
                    if (hasSecondPoint && !(nextArmorItem = (class_1799)armorPoints.get(nextArmorIndex).method_15442()).method_7960()) {
                        thornLevel = ArmorBarRenderer.getEnchantLevel(Collections.singleton(nextArmorItem), (class_5321<class_1887>)class_1893.field_9097);
                        boolean bl3 = secondHasThorns = thornLevel.level > 0;
                    }
                    if (firstHasThorns && secondHasThorns) {
                        InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, xPos6, yPos, 36, 18, thornsColor, false);
                        continue;
                    }
                    if (firstHasThorns) {
                        InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, xPos6, yPos, 27, 18, thornsColor, false);
                        continue;
                    }
                    if (!secondHasThorns) continue;
                    InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, xPos6, yPos, 27, 18, thornsColor, true);
                }
            } else {
                int maxSlots = 10;
                for (int count7 = 0; count7 < maxSlots && count7 * 2 + 1 <= thorns.level; ++count7) {
                    int xPos7 = DetailArmorBar.getConfig().getOptions().toggleInverseSlot ? screenWidth + (9 - count7) * 8 : screenWidth + count7 * 8;
                    if (count7 * 2 + 1 < thorns.level) {
                        InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, xPos7, yPos, 36, 18, thornsColor, false);
                    }
                    if (count7 * 2 + 1 != thorns.level) continue;
                    InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, xPos7, yPos, 27, 18, thornsColor, false);
                }
            }
        }
    }

    private void drawEnchantTexture(class_332 context, int x, int y, Color color, int half) {
        int u = 0;
        int v = 0;
        float speedFactor = 1.0f;
        switch (DetailArmorBar.getConfig().getOptions().effectSpeed) {
            case VERY_SLOW: {
                speedFactor = 0.5f;
                break;
            }
            case SLOW: {
                speedFactor = 0.75f;
                break;
            }
            case FAST: {
                speedFactor = 1.25f;
                break;
            }
            case VERY_FAST: {
                speedFactor = 1.5f;
            }
        }
        int tickDivisor = Math.max(1, Math.round(3.0f / speedFactor));
        int t = this.hud.method_1738() / tickDivisor % 36;
        if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA) {
            if (t < 12) {
                u = t % 12 * 9;
                v = 27 + half * 9;
            }
        } else if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE) {
            u = 9 + half * 9;
        } else {
            return;
        }
        InGameDrawer.drawTexture(DetailArmorBar.GUI_ARMOR_BAR, context, x, y, u, v, color, false);
    }

    private boolean hasMendingEnchant(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return ArmorBarRenderer.getEnchantLevel(Collections.singleton(stack), (class_5321<class_1887>)class_1893.field_9101).level > 0;
    }

    private void drawSparkleOverlay(class_332 context, int x, int y) {
        int star3Cycle;
        int star2Cycle;
        double fastAnimationSpeed;
        long currentTicks = DetailArmorBar.getTicks();
        int star1Cycle = (int)((double)currentTicks / (fastAnimationSpeed = (double)ArmorBarRenderer.getAnimationSpeed() / 2.5) % 12.0);
        if (star1Cycle < 6) {
            this.drawStar(context, x + 1, y + 1, star1Cycle % 3);
        }
        if ((star2Cycle = (int)((double)(currentTicks + 4L) / (fastAnimationSpeed * 0.8) % 12.0)) < 6) {
            this.drawStar(context, x + 6, y + 3, star2Cycle % 3);
        }
        if ((star3Cycle = (int)((double)(currentTicks + 8L) / (fastAnimationSpeed * 0.6) % 12.0)) < 6) {
            this.drawStar(context, x + 2, y + 6, star3Cycle % 3);
        }
    }

    private void drawStar(class_332 context, int x, int y, int frame) {
        int alpha = 255;
        if (frame == 0) {
            alpha = 100;
        } else if (frame == 1) {
            alpha = 200;
        } else if (frame == 2) {
            alpha = 255;
        }
        int color = alpha << 24 | 0xFFFFFF;
        context.method_25294(x + 1, y + 1, x + 2, y + 2, color);
        context.method_25294(x + 1, y, x + 2, y + 1, color);
        context.method_25294(x + 1, y + 2, x + 2, y + 3, color);
        context.method_25294(x, y + 1, x + 1, y + 2, color);
        context.method_25294(x + 2, y + 1, x + 3, y + 2, color);
    }

    static class LevelData {
        int level;
        int count;

        LevelData(int level, int count) {
            this.level = level;
            this.count = count;
        }
    }
}

