/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import java.util.Optional;
import java.util.UUID;
import mc.smpessentials.claims.model.ClaimData;
import mc.smpessentials.claims.storage.ClaimedSavedData;
import mc.smpessentials.claims.storage.WhitelistSavedData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public final class ClaimAccess {
    private ClaimAccess() {
    }

    public static boolean canModify(ServerPlayer actor, ServerLevel level, ChunkPos chunk) {
        if (actor.getServer().getPlayerList().isOp(actor.getGameProfile())) {
            return true;
        }
        ClaimedSavedData claims = ClaimedSavedData.get(level);
        Optional<ClaimData> cd = claims.getClaim(level, chunk);
        if (cd.isEmpty()) {
            return true;
        }
        UUID owner = cd.get().owner();
        return WhitelistSavedData.get(level).isTrusted(owner, actor.getUUID());
    }
}

