/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import java.util.UUID;
import mc.smpessentials.claims.ClaimService;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public final class ClaimCommands {
    private ClaimCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"claim").requires(src -> src.getEntity() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel lvl = p.level();
            ChunkPos pos = p.chunkPosition();
            ClaimService.Result result = ClaimService.claim(p, lvl, pos);
            switch (result) {
                case SUCCESS: {
                    ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Chunk claimed."));
                    break;
                }
                case ALREADY_CLAIMED: {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"This claim is already protected."));
                    break;
                }
                case REACHED_CAP: {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You reached the claim limit (50)."));
                    break;
                }
                case SPAWN_PROTECTED: {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You can\u2019t claim inside spawn protection."));
                }
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unclaim").requires(src -> src.getEntity() instanceof ServerPlayer)).executes(ctx -> {
            ChunkPos pos;
            ServerLevel lvl;
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            boolean ok = ClaimService.unclaim(p, lvl = p.level(), pos = p.chunkPosition());
            if (ok) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Chunk unclaimed."));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You don\u2019t control this claim."));
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"claims").requires(src -> src.getEntity() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel lvl = p.level();
            ChunkPos pos = p.chunkPosition();
            int mine = ClaimService.ownedCount(lvl, p.getUUID());
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("You own " + mine + " chunk(s) in this dimension.")));
            Optional<UUID> owner = ClaimService.getOwner(lvl, pos);
            if (owner.isPresent()) {
                boolean you = owner.get().equals(p.getUUID());
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)(you ? "This chunk is protected by you." : "This chunk is protected.")));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Current chunk is unclaimed."));
            }
            return 1;
        }));
    }
}

