/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import java.util.Optional;
import java.util.UUID;
import mc.smpessentials.claims.model.ClaimData;
import mc.smpessentials.claims.storage.ClaimedSavedData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public final class ClaimManager {
    private final ClaimedSavedData data;
    private final ServerLevel level;

    private ClaimManager(ClaimedSavedData data, ServerLevel level) {
        this.data = data;
        this.level = level;
    }

    public static ClaimManager get(ServerLevel level) {
        return new ClaimManager(ClaimedSavedData.get(level), level);
    }

    public boolean isClaimed(ChunkPos pos) {
        return this.data.isClaimed(this.level, pos);
    }

    public Optional<ClaimData> get(ChunkPos pos) {
        return this.data.getClaim(this.level, pos);
    }

    public void claim(ChunkPos pos, UUID owner) {
        this.data.claim(this.level, pos, owner);
    }

    public boolean unclaimIfOwned(ChunkPos pos, UUID owner) {
        Optional<ClaimData> cd = this.data.getClaim(this.level, pos);
        if (cd.isEmpty() || !cd.get().owner().equals(owner)) {
            return false;
        }
        return this.data.unclaim(this.level, pos);
    }

    public boolean forceUnclaim(ChunkPos pos) {
        return this.data.unclaim(this.level, pos);
    }

    public int ownedCount(UUID owner) {
        return this.data.countByOwner(this.level, owner);
    }
}

