/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import mc.smpessentials.claims.ClaimAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.ChunkPos;

public final class ClaimProtection {
    private ClaimProtection() {
    }

    public static void init() {
        BlockEvent.BREAK.register((level, pos, state, player, exp) -> {
            if (!(player instanceof ServerPlayer)) {
                return EventResult.pass();
            }
            ServerPlayer sp = player;
            ServerLevel sl = (ServerLevel)level;
            boolean ok = ClaimAccess.canModify(sp, sl, new ChunkPos(pos));
            return ok ? EventResult.pass() : EventResult.interruptFalse();
        });
        BlockEvent.PLACE.register((level, pos, state, placer) -> {
            if (!(placer instanceof ServerPlayer)) {
                return EventResult.pass();
            }
            ServerPlayer sp = (ServerPlayer)placer;
            ServerLevel sl = (ServerLevel)level;
            boolean ok = ClaimAccess.canModify(sp, sl, new ChunkPos(pos));
            return ok ? EventResult.pass() : EventResult.interruptFalse();
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> {
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.PASS;
            }
            ServerPlayer sp = (ServerPlayer)player;
            ServerLevel sl = sp.level();
            boolean ok = ClaimAccess.canModify(sp, sl, new ChunkPos(pos));
            return ok ? InteractionResult.PASS : InteractionResult.FAIL;
        });
    }
}

