/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import java.util.Optional;
import java.util.UUID;
import mc.smpessentials.claims.ClaimManager;
import mc.smpessentials.claims.model.ClaimData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public final class ClaimService {
    public static final int MAX_PER_PLAYER = 50;

    private ClaimService() {
    }

    public static Optional<UUID> getOwner(ServerLevel level, ChunkPos pos) {
        return ClaimManager.get(level).get(pos).map(ClaimData::owner);
    }

    public static int ownedCount(ServerLevel level, UUID owner) {
        return ClaimManager.get(level).ownedCount(owner);
    }

    public static boolean unclaim(ServerPlayer player, ServerLevel level, ChunkPos pos) {
        ClaimManager mgr = ClaimManager.get(level);
        Optional<ClaimData> existing = mgr.get(pos);
        if (existing.isEmpty()) {
            return false;
        }
        if (existing.get().owner().equals(player.getUUID())) {
            return mgr.unclaimIfOwned(pos, player.getUUID());
        }
        if (player.getServer().getPlayerList().isOp(player.getGameProfile())) {
            return mgr.forceUnclaim(pos);
        }
        return false;
    }

    public static Result claim(ServerPlayer player, ServerLevel level, ChunkPos pos) {
        ClaimManager mgr;
        if (level.dimension() == Level.OVERWORLD) {
            BlockPos spawn = level.getSharedSpawnPos();
            int radius = player.getServer().getSpawnRadius(level);
            if (radius > 0) {
                int dz;
                int cx = pos.getMiddleBlockX();
                int cz = pos.getMiddleBlockZ();
                int dx = Math.abs(cx - spawn.getX());
                if (Math.max(dx, dz = Math.abs(cz - spawn.getZ())) <= radius) {
                    return Result.SPAWN_PROTECTED;
                }
            }
            if (pos.equals((Object)new ChunkPos(spawn))) {
                return Result.SPAWN_PROTECTED;
            }
        }
        if ((mgr = ClaimManager.get(level)).isClaimed(pos)) {
            return Result.ALREADY_CLAIMED;
        }
        UUID me = player.getUUID();
        boolean isOp = player.getServer().getPlayerList().isOp(player.getGameProfile());
        if (ClaimService.ownedCount(level, me) >= 50 && !isOp) {
            return Result.REACHED_CAP;
        }
        mgr.claim(pos, me);
        return Result.SUCCESS;
    }

    public static enum Result {
        SUCCESS,
        ALREADY_CLAIMED,
        REACHED_CAP,
        SPAWN_PROTECTED;

    }
}

