/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mc.smpessentials.claims.storage.WhitelistSavedData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public final class TrustCommands {
    private TrustCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trust").requires(src -> src.getEntity() instanceof ServerPlayer)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = self.level();
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            boolean added = WhitelistSavedData.get(level).add(self.getUUID(), target.getUUID());
            if (added) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Trusted " + target.getGameProfile().getName() + " for all your claims.")));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(target.getGameProfile().getName() + " is already trusted.")));
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"untrust").requires(src -> src.getEntity() instanceof ServerPlayer)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = self.level();
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            boolean removed = WhitelistSavedData.get(level).remove(self.getUUID(), target.getUUID());
            if (removed) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Removed trust for " + target.getGameProfile().getName() + ".")));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(target.getGameProfile().getName() + " wasn\u2019t trusted.")));
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trustlist").requires(src -> src.getEntity() instanceof ServerPlayer)).executes(ctx -> {
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = self.level();
            Set<UUID> trusted = WhitelistSavedData.get(level).list(self.getUUID());
            if (trusted.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Your trust list is empty."));
                return 1;
            }
            String names = trusted.stream().map(uuid -> level.getServer().getPlayerList().getPlayer(uuid)).filter(Objects::nonNull).map(p -> p.getGameProfile().getName()).collect(Collectors.joining(", "));
            if (names.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Trusted: " + trusted.size() + " player(s).")));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Trusted: " + names)));
            }
            return 1;
        }));
    }
}

