/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mc.smpessentials.claims.model.ClaimData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class ClaimedSavedData
extends SavedData {
    private final List<ClaimData> claims;
    private final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<ClaimData>> indexByDim = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<ClaimData>>();
    public static final SavedDataType<ClaimedSavedData> TYPE = new SavedDataType("quackedsmp_claims", ctx -> new ClaimedSavedData(List.of()), ctx -> CODEC, DataFixTypes.LEVEL);
    public static final Codec<ClaimedSavedData> CODEC = RecordCodecBuilder.create(i -> i.group((App)ClaimData.CODEC.listOf().fieldOf("claims").forGetter(s -> s.claims)).apply((Applicative)i, ClaimedSavedData::new));

    public ClaimedSavedData(List<ClaimData> claims) {
        this.claims = new ArrayList<ClaimData>(claims);
        this.rebuildIndex();
    }

    public static ClaimedSavedData get(ServerLevel level) {
        return (ClaimedSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private void rebuildIndex() {
        this.indexByDim.clear();
        for (ClaimData c : this.claims) {
            this.indexByDim.computeIfAbsent(c.dimension(), k -> new Long2ObjectOpenHashMap()).put(c.chunk(), (Object)c);
        }
    }

    private Long2ObjectOpenHashMap<ClaimData> dimIndex(ResourceKey<Level> dim) {
        return this.indexByDim.computeIfAbsent(dim, k -> new Long2ObjectOpenHashMap());
    }

    public boolean isClaimed(ServerLevel level, ChunkPos chunk) {
        return this.dimIndex((ResourceKey<Level>)level.dimension()).containsKey(chunk.toLong());
    }

    public Optional<ClaimData> getClaim(ServerLevel level, ChunkPos chunk) {
        return Optional.ofNullable((ClaimData)this.dimIndex((ResourceKey<Level>)level.dimension()).get(chunk.toLong()));
    }

    public Optional<ClaimData> getClaimAt(ServerLevel level, BlockPos pos) {
        return this.getClaim(level, new ChunkPos(pos));
    }

    public boolean claim(ServerLevel level, ChunkPos chunk, UUID owner) {
        long key = chunk.toLong();
        Long2ObjectOpenHashMap<ClaimData> map = this.dimIndex((ResourceKey<Level>)level.dimension());
        if (map.containsKey(key)) {
            return false;
        }
        ClaimData cd = new ClaimData((ResourceKey<Level>)level.dimension(), key, owner, System.currentTimeMillis());
        map.put(key, (Object)cd);
        this.claims.add(cd);
        this.setDirty();
        return true;
    }

    public boolean unclaim(ServerLevel level, ChunkPos chunk) {
        long key = chunk.toLong();
        Long2ObjectOpenHashMap<ClaimData> map = this.dimIndex((ResourceKey<Level>)level.dimension());
        ClaimData removed = (ClaimData)map.remove(key);
        if (removed == null) {
            return false;
        }
        this.claims.remove(removed);
        this.setDirty();
        return true;
    }

    public List<ClaimData> listClaims(ServerLevel level) {
        return this.dimIndex((ResourceKey<Level>)level.dimension()).values().stream().collect(Collectors.toUnmodifiableList());
    }

    public int countByOwner(ServerLevel level, UUID owner) {
        Long2ObjectOpenHashMap<ClaimData> map = this.dimIndex((ResourceKey<Level>)level.dimension());
        int n = 0;
        for (ClaimData c : map.values()) {
            if (!c.owner().equals(owner)) continue;
            ++n;
        }
        return n;
    }
}

