/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.claims.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class WhitelistSavedData
extends SavedData {
    private final Map<UUID, Set<UUID>> byOwner;
    public static final Codec<WhitelistSavedData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.list(Entry.CODEC).fieldOf("entries").forGetter(s -> s.byOwner.entrySet().stream().map(e -> new Entry((UUID)e.getKey(), new ArrayList<UUID>((Collection)e.getValue()))).collect(Collectors.toList()))).apply((Applicative)i, entries -> {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (Entry e : entries) {
            map.put(e.owner, new HashSet<UUID>(e.trusted));
        }
        return new WhitelistSavedData((Map<UUID, Set<UUID>>)map);
    }));
    public static final SavedDataType<WhitelistSavedData> TYPE = new SavedDataType("quackedsmp_whitelist", ctx -> new WhitelistSavedData((Map<UUID, Set<UUID>>)new Object2ObjectOpenHashMap()), ctx -> CODEC, DataFixTypes.LEVEL);

    public WhitelistSavedData(Map<UUID, Set<UUID>> byOwner) {
        this.byOwner = byOwner;
    }

    public static WhitelistSavedData get(ServerLevel level) {
        return (WhitelistSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public boolean isTrusted(UUID owner, UUID actor) {
        if (owner.equals(actor)) {
            return true;
        }
        Set<UUID> set = this.byOwner.get(owner);
        return set != null && set.contains(actor);
    }

    public Set<UUID> list(UUID owner) {
        return Collections.unmodifiableSet(this.byOwner.getOrDefault(owner, Set.of()));
    }

    public boolean add(UUID owner, UUID trusted) {
        Set set = this.byOwner.computeIfAbsent(owner, k -> new HashSet());
        boolean changed = set.add(trusted);
        if (changed) {
            this.setDirty();
        }
        return changed;
    }

    public boolean remove(UUID owner, UUID trusted) {
        Set<UUID> set = this.byOwner.get(owner);
        if (set == null) {
            return false;
        }
        boolean changed = set.remove(trusted);
        if (changed) {
            this.setDirty();
        }
        if (set.isEmpty()) {
            this.byOwner.remove(owner);
        }
        return changed;
    }

    private record Entry(UUID owner, List<UUID> trusted) {
        static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtilPlus.CODEC.fieldOf("owner").forGetter(Entry::owner), (App)UUIDUtilPlus.CODEC.listOf().fieldOf("trusted").forGetter(Entry::trusted)).apply((Applicative)i, Entry::new));
    }

    public static final class UUIDUtilPlus {
        public static final Codec<UUID> CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);

        private UUIDUtilPlus() {
        }
    }
}

