/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.commands;

import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public final class HomeCommand {
    private HomeCommand() {
    }

    public static int execute(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.literal((String)"Only players can use /home."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.getRespawnConfig() != null) {
            TeleportTransition transition = player.findRespawnPositionAndUseSpawnBlock(false, p -> {});
            player.teleport(transition);
            source.sendSuccess(() -> Component.literal((String)"Teleported to your respawn point."), false);
            return 1;
        }
        ServerLevel level = source.getLevel();
        BlockPos spawn = level.getSharedSpawnPos();
        Vec3 target = new Vec3((double)spawn.getX() + 0.5, (double)spawn.getY(), (double)spawn.getZ() + 0.5);
        player.teleportTo(level, target.x, target.y, target.z, Set.of(), player.getYRot(), player.getXRot(), false);
        source.sendSuccess(() -> Component.literal((String)"No bed/anchor set. Teleported to world spawn."), false);
        return 1;
    }
}

