/*
 * Decompiled with CFR 0.152.
 */
package mc.smpessentials.commands;

import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class SpawnCommand {
    private SpawnCommand() {
    }

    public static int execute(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.literal((String)"Only players can use /spawn."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MinecraftServer server = player.getServer();
        ServerLevel overworld = server.overworld();
        BlockPos spawn = overworld.getSharedSpawnPos();
        BlockPos safe = player.adjustSpawnLocation(overworld, spawn);
        boolean ok = player.teleportTo(overworld, (double)safe.getX() + 0.5, (double)safe.getY(), (double)safe.getZ() + 0.5, Set.of(), player.getYRot(), player.getXRot(), false);
        if (ok) {
            player.sendSystemMessage((Component)Component.literal((String)"Teleported to spawn."));
            return 1;
        }
        player.sendSystemMessage((Component)Component.literal((String)"Failed to teleport to spawn."));
        return 0;
    }
}

