/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModOptionsScreen;
import net.dillon.qualityofqueso.util.ModTexts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.HashedStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonUtil {
    public static final String CHEESE_WHEEL = "cheese_wheel";
    public static final String ENABLED_TEXTURE = "qoq_enabled";
    public static final String DISABLED_TEXTURE = "qoq_disabled";

    public static Button initializeButton(Minecraft client, Screen parent, int width, int height) {
        return new Button.Builder(ModTexts.BLANK, button -> client.setScreen((Screen)new ModOptionsScreen(parent))).bounds(width, height, 20, 20).build();
    }

    public static void drawTooltipAndTexture(Component tooltip, String name, GuiGraphics graphics, Font font, Button button, int mouseX, int mouseY, @Nullable Float f) {
        if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && button.isHovered()) {
            ButtonUtil.drawTooltip(tooltip, graphics, font, mouseX, mouseY);
        }
        ButtonUtil.drawTexture(graphics, name, button, f == null ? 1.0f : f.floatValue());
    }

    public static void drawTooltip(Component tooltip, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        graphics.setTooltipForNextFrame(font, font.split((FormattedText)tooltip, 200), mouseX, mouseY);
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button, float f) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)("qualityofqueso:textures/gui/" + name + ".png")), button.getX() + 1, button.getY() + 1, 0.0f, 0.0f, 18, 18, 18, 18, ARGB.color((float)f, (int)-1));
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button) {
        ButtonUtil.drawTexture(graphics, name, button, 1.0f);
    }

    public static int getBarWidth(int backgroundWidth) {
        return (int)((double)backgroundWidth * 0.6);
    }

    public static int getButtonX(Button button) {
        return button.getX();
    }

    public static int getManagementButtonX(Screen screen, int backgroundWidth, int width) {
        int barWidth = ButtonUtil.getBarWidth(backgroundWidth);
        int modifier = 18;
        if (screen instanceof AbstractRecipeBookScreen) {
            AbstractRecipeBookScreen recipeBookScreen = (AbstractRecipeBookScreen)screen;
            modifier = 42;
            if (recipeBookScreen.recipeBookComponent.isVisible()) {
                modifier = 119;
            }
        }
        return width / 2 + barWidth / 2 + modifier;
    }

    public static int getManagementButtonY(Screen screen, Container inventory, int screenY, int titleY) {
        int y = 2 * inventory.getContainerSize() + 12;
        return screenY + titleY + (screen instanceof InventoryScreen ? 64 : y);
    }

    public static int getContainerSize(Container inventory) {
        return inventory.getContainerSize();
    }

    public static int getTotalSlots(AbstractContainerMenu handler) {
        return handler.slots.size();
    }

    public static int getInventorySize(AbstractContainerMenu handler, Container inventory) {
        return (Boolean)ModClientOptions.SEARCH_INVENTORY.get() != false ? handler.slots.size() : inventory.getContainerSize();
    }

    public static boolean isHotbarSlot(int totalSlots, int slotIndex) {
        return slotIndex >= totalSlots - 9;
    }

    public static boolean isInventoryHotbarSlot(boolean isInventoryScreen, int slotIndex) {
        return isInventoryScreen && slotIndex <= 44 && slotIndex >= 36;
    }

    public static boolean isExcludedSlot(Screen screen, int slotIndex) {
        return screen instanceof InventoryScreen && (slotIndex <= 8 && slotIndex >= 5 || slotIndex == 45);
    }

    public static boolean isAnySlotFilled(AbstractContainerMenu handler, boolean checkHotbar, int start, int end) {
        for (int i = start; i < ((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() != false && checkHotbar ? end + 9 : end); ++i) {
            Slot slot = handler.getSlot(i);
            if (!slot.hasItem()) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainerFull(AbstractContainerMenu handler, Container inv, boolean inventory) {
        int j = 0;
        int containerSize = ButtonUtil.getContainerSize(inv);
        for (int i = inventory ? containerSize : 0; i < (inventory ? containerSize + 36 : containerSize); ++i) {
            Slot slot = handler.getSlot(i);
            if (!slot.hasItem()) continue;
            ++j;
        }
        return j == (inventory ? 36 : containerSize);
    }

    public static boolean hoveredSlotHasItem(Slot focusedSlot) {
        return focusedSlot != null && focusedSlot.getItem() != ItemStack.EMPTY;
    }

    public static void swapItems(AbstractContainerMenu handler, Container inventory) {
        int totalSlots = ButtonUtil.getTotalSlots(handler);
        int containerSize = ButtonUtil.getContainerSize(inventory);
        int offset = totalSlots - 27 - 9;
        int swaps = Math.min(totalSlots - containerSize, containerSize);
        for (int i = 0; i < swaps; ++i) {
            int playerSlotIndex = i + offset;
            if (i >= totalSlots || playerSlotIndex >= totalSlots) continue;
            Slot chestSlot = handler.getSlot(i);
            Slot playerSlot = handler.getSlot(playerSlotIndex);
            ItemStack chestStack = chestSlot.getItem();
            ItemStack playerStack = playerSlot.getItem();
            if (chestStack.isEmpty() && playerStack.isEmpty()) continue;
            ButtonUtil.sendSwapSlotPacket(playerSlot.index, chestSlot.index);
        }
    }

    public static void sendSwapSlotPacket(int source, int index) {
        ButtonUtil.sendClickSlotPacket(source, ClickType.PICKUP);
        ButtonUtil.sendClickSlotPacket(index, ClickType.PICKUP);
        ButtonUtil.sendClickSlotPacket(source, ClickType.PICKUP);
    }

    public static void sendClickSlotPacket(int slotIndex, ClickType clickType) {
        Minecraft client = Minecraft.getInstance();
        ClientPacketListener networkHandler = client.getConnection();
        if (client.player == null || networkHandler == null || client.player.containerMenu == null) {
            return;
        }
        AbstractContainerMenu handler = client.player.containerMenu;
        int syncId = handler.containerId;
        int stateId = handler.getStateId();
        if (clickType == ClickType.THROW) {
            if (!handler.getSlot(slotIndex).getItem().isEmpty()) {
                client.gameMode.handleInventoryMouseClick(syncId, slotIndex, 1, clickType, (Player)client.player);
            }
            return;
        }
        ItemStack carriedStack = handler.getCarried();
        ItemStack clickedStack = handler.getSlot(slotIndex).getItem();
        HashedPatchMap.HashGenerator hasher = networkHandler.decoratedHashOpsGenenerator();
        HashedStack carriedHash = HashedStack.create((ItemStack)carriedStack, (HashedPatchMap.HashGenerator)hasher);
        HashedStack clickedHash = HashedStack.create((ItemStack)clickedStack, (HashedPatchMap.HashGenerator)hasher);
        Int2ObjectOpenHashMap modifiedStacks = new Int2ObjectOpenHashMap();
        modifiedStacks.put(slotIndex, (Object)clickedHash);
        ServerboundContainerClickPacket packet = new ServerboundContainerClickPacket(syncId, stateId, (short)slotIndex, 0, clickType, (Int2ObjectMap)modifiedStacks, carriedHash);
        networkHandler.send((Packet)packet);
    }

    public static boolean isQuicklyEquippable(ItemStack stack) {
        for (TagKey<Item> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
            if (!stack.is(quicklyEquippable) && !stack.is(Items.ELYTRA)) continue;
            return true;
        }
        return false;
    }

    public static void quickSwap(int sourceSlot, EquipmentSlot slot) {
        int slotIndex = slot == EquipmentSlot.HEAD ? 5 : (slot == EquipmentSlot.CHEST ? 6 : (slot == EquipmentSlot.LEGS ? 7 : (slot == EquipmentSlot.FEET ? 8 : 6)));
        ButtonUtil.sendSwapSlotPacket(sourceSlot, slotIndex);
    }

    public static void quickEquip(Screen screen, Slot focusedSlot) {
        if (((Boolean)ModClientOptions.QUICK_EQUIP.get()).booleanValue() && focusedSlot != null && focusedSlot.index >= 5 && (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen)) {
            ItemStack stack = focusedSlot.getItem();
            EquipmentSlot targetSlot = null;
            for (TagKey<Item> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
                if (!stack.is(quicklyEquippable)) continue;
                targetSlot = QoQ.quicklyEquippables.get(quicklyEquippable);
            }
            if (stack.is(Items.ELYTRA)) {
                targetSlot = EquipmentSlot.CHEST;
            }
            if (targetSlot != null) {
                Minecraft client = Minecraft.getInstance();
                ItemStack equippedStack = client.player.getItemBySlot(targetSlot);
                if (equippedStack.isEmpty()) {
                    ButtonUtil.sendClickSlotPacket(focusedSlot.index, ClickType.QUICK_MOVE);
                } else {
                    ButtonUtil.quickSwap(focusedSlot.index, targetSlot);
                }
            }
        }
    }

    public static void makeSlotUnavailable(GuiGraphics graphics, Slot slot, boolean hotbar) {
        int color = hotbar ? -2139062148 : -1275068416;
        graphics.fillGradient(slot.x, slot.y, slot.x + 16, slot.y + 16, color, color);
    }

    public static boolean isContainerScreen(Screen screen) {
        return screen instanceof ContainerScreen || screen instanceof ShulkerBoxScreen;
    }

    public static boolean isInventoryScreen(Screen screen) {
        return screen instanceof InventoryScreen;
    }

    public static boolean isCreativeInventoryScreen(Screen screen) {
        return screen instanceof CreativeModeInventoryScreen;
    }
}

