/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.dillon.qualityofqueso.keybind.ModKeybinds;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.screen.gui.SensitiveButton;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.dillon.qualityofqueso.util.ModTexts;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int topPos;
    @Shadow
    protected int titleLabelY;
    @Shadow
    @Final
    protected T menu;
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Unique
    private final AbstractContainerScreen<?> screen = (AbstractContainerScreen)this;
    @Unique
    private EditBox searchField;
    @Unique
    private AbstractWidget transferContainerButton;
    @Unique
    private AbstractWidget transferInventoryButton;
    @Unique
    private Container container;
    @Unique
    private boolean keepInventoryButtonActive = false;
    @Unique
    private final Map<TagKey<Item>, EquipmentSlot> quicklyEquippables = Map.of(ItemTags.HEAD_ARMOR, EquipmentSlot.HEAD, ItemTags.CHEST_ARMOR, EquipmentSlot.CHEST, ItemTags.LEG_ARMOR, EquipmentSlot.LEGS, ItemTags.FOOT_ARMOR, EquipmentSlot.FEET);

    @Shadow
    @Nullable
    public abstract Slot getSlotUnderMouse();

    protected AbstractContainerScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft) && this.isValidScreen()) {
            AbstractContainerScreen<?> abstractContainerScreen = this.screen;
            if (abstractContainerScreen instanceof ShulkerBoxScreen) {
                ShulkerBoxScreen shulkerBoxScreen = (ShulkerBoxScreen)abstractContainerScreen;
                this.container = ((ShulkerBoxMenu)shulkerBoxScreen.getMenu()).container;
            } else {
                abstractContainerScreen = this.screen;
                if (abstractContainerScreen instanceof ContainerScreen) {
                    ContainerScreen genericContainerScreen = (ContainerScreen)abstractContainerScreen;
                    this.container = ((ChestMenu)genericContainerScreen.getMenu()).getContainer();
                } else {
                    this.container = null;
                }
            }
            if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue()) {
                int barWidth = (int)((double)this.imageWidth * 0.6);
                this.searchField = new EditBox(this.font, this.width / 2 + barWidth / 2 - 64, this.topPos + this.titleLabelY - 2, 90, 12, null);
                if (((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue()) {
                    this.searchField.setValue(QoQ.SAVED_TEXT);
                }
                this.searchField.setMaxLength(50);
                this.searchField.setHint((Component)Component.translatable((String)"qualityofqueso.gui.search.placeholder").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                this.addRenderableWidget((GuiEventListener)this.searchField);
            }
            if (((Boolean)ModClientOptions.INVENTORY_MANAGEMENT.get()).booleanValue()) {
                this.transferContainerButton = (AbstractWidget)this.addWidget((GuiEventListener)new SensitiveButton(this.getTransferButtonX(true), this.getTransferButtonY(), 10, 10, ModTexts.BLANK, b -> this.transferItems(this.screen, true), () -> this.transferContainerButton.active));
                this.transferContainerButton.active = false;
            }
        }
    }

    @Unique
    private void transferItems(AbstractContainerScreen<?> screen, boolean reverse) {
        int containerSize = this.container.getContainerSize();
        int totalSlotSize = screen.getMenu().slots.size();
        int fromStart = reverse ? 0 : containerSize;
        int fromEnd = reverse ? containerSize : totalSlotSize;
        int toStart = reverse ? containerSize : 0;
        int toEnd = reverse ? totalSlotSize : containerSize;
        block0: for (int i = fromStart; i < fromEnd; ++i) {
            Slot fromSlot = screen.getMenu().getSlot(i);
            ItemStack fromStack = fromSlot.getItem();
            if (!((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && !reverse && this.isValidSlot(screen, fromSlot.index) || this.searchField != null && !this.getSearchFieldText().isEmpty() && !this.search(this.getSearchFieldText(), fromSlot) || fromStack.isEmpty()) continue;
            for (int j = toStart; j < toEnd; ++j) {
                Slot toSlot = screen.getMenu().getSlot(j);
                if (!toSlot.getItem().isEmpty()) continue;
                if (!this.getMenu().getCarried().isEmpty()) {
                    if (!fromStack.is(this.getMenu().getCarried().getItem())) continue;
                    this.sendClickSlotPacket(i, ClickType.QUICK_MOVE);
                    continue block0;
                }
                this.sendClickSlotPacket(i, ClickType.QUICK_MOVE);
                continue block0;
            }
        }
    }

    @Unique
    private void sendClickSlotPacket(int slotIndex, ClickType clickType) {
        Minecraft client = Minecraft.getInstance();
        ClientPacketListener listener = client.getConnection();
        if (client.player == null || listener == null || client.player.containerMenu == null) {
            return;
        }
        AbstractContainerMenu handler = client.player.containerMenu;
        int syncId = handler.containerId;
        int stateId = handler.getStateId();
        ItemStack carriedStack = handler.getCarried();
        ItemStack clickedStack = handler.getSlot(slotIndex).getItem();
        Int2ObjectOpenHashMap modifiedStacks = new Int2ObjectOpenHashMap();
        modifiedStacks.put(slotIndex, (Object)clickedStack);
        ServerboundContainerClickPacket packet = new ServerboundContainerClickPacket(syncId, stateId, (int)((short)slotIndex), 0, clickType, carriedStack, (Int2ObjectMap)modifiedStacks);
        listener.send((Packet)packet);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void grayOutSlot(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.searchField != null && !this.getSearchFieldText().isEmpty()) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                Slot slot = this.getMenu().getSlot(i);
                if (this.search(this.getSearchFieldText(), slot)) continue;
                this.makeSlotUnavailable(graphics, slot);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.searchField != null) {
            this.searchField.render(graphics, mouseX, mouseY, deltaTicks);
            if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && this.searchField.isHovered() && this.searchField.getValue().isEmpty()) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.chest_search.search_filtering"), graphics, this.font, mouseX, mouseY);
            }
        }
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.INVENTORY_MANAGEMENT.get()).booleanValue() && this.isValidScreen()) {
            this.shouldButtonBeActive(false, null, this.transferContainerButton);
            Inventory playerInventory = this.minecraft.player.getInventory();
            this.transferInventoryButton = (AbstractWidget)this.addWidget((GuiEventListener)new SensitiveButton(this.getTransferButtonX(false), this.getTransferButtonY(), 10, 10, ModTexts.BLANK, b -> this.transferItems(this.screen, false), () -> (this.altDown() || this.keepInventoryButtonActive) && !this.isPlayerInventoryEmpty(playerInventory)));
            boolean isTransferInventoryButtonHovered = this.transferInventoryButton.isMouseOver((double)mouseX, (double)mouseY);
            if (this.shouldButtonBeActive(true, playerInventory, this.transferInventoryButton)) {
                if (this.altDown()) {
                    this.transferInventoryButton.active = true;
                    this.keepInventoryButtonActive = isTransferInventoryButtonHovered;
                } else {
                    if (!isTransferInventoryButtonHovered) {
                        this.keepInventoryButtonActive = false;
                    }
                    this.transferInventoryButton.active = this.keepInventoryButtonActive;
                }
            }
            this.shouldButtonBeActive(true, playerInventory, this.transferInventoryButton);
            if (this.transferContainerButton != null) {
                if (!this.transferContainerButton.active) {
                    this.renderButtonTexture("transfer_container_button_inactive", true, this.transferContainerButton, graphics);
                } else {
                    this.renderButtonTexture(this.transferContainerButton.isMouseOver((double)mouseX, (double)mouseY) ? "transfer_container_button_hovered" : "transfer_container_button", true, this.transferContainerButton, graphics);
                }
                if (this.transferContainerButton.isMouseOver((double)mouseX, (double)mouseY)) {
                    if (!this.getMenu().getCarried().isEmpty()) {
                        ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.transfer_container_button.with_cursor_stack", (Object[])new Object[]{this.getMenu().getCarried().getHoverName().getString()}), graphics, this.font, mouseX, mouseY);
                    } else if (!this.getSearchFieldText().isEmpty()) {
                        ButtonUtil.drawTooltip((Component)(this.getSearchFieldText().startsWith("#") ? Component.translatable((String)"qualityofqueso.gui.transfer_container_button.with_search_query.tag", (Object[])new Object[]{this.getSearchFieldText().substring(1)}) : (this.getSearchFieldText().startsWith("!") ? Component.translatable((String)"qualityofqueso.gui.transfer_container_button.with_search_query.exclude", (Object[])new Object[]{this.getSearchFieldText().substring(1)}) : Component.translatable((String)"qualityofqueso.gui.transfer_container_button.with_search_query", (Object[])new Object[]{this.getSearchFieldText()}))), graphics, this.font, mouseX, mouseY);
                    } else {
                        ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.transfer_container_button"), graphics, this.font, mouseX, mouseY);
                    }
                }
            }
            if (!this.shouldButtonBeActive(true, playerInventory, this.transferInventoryButton)) {
                this.renderButtonTexture("transfer_inventory_button_inactive", true, this.transferInventoryButton, graphics);
            } else if (!this.altDown()) {
                this.renderButtonTexture("transfer_inventory_button_hold_alt", true, this.transferInventoryButton, graphics);
            } else {
                this.renderButtonTexture(this.transferInventoryButton.isMouseOver((double)mouseX, (double)mouseY) ? "transfer_inventory_button_hovered" : "transfer_inventory_button", true, this.transferInventoryButton, graphics);
            }
            AbstractWidget includeHotbarButton = (AbstractWidget)this.addWidget((GuiEventListener)Button.builder((Component)ModTexts.BLANK, button -> {
                ModClientOptions.INCLUDE_HOTBAR.set((Object)((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() == false ? 1 : 0));
                ModClientOptions.SPEC.save();
            }).bounds(this.getTransferButtonX(false) - 12, this.getTransferButtonY(), 10, 10).build());
            if (includeHotbarButton.isMouseOver((double)mouseX, (double)mouseY)) {
                if (((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue()) {
                    this.renderButtonTexture("include_hotbar_button_hovered", false, includeHotbarButton, graphics);
                    ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.include_hotbar"), graphics, this.font, mouseX, mouseY);
                } else {
                    this.renderButtonTexture("exclude_hotbar_button_hovered", false, includeHotbarButton, graphics);
                    ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.exclude_hotbar"), graphics, this.font, mouseX, mouseY);
                }
            } else if (((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue()) {
                this.renderButtonTexture("include_hotbar_button", false, includeHotbarButton, graphics);
            } else {
                this.renderButtonTexture("exclude_hotbar_button", false, includeHotbarButton, graphics);
            }
            if (isTransferInventoryButtonHovered) {
                if (this.transferInventoryButton.active && this.altDown()) {
                    if (!this.getMenu().getCarried().isEmpty()) {
                        ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button.with_cursor_stack", (Object[])new Object[]{this.getMenu().getCarried().getHoverName().getString()}), graphics, this.font, mouseX, mouseY);
                    } else if (!this.getSearchFieldText().isEmpty() && ((Boolean)ModClientOptions.SEARCH_INVENTORY.get()).booleanValue()) {
                        ButtonUtil.drawTooltip((Component)(this.getSearchFieldText().startsWith("#") ? Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button.with_search_query.tag", (Object[])new Object[]{this.getSearchFieldText().substring(1)}) : (this.getSearchFieldText().startsWith("!") ? Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button.with_search_query.exclude", (Object[])new Object[]{this.getSearchFieldText().substring(1)}) : Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button.with_search_query", (Object[])new Object[]{this.getSearchFieldText()}))), graphics, this.font, mouseX, mouseY);
                    } else {
                        ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button"), graphics, this.font, mouseX, mouseY);
                    }
                } else if (this.shouldButtonBeActive(true, playerInventory, this.transferInventoryButton)) {
                    ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.transfer_inventory_button.hold_alt"), graphics, this.font, mouseX, mouseY);
                }
            }
        }
    }

    @Unique
    private String getSearchFieldText() {
        return this.searchField != null ? this.searchField.getValue() : "";
    }

    @Unique
    private int getInventorySize() {
        return (Boolean)ModClientOptions.SEARCH_INVENTORY.get() != false ? ((AbstractContainerMenu)this.menu).slots.size() : this.container.getContainerSize();
    }

    @Unique
    private boolean hoveredSlotHasItem() {
        return this.hoveredSlot != null && this.hoveredSlot.getItem() != ItemStack.EMPTY;
    }

    @Unique
    private boolean altDown() {
        return (Boolean)ModClientOptions.REQUIRE_ALT_TO_MOVE.get() == false || Screen.hasAltDown();
    }

    @Unique
    private int getTransferButtonX(boolean chestToInventory) {
        int barWidth = (int)((double)this.imageWidth * 0.6);
        return chestToInventory ? this.width / 2 + barWidth / 2 + 16 : this.width / 2 + barWidth / 2 + 4;
    }

    @Unique
    private int getTransferButtonY() {
        int y = 120;
        if (this.container.getContainerSize() == 27) {
            y = 66;
        } else if (this.container.getContainerSize() == 36) {
            y = 84;
        } else if (this.container.getContainerSize() == 45) {
            y = 102;
        }
        return this.topPos + this.titleLabelY + y;
    }

    @Unique
    private void makeSlotUnavailable(GuiGraphics graphics, Slot slot) {
        graphics.fillGradient(RenderType.guiOverlay(), slot.x, slot.y, slot.x + 16, slot.y + 16, -1275068416, -1275068416, 0);
    }

    @Unique
    private void renderButtonTexture(String id, boolean transferable, AbstractWidget buttonReference, GuiGraphics graphics) {
        String transferableString = !this.getMenu().getCarried().isEmpty() ? "_with_stack.png" : (this.getSearchFieldText().startsWith("!") ? "_exclude.png" : (this.getSearchFieldText().startsWith("#") ? "_with_tag.png" : ".png"));
        String appended = transferable ? transferableString : ".png";
        graphics.blit(ResourceLocation.parse((String)("qualityofqueso:textures/gui/" + id + appended)), buttonReference.getX() - 1, buttonReference.getY() - 1, 0.0f, 0.0f, 12, 12, 12, 12);
    }

    @Unique
    private boolean shouldButtonBeActive(boolean isPlayerInventory, @Nullable Inventory playerInventory, AbstractWidget button) {
        if (button == null) {
            return false;
        }
        int size = isPlayerInventory ? playerInventory.getContainerSize() : this.container.getContainerSize();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = isPlayerInventory ? playerInventory.getItem(i) : this.getMenu().getSlot(i).getItem();
            if (!this.getMenu().getCarried().isEmpty()) {
                if (!stack.is(this.getMenu().getCarried().getItem())) continue;
                ++j;
                button.active = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            ++j;
            button.active = true;
        }
        if (j == 0 || this.areAllSlotsUnavailable(isPlayerInventory, (Inventory)(isPlayerInventory ? playerInventory : null))) {
            button.active = false;
            return false;
        }
        return true;
    }

    @Unique
    private boolean areAllSlotsUnavailable(boolean isPlayerInventory, @Nullable Inventory playerInventory) {
        int j = 0;
        ArrayList<Slot> playerSlots = new ArrayList<Slot>();
        if (isPlayerInventory) {
            for (Slot s : this.getMenu().slots) {
                if (s.container != playerInventory) continue;
                playerSlots.add(s);
            }
            for (Slot slot : playerSlots) {
                if (!this.search(this.getSearchFieldText(), slot)) continue;
                ++j;
            }
        } else {
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                Slot slot = this.getMenu().getSlot(i);
                if (!this.search(this.getSearchFieldText(), slot)) continue;
                ++j;
            }
        }
        return j == 0;
    }

    @Unique
    private boolean isPlayerInventoryEmpty(Inventory inventory) {
        for (ItemStack stack : inventory.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Unique
    private boolean search(String searchQuery, Slot slot) {
        String[] terms;
        ItemStack stack = slot.getItem();
        if (stack.isEmpty() || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && ((Boolean)ModClientOptions.SEARCH_INVENTORY.get()).booleanValue() && this.isValidSlot(this.screen, slot.index)) {
            return false;
        }
        String itemName = stack.getHoverName().getString().toLowerCase();
        for (String term : terms = searchQuery.split(",")) {
            if (!itemName.contains(term.trim().toLowerCase())) continue;
            return true;
        }
        if (searchQuery.startsWith("!")) {
            return !itemName.contains(searchQuery.substring(1));
        }
        if (searchQuery.startsWith("#")) {
            String tagSearch = searchQuery.substring(1);
            RegistryAccess lookup = Minecraft.getInstance().level.registryAccess();
            Registry itemRegistry = lookup.registryOrThrow(Registries.ITEM);
            for (Pair tag : itemRegistry.getTags().toList()) {
                ResourceLocation location = ((TagKey)tag.getFirst()).location();
                if (!location.getPath().toLowerCase().contains(tagSearch) && !location.toString().toLowerCase().contains(tagSearch) || !stack.is((TagKey)tag.getFirst())) continue;
                return true;
            }
        }
        if (stack.isEnchanted() || stack.is(Items.ENCHANTED_BOOK)) {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            for (Holder enchantment : enchantments.keySet()) {
                String encName = ((Enchantment)enchantment.value()).description().getString();
                String fullName = encName + " " + enchantments.getLevel(enchantment);
                if (!fullName.toLowerCase().contains(searchQuery)) continue;
                return true;
            }
        }
        return itemName.contains(searchQuery);
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAllItemTagsToTooltip(GuiGraphics graphics, int x, int y, CallbackInfo ci) {
        String searchQuery = this.getSearchFieldText();
        if (this.searchField != null) {
            if (!searchQuery.startsWith("#")) {
                return;
            }
            Slot hoveredSlot = this.getSlotUnderMouse();
            if (hoveredSlot == null || !hoveredSlot.hasItem()) {
                return;
            }
            ItemStack stack = hoveredSlot.getItem();
            Registry itemRegistry = this.minecraft.level.registryAccess().registryOrThrow(Registries.ITEM);
            List originalTooltip = stack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)this.minecraft.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            boolean foundTags = false;
            for (Pair tag : itemRegistry.getTags().toList()) {
                if (!stack.is((TagKey)tag.getFirst())) continue;
                String tagString = "#" + String.valueOf(((TagKey)tag.getFirst()).location());
                originalTooltip.add(1, Component.literal((String)tagString).withStyle(ChatFormatting.LIGHT_PURPLE));
                foundTags = true;
            }
            if (foundTags) {
                graphics.renderTooltip(this.font, originalTooltip, Optional.empty(), x, y);
                ci.cancel();
            }
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseClicking(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.minecraft) && button == 1 && this.hoveredSlot != null && this.isQuicklyEquippable(this.hoveredSlot.getItem())) {
            this.quickEquip();
            cir.setReturnValue((Object)true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleKeyPressing(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        AbstractContainerScreen<?> abstractContainerScreen;
        boolean cannotType;
        if (!QoQ.modEnabled(this.minecraft)) return;
        if (Screen.hasControlDown()) {
            if (this.transferContainerButton != null && this.transferContainerButton.active && keyCode == ModKeybinds.MOVE_TO_INVENTORY.getKey().getValue()) {
                this.transferItems(this.screen, true);
            }
            if (this.transferInventoryButton != null && this.transferInventoryButton.active && keyCode == ModKeybinds.MOVE_TO_CONTAINER.getKey().getValue()) {
                this.transferItems(this.screen, false);
            }
        }
        if (keyCode == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
            this.quickEquip();
        }
        if (keyCode == 69 && ((Boolean)ModClientOptions.PREVENT_E_FROM_TYPING.get()).booleanValue() && (this.screen instanceof InventoryScreen || this.screen instanceof CreativeModeInventoryScreen)) {
            this.onClose();
            cir.setReturnValue((Object)true);
        }
        boolean ignoreTyping = this.hoveredSlotHasItem();
        boolean secondaryIgnoreTyping = false;
        boolean numberKeyPressed = false;
        boolean hotbarKeyPressed = false;
        boolean dropKeyPressed = false;
        boolean swapKeyPressed = false;
        for (int key : QoQ.allDisallowedKeys) {
            if (keyCode != key) continue;
            ignoreTyping = true;
            secondaryIgnoreTyping = true;
            break;
        }
        if (this.getMenu().getCarried().isEmpty() && this.hoveredSlot != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.minecraft.options.keyHotbarSlots[i].matches(keyCode, scanCode)) continue;
                ignoreTyping = true;
                secondaryIgnoreTyping = true;
                hotbarKeyPressed = true;
                break;
            }
            if (this.screen instanceof InventoryScreen && keyCode == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
                ignoreTyping = true;
            }
        }
        for (int key : QoQ.popularKeys) {
            if (keyCode != key) continue;
            secondaryIgnoreTyping = false;
            cir.setReturnValue((Object)true);
            break;
        }
        List<Integer> numbers = List.of(Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(51), Integer.valueOf(52), Integer.valueOf(53), Integer.valueOf(54), Integer.valueOf(55), Integer.valueOf(56), Integer.valueOf(57));
        for (int key : numbers) {
            if (keyCode != key) continue;
            numberKeyPressed = true;
            break;
        }
        if (keyCode == Minecraft.getInstance().options.keyDrop.getKey().getValue()) {
            secondaryIgnoreTyping = true;
            dropKeyPressed = true;
        } else if (keyCode == Minecraft.getInstance().options.keySwapOffhand.getKey().getValue()) {
            secondaryIgnoreTyping = true;
            swapKeyPressed = true;
        }
        boolean bl = cannotType = (numberKeyPressed || hotbarKeyPressed || dropKeyPressed || swapKeyPressed) && this.hoveredSlotHasItem();
        if (((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue() && (abstractContainerScreen = this.screen) instanceof InventoryScreen) {
            InventoryScreen recipeScreen = (InventoryScreen)abstractContainerScreen;
            if (!Screen.hasControlDown()) {
                if (!ignoreTyping && !recipeScreen.getRecipeBookComponent().isVisible()) {
                    recipeScreen.getRecipeBookComponent().toggleVisibility();
                    this.repositionElements();
                }
                if (recipeScreen.getRecipeBookComponent().searchBox == null) return;
                recipeScreen.getRecipeBookComponent().searchBox.setFocused(!ignoreTyping);
                if (!recipeScreen.getRecipeBookComponent().searchBox.isFocused()) return;
                cir.setReturnValue((Object)(recipeScreen.getRecipeBookComponent().keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers) ? 1 : 0));
                return;
            }
        }
        if ((Boolean)ModClientOptions.CHEST_SEARCHING.get() == false) return;
        if (!this.isValidScreen()) return;
        if (!secondaryIgnoreTyping && !Screen.hasControlDown()) {
            this.searchField.setFocused(true);
        } else if (this.searchField.isFocused() && cannotType) {
            this.searchField.setFocused(false);
        }
        if (!this.searchField.isFocused()) return;
        if (!this.searchField.keyPressed(keyCode, scanCode, modifiers)) return;
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean isValidSlot(AbstractContainerScreen<?> screen, int slotIndex) {
        int totalSlots = screen.getMenu().slots.size();
        return slotIndex >= totalSlots - 9;
    }

    @Unique
    private boolean isQuicklyEquippable(ItemStack stack) {
        for (TagKey<Item> quicklyEquippable : this.quicklyEquippables.keySet()) {
            if (!stack.is(quicklyEquippable) && !stack.is(Items.ELYTRA)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private void quickSwap(int sourceSlot, EquipmentSlot slot) {
        int slotIndex = slot == EquipmentSlot.HEAD ? 5 : (slot == EquipmentSlot.CHEST ? 6 : (slot == EquipmentSlot.LEGS ? 7 : (slot == EquipmentSlot.FEET ? 8 : 6)));
        this.sendClickSlotPacket(sourceSlot, ClickType.PICKUP);
        this.sendClickSlotPacket(slotIndex, ClickType.PICKUP);
        this.sendClickSlotPacket(sourceSlot, ClickType.PICKUP);
    }

    @Unique
    private void quickEquip() {
        if (((Boolean)ModClientOptions.QUICK_EQUIP.get()).booleanValue() && this.hoveredSlot != null && this.hoveredSlot.index >= 5 && (this.screen instanceof InventoryScreen || this.screen instanceof CreativeModeInventoryScreen)) {
            ItemStack stack = this.hoveredSlot.getItem();
            EquipmentSlot targetSlot = null;
            for (TagKey<Item> quicklyEquippable : this.quicklyEquippables.keySet()) {
                if (!stack.is(quicklyEquippable)) continue;
                targetSlot = this.quicklyEquippables.get(quicklyEquippable);
            }
            if (stack.is(Items.ELYTRA)) {
                targetSlot = EquipmentSlot.CHEST;
            }
            if (targetSlot != null) {
                ItemStack equippedStack = this.minecraft.player.getItemBySlot(targetSlot);
                if (equippedStack.isEmpty()) {
                    this.sendClickSlotPacket(this.hoveredSlot.index, ClickType.QUICK_MOVE);
                } else {
                    this.quickSwap(this.hoveredSlot.index, targetSlot);
                }
            }
        }
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void closeButtonOnClickOutOfBounds(Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_GUI_EXIT.get()).booleanValue() && this.menu.getCarried().isEmpty() && mouseButton == 0 && slot == null) {
            this.onClose();
        }
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void saveSearchText(CallbackInfo ci) {
        if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && ((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue() && this.searchField != null && this.isValidScreen()) {
            QoQ.SAVED_TEXT = this.searchField.getValue();
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && this.searchField != null && this.searchField.isFocused()) {
            return this.searchField.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        if (this.searchField != null) {
            String text = this.getSearchFieldText();
            boolean refocus = this.searchField.isFocused();
            this.init(minecraft, width, height);
            this.searchField.setValue(text);
            this.searchField.setFocused(refocus);
        }
    }

    @Unique
    private boolean isValidScreen() {
        return this.screen instanceof ContainerScreen || this.screen instanceof ShulkerBoxScreen;
    }
}

