/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.option;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public abstract class BaseOptions<T> {
    private final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private final String fileName;
    private File file;
    protected T instance;

    protected BaseOptions(String fileName) {
        this.fileName = fileName;
        this.instance = this.createDefault();
    }

    protected abstract T createDefault();

    protected abstract Class<T> getConfigClass();

    public T getInstance() {
        return this.instance;
    }

    public void load() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.instance = this.createDefault();
        } else {
            try (FileReader reader = new FileReader(configFile);){
                this.instance = this.GSON.fromJson((Reader)reader, this.getConfigClass());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.instance = this.createDefault();
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.getConfigFile());){
            writer.write(this.GSON.toJson(this.instance));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        if (this.file == null) {
            this.file = new File(FabricLoader.getInstance().getConfigDir().toFile(), this.fileName);
        }
        return this.file;
    }
}

