/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModOptionsScreen;
import net.dillon.qualityofqueso.util.ModTexts;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10260;
import net.minecraft.class_10799;
import net.minecraft.class_10936;
import net.minecraft.class_10938;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2813;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_495;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_6862;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ButtonUtil {
    public static final String CHEESE_WHEEL = "cheese_wheel";
    public static final String ENABLED_TEXTURE = "qoq_enabled";
    public static final String DISABLED_TEXTURE = "qoq_disabled";

    public static class_4185 initializeButton(class_310 client, class_437 parent, int width, int height) {
        return new class_4185.class_7840(ModTexts.BLANK, button -> client.method_1507((class_437)new ModOptionsScreen(parent))).method_46434(width, height, 20, 20).method_46431();
    }

    public static void drawTooltipAndTexture(class_2561 tooltip, String name, class_332 context, class_327 renderer, class_4185 button, int mouseX, int mouseY, @Nullable Float f) {
        if (QoQ.options().helpfulTooltips && button.method_49606()) {
            ButtonUtil.drawTooltip(tooltip, context, renderer, mouseX, mouseY);
        }
        ButtonUtil.drawTexture(context, name, button, f == null ? 1.0f : f.floatValue());
    }

    public static void drawTooltip(class_2561 tooltip, class_332 context, class_327 renderer, int mouseX, int mouseY) {
        context.method_51447(renderer, renderer.method_1728((class_5348)tooltip, 200), mouseX, mouseY);
    }

    public static void drawTexture(class_332 context, String name, class_4185 button, float f) {
        context.method_25291(class_10799.field_56883, class_2960.method_60654((String)("qualityofqueso:textures/gui/" + name + ".png")), button.method_46426() + 1, button.method_46427() + 1, 0.0f, 0.0f, 18, 18, 18, 18, class_9848.method_71346((float)f, (int)-1));
    }

    public static void drawTexture(class_332 context, String name, class_4185 button) {
        ButtonUtil.drawTexture(context, name, button, 1.0f);
    }

    public static int getBarWidth(int backgroundWidth) {
        return (int)((double)backgroundWidth * 0.6);
    }

    public static int getButtonX(class_4185 button) {
        return button.method_46426();
    }

    public static int getManagementButtonX(class_437 screen, int backgroundWidth, int width) {
        int barWidth = ButtonUtil.getBarWidth(backgroundWidth);
        int modifier = 18;
        if (screen instanceof class_10260) {
            class_10260 recipeBookScreen = (class_10260)screen;
            modifier = 42;
            if (recipeBookScreen.field_54474.method_2605()) {
                modifier = 119;
            }
        }
        return width / 2 + barWidth / 2 + modifier;
    }

    public static int getManagementButtonY(class_437 screen, class_1263 inventory, int screenY, int titleY) {
        int y = 2 * inventory.method_5439() + 12;
        return screenY + titleY + (screen instanceof class_490 ? 64 : y);
    }

    public static int getContainerSize(class_1263 inventory) {
        return inventory.method_5439();
    }

    public static int getTotalSlots(class_1703 handler) {
        return handler.field_7761.size();
    }

    public static int getInventorySize(class_1703 handler, class_1263 inventory) {
        return QoQ.options().searchInventory ? handler.field_7761.size() : inventory.method_5439();
    }

    public static boolean isHotbarSlot(int totalSlots, int slotIndex) {
        return slotIndex >= totalSlots - 9;
    }

    public static boolean isInventoryHotbarSlot(boolean isInventoryScreen, int slotIndex) {
        return isInventoryScreen && slotIndex <= 44 && slotIndex >= 36;
    }

    public static boolean isExcludedSlot(class_437 screen, int slotIndex) {
        return screen instanceof class_490 && (slotIndex <= 8 && slotIndex >= 5 || slotIndex == 45);
    }

    public static boolean isAnySlotFilled(class_1703 handler, boolean checkHotbar, int start, int end) {
        for (int i = start; i < (QoQ.options().includeHotbar && checkHotbar ? end + 9 : end); ++i) {
            class_1735 slot = handler.method_7611(i);
            if (!slot.method_7681()) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainerFull(class_1703 handler, class_1263 inv, boolean inventory) {
        int j = 0;
        int containerSize = ButtonUtil.getContainerSize(inv);
        for (int i = inventory ? containerSize : 0; i < (inventory ? containerSize + 36 : containerSize); ++i) {
            class_1735 slot = handler.method_7611(i);
            if (!slot.method_7681()) continue;
            ++j;
        }
        return j == (inventory ? 36 : containerSize);
    }

    public static boolean hoveredSlotHasItem(class_1735 focusedSlot) {
        return focusedSlot != null && focusedSlot.method_7677() != class_1799.field_8037;
    }

    public static void swapItems(class_1703 handler, class_1263 inventory) {
        int totalSlots = ButtonUtil.getTotalSlots(handler);
        int containerSize = ButtonUtil.getContainerSize(inventory);
        int offset = totalSlots - 27 - 9;
        int swaps = Math.min(totalSlots - containerSize, containerSize);
        for (int i = 0; i < swaps; ++i) {
            int playerSlotIndex = i + offset;
            if (i >= totalSlots || playerSlotIndex >= totalSlots) continue;
            class_1735 chestSlot = handler.method_7611(i);
            class_1735 playerSlot = handler.method_7611(playerSlotIndex);
            if (!QoQ.options().includeHotbar && ButtonUtil.isHotbarSlot(handler.field_7761.size(), playerSlot.field_7874)) continue;
            class_1799 chestStack = chestSlot.method_7677();
            class_1799 playerStack = playerSlot.method_7677();
            if (chestStack.method_7960() && playerStack.method_7960()) continue;
            ButtonUtil.sendSwapSlotPacket(playerSlot.field_7874, chestSlot.field_7874);
        }
    }

    public static void sendSwapSlotPacket(int source, int index) {
        ButtonUtil.sendClickSlotPacket(source, class_1713.field_7790);
        ButtonUtil.sendClickSlotPacket(index, class_1713.field_7790);
        ButtonUtil.sendClickSlotPacket(source, class_1713.field_7790);
    }

    public static void sendClickSlotPacket(int slotIndex, class_1713 slotActionType) {
        class_310 client = class_310.method_1551();
        class_634 networkHandler = client.method_1562();
        if (client.field_1724 == null || networkHandler == null || client.field_1724.field_7512 == null) {
            return;
        }
        class_1703 handler = client.field_1724.field_7512;
        int syncId = handler.field_7763;
        int revision = handler.method_37421();
        class_1799 cursorStack = handler.method_34255();
        class_1799 clickedStack = handler.method_7611(slotIndex).method_7677();
        if (slotActionType == class_1713.field_7795) {
            if (!handler.method_7611(slotIndex).method_7677().method_7960()) {
                client.field_1761.method_2906(syncId, slotIndex, 1, slotActionType, (class_1657)client.field_1724);
            }
            return;
        }
        class_10936.class_10937 hasher = networkHandler.method_68823();
        class_10938 cursorHash = class_10938.method_68853((class_1799)cursorStack, (class_10936.class_10937)hasher);
        class_10938 clickedHash = class_10938.method_68853((class_1799)clickedStack, (class_10936.class_10937)hasher);
        Int2ObjectOpenHashMap modifiedStacks = new Int2ObjectOpenHashMap();
        modifiedStacks.put(slotIndex, (Object)clickedHash);
        class_2813 packet = new class_2813(syncId, revision, (short)slotIndex, 0, slotActionType, (Int2ObjectMap)modifiedStacks, cursorHash);
        networkHandler.method_52787((class_2596)packet);
    }

    public static boolean isQuicklyEquippable(class_1799 stack) {
        for (class_6862<class_1792> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
            if (!stack.method_31573(quicklyEquippable) && !stack.method_31574(class_1802.field_8833)) continue;
            return true;
        }
        return false;
    }

    public static void quickSwap(int sourceSlot, class_1304 slot) {
        int slotIndex = slot == class_1304.field_6169 ? 5 : (slot == class_1304.field_6174 ? 6 : (slot == class_1304.field_6172 ? 7 : (slot == class_1304.field_6166 ? 8 : 6)));
        ButtonUtil.sendSwapSlotPacket(sourceSlot, slotIndex);
    }

    public static void quickEquip(class_437 screen, class_1735 focusedSlot) {
        if (QoQ.options().quickEquip && focusedSlot != null && focusedSlot.field_7874 >= 5 && (screen instanceof class_490 || screen instanceof class_481)) {
            class_1799 stack = focusedSlot.method_7677();
            class_1304 targetSlot = null;
            for (class_6862<class_1792> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
                if (!stack.method_31573(quicklyEquippable)) continue;
                targetSlot = QoQ.quicklyEquippables.get(quicklyEquippable);
            }
            if (stack.method_31574(class_1802.field_8833)) {
                targetSlot = class_1304.field_6174;
            }
            if (targetSlot != null) {
                class_310 client = class_310.method_1551();
                class_1799 equippedStack = client.field_1724.method_6118(targetSlot);
                if (equippedStack.method_7960()) {
                    ButtonUtil.sendClickSlotPacket(focusedSlot.field_7874, class_1713.field_7794);
                } else {
                    ButtonUtil.quickSwap(focusedSlot.field_7874, targetSlot);
                }
            }
        }
    }

    public static void makeSlotUnavailable(class_332 context, class_1735 slot, boolean hotbar) {
        int color = hotbar ? -2139062148 : -1275068416;
        context.method_25296(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, color, color);
    }

    public static boolean isContainerScreen(class_437 screen) {
        return screen instanceof class_476 || screen instanceof class_495;
    }

    public static boolean isInventoryScreen(class_437 screen) {
        return screen instanceof class_490;
    }

    public static boolean isCreativeInventoryScreen(class_437 screen) {
        return screen instanceof class_481;
    }
}

