/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.dillon.qualityofqueso.keybind.ModKeybinds;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.screen.gui.IncludeHotbarButton;
import net.dillon.qualityofqueso.screen.gui.QuickDropButton;
import net.dillon.qualityofqueso.screen.gui.SearchField;
import net.dillon.qualityofqueso.screen.gui.SwapButton;
import net.dillon.qualityofqueso.screen.gui.TransferButton;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int topPos;
    @Shadow
    protected int titleLabelY;
    @Shadow
    @Final
    protected T menu;
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Unique
    private final AbstractContainerScreen<?> screen = (AbstractContainerScreen)this;
    @Unique
    private EditBox containerSearchField;
    @Unique
    private EditBox inventorySearchField;
    @Unique
    private TransferButton transferContainerButton;
    @Unique
    private TransferButton transferInventoryButton;
    @Unique
    private TransferButton includeHotbarButton;
    @Unique
    private TransferButton quickDropButton;
    @Unique
    private TransferButton swapButton;
    @Unique
    private int swapCooldown = 0;
    @Unique
    private Container container;

    @Shadow
    @Nullable
    public abstract Slot getSlotUnderMouse();

    public AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft)) {
            if (ButtonUtil.isContainerScreen(this.screen)) {
                AbstractContainerScreen<?> abstractContainerScreen = this.screen;
                if (abstractContainerScreen instanceof ShulkerBoxScreen) {
                    ShulkerBoxScreen shulkerBoxScreen = (ShulkerBoxScreen)abstractContainerScreen;
                    this.container = ((ShulkerBoxMenu)shulkerBoxScreen.getMenu()).container;
                } else {
                    abstractContainerScreen = this.screen;
                    if (abstractContainerScreen instanceof ContainerScreen) {
                        ContainerScreen genericContainerScreen = (ContainerScreen)abstractContainerScreen;
                        this.container = ((ChestMenu)genericContainerScreen.getMenu()).getContainer();
                    } else {
                        this.container = null;
                    }
                }
                if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue()) {
                    this.containerSearchField = this.initializeSearchField(false);
                    this.addRenderableWidget((GuiEventListener)this.containerSearchField);
                }
            } else if (ButtonUtil.isInventoryScreen(this.screen)) {
                this.container = this.minecraft.player.getInventory();
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue()) {
                    this.inventorySearchField = this.initializeSearchField(true);
                    this.addRenderableWidget((GuiEventListener)this.inventorySearchField);
                }
            }
        }
    }

    @Unique
    private SearchField initializeSearchField(boolean inventory) {
        return new SearchField(this.font, this.width / 2 + ButtonUtil.getBarWidth(this.imageWidth) / 2 - (inventory ? 60 : 64), this.topPos + this.titleLabelY - 2);
    }

    @Unique
    private String getSearchFieldText() {
        return this.inventorySearchField != null ? this.inventorySearchField.getValue() : (this.containerSearchField != null ? this.containerSearchField.getValue() : "");
    }

    @Unique
    private void dropItems(boolean fromInventory) {
        this.moveItems(true, true, fromInventory);
    }

    @Unique
    private void transferItems(boolean toInventory) {
        this.moveItems(toInventory, false, false);
    }

    @Unique
    private void moveItems(boolean toInventory, boolean drop, boolean fromInventory) {
        int toEnd;
        int containerSize = ButtonUtil.getContainerSize(this.container);
        int totalSlots = ButtonUtil.getTotalSlots(this.menu);
        int fromStart = toInventory ? 0 : containerSize;
        int fromEnd = toInventory ? containerSize : totalSlots;
        int toStart = toInventory ? containerSize : 0;
        int n = toEnd = toInventory ? totalSlots : containerSize;
        if (drop && fromInventory) {
            fromStart = 9;
            fromEnd = 45;
        }
        block0: for (int i = fromStart; i < fromEnd; ++i) {
            Slot fromSlot = this.menu.getSlot(i);
            ItemStack fromStack = fromSlot.getItem();
            if ((this.containerSearchField != null || this.inventorySearchField != null) && !this.getSearchFieldText().isEmpty() && !this.search(this.getSearchFieldText(), fromSlot, false) || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && (!drop ? !toInventory && ButtonUtil.isHotbarSlot(fromEnd, fromSlot.index) : ButtonUtil.isExcludedSlot(this.screen, fromSlot.index) || ButtonUtil.isInventoryHotbarSlot(ButtonUtil.isInventoryScreen(this.screen), fromSlot.index))) continue;
            if (fromStack.isEmpty()) continue;
            for (int j = toStart; j < toEnd; ++j) {
                ClickType slotActionType;
                Slot toSlot = this.menu.getSlot(j);
                if (!drop && !toSlot.getItem().isEmpty()) continue;
                ClickType clickType = slotActionType = drop ? ClickType.THROW : ClickType.QUICK_MOVE;
                if (!this.menu.getCarried().isEmpty()) {
                    if (!fromStack.is(this.menu.getCarried().getItem())) continue;
                    ButtonUtil.sendClickSlotPacket(i, slotActionType);
                    continue block0;
                }
                ButtonUtil.sendClickSlotPacket(i, slotActionType);
                continue block0;
            }
        }
    }

    @Unique
    private boolean shouldButtonBeActive(boolean isPlayerInventory, @Nullable Inventory playerInventory, AbstractWidget button) {
        if (button == null) {
            return false;
        }
        int size = isPlayerInventory ? playerInventory.items.size() : this.container.getContainerSize();
        int filledSlots = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = isPlayerInventory ? playerInventory.getItem(i) : this.menu.getSlot(i).getItem();
            boolean isShulkerScreen = this.screen instanceof ShulkerBoxScreen;
            boolean isCursorShulker = false;
            boolean isStackShulker = false;
            for (Item shulker : QoQ.shulkerBoxes) {
                if (this.menu.getCarried().is(shulker)) {
                    isCursorShulker = isShulkerScreen;
                }
                if (!stack.is(shulker)) continue;
                isStackShulker = isShulkerScreen;
            }
            if (!this.menu.getCarried().isEmpty()) {
                if (!stack.is(this.menu.getCarried().getItem()) || isCursorShulker) continue;
                ++filledSlots;
                continue;
            }
            if (stack.isEmpty() || isStackShulker) continue;
            ++filledSlots;
        }
        return filledSlots != 0 && !this.areAllSlotsUnavailable(isPlayerInventory, (Inventory)(isPlayerInventory ? playerInventory : null));
    }

    @Unique
    private boolean areAllSlotsUnavailable(boolean isPlayerInventory, @Nullable Inventory playerInventory) {
        int foundQuerys = 0;
        ArrayList<Slot> playerSlots = new ArrayList<Slot>();
        if (isPlayerInventory) {
            for (Slot s : ((AbstractContainerMenu)this.menu).slots) {
                if (s.container != playerInventory) continue;
                playerSlots.add(s);
            }
            for (Slot slot : playerSlots) {
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        } else {
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                Slot slot = this.menu.getSlot(i);
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        }
        return foundQuerys == 0;
    }

    @Unique
    private boolean search(String searchQuery, Slot slot, boolean dropping) {
        String[] terms;
        ItemStack stack = slot.getItem();
        if (stack.isEmpty() || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && ((Boolean)ModClientOptions.SEARCH_INVENTORY.get()).booleanValue() && ButtonUtil.isHotbarSlot(((AbstractContainerMenu)this.menu).slots.size(), dropping ? slot.index + 1 : slot.index) && (!dropping || !ButtonUtil.isInventoryScreen(this.screen) || slot.index != 45)) {
            return false;
        }
        String itemName = stack.getHoverName().getString().toLowerCase();
        for (String term : terms = searchQuery.split(",")) {
            if (!itemName.contains(term.trim().toLowerCase())) continue;
            return true;
        }
        if (searchQuery.startsWith("!")) {
            return !itemName.contains(searchQuery.substring(1));
        }
        if (searchQuery.startsWith("#")) {
            String tagSearch = searchQuery.substring(1);
            RegistryAccess lookup = Minecraft.getInstance().level.registryAccess();
            Registry itemRegistry = lookup.registryOrThrow(Registries.ITEM);
            for (Pair tag : itemRegistry.getTags().toList()) {
                ResourceLocation location = ((TagKey)tag.getFirst()).location();
                if (!location.getPath().toLowerCase().contains(tagSearch) && !location.toString().toLowerCase().contains(tagSearch) || !stack.is((TagKey)tag.getFirst())) continue;
                return true;
            }
        }
        if (stack.isEnchanted() || stack.is(Items.ENCHANTED_BOOK)) {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            for (Holder enchantment : enchantments.keySet()) {
                String encName = ((Enchantment)enchantment.value()).description().getString();
                String fullName = encName + " " + enchantments.getLevel(enchantment);
                if (!fullName.toLowerCase().contains(searchQuery)) continue;
                return true;
            }
        }
        return itemName.contains(searchQuery);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void grayOutSlot(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        boolean inventorySearchFieldPresent;
        boolean bl = inventorySearchFieldPresent = this.inventorySearchField != null;
        if (this.containerSearchField != null || inventorySearchFieldPresent) {
            for (int i = 0; i < ButtonUtil.getInventorySize(this.menu, this.container); ++i) {
                Slot slot = this.menu.getSlot(i);
                if (this.getSearchFieldText().isEmpty() || this.search(this.getSearchFieldText(), slot, this.inventorySearchField != null)) continue;
                ButtonUtil.makeSlotUnavailable(graphics, slot, false);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.containerSearchField != null) {
            this.containerSearchField.render(graphics, mouseX, mouseY, deltaTicks);
        }
        if (this.inventorySearchField != null) {
            InventoryScreen recipeBookScreen;
            AbstractContainerScreen<?> abstractContainerScreen;
            this.inventorySearchField.setX(this.width / 2 + ButtonUtil.getBarWidth(this.imageWidth) / 2 - ((abstractContainerScreen = this.screen) instanceof InventoryScreen && (recipeBookScreen = (InventoryScreen)abstractContainerScreen).getRecipeBookComponent().isVisible() ? -16 : 60));
            this.inventorySearchField.render(graphics, mouseX, mouseY, deltaTicks);
        }
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.INVENTORY_MANAGEMENT.get()).booleanValue()) {
            boolean validScreen;
            Inventory playerInventory = this.minecraft.player.getInventory();
            boolean containerScreen = ButtonUtil.isContainerScreen(this.screen);
            boolean inventoryScreen = ButtonUtil.isInventoryScreen(this.screen);
            boolean bl = validScreen = containerScreen || inventoryScreen;
            if (containerScreen) {
                this.transferContainerButton = (TransferButton)this.addWidget((GuiEventListener)new TransferButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.imageWidth, this.width), ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "transfer_container", b -> this.transferItems(true), () -> !ButtonUtil.isContainerFull(this.menu, this.container, true) && this.shouldButtonBeActive(false, null, (AbstractWidget)this.transferContainerButton)));
                this.transferContainerButton.render(graphics, mouseX, mouseY, deltaTicks);
                this.transferInventoryButton = (TransferButton)this.addWidget((GuiEventListener)new TransferButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.transferContainerButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "transfer_inventory", b -> this.transferItems(false), () -> !ButtonUtil.isContainerFull(this.menu, this.container, false) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.transferInventoryButton)));
                this.transferInventoryButton.render(graphics, mouseX, mouseY, deltaTicks);
            }
            if (validScreen) {
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() || ((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.includeHotbarButton = (TransferButton)this.addWidget((GuiEventListener)new IncludeHotbarButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.imageWidth, this.width) - 24, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "include_hotbar", b -> {
                        ModClientOptions.INCLUDE_HOTBAR.set((Object)((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() == false ? 1 : 0));
                        QoQ.saveAll();
                    }));
                    this.includeHotbarButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.SWAPPING.get()).booleanValue() && containerScreen) {
                    this.swapButton = (TransferButton)this.addWidget((GuiEventListener)new SwapButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "swap", b -> ButtonUtil.swapItems(this.menu, this.container), () -> {
                        if (this.swapCooldown > 0) {
                            --this.swapCooldown;
                        }
                        return (ButtonUtil.getContainerSize(this.container) != 27 || ButtonUtil.isAnySlotFilled(this.menu, false, 27, 54)) && this.menu.getCarried().isEmpty() && this.getSearchFieldText().isEmpty() && this.shouldButtonBeActive(false, null, (AbstractWidget)this.swapButton) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.swapButton);
                    }));
                    this.swapButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.quickDropButton = (TransferButton)this.addWidget((GuiEventListener)new QuickDropButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - (containerScreen && (Boolean)ModClientOptions.SWAPPING.get() != false ? 24 : 12), ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "quick_drop", b -> this.dropItems(!containerScreen), () -> (ButtonUtil.isInventoryScreen(this.screen) ? ButtonUtil.isAnySlotFilled(this.menu, true, 9, 36) : ButtonUtil.isAnySlotFilled(this.menu, false, 0, ButtonUtil.getContainerSize(this.container))) && this.menu.getCarried().isEmpty() && this.shouldButtonBeActive(!containerScreen, containerScreen ? null : playerInventory, (AbstractWidget)this.quickDropButton)));
                    this.quickDropButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
            }
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAllItemTagsToTooltip(GuiGraphics graphics, int x, int y, CallbackInfo ci) {
        String searchQuery = this.getSearchFieldText();
        if (this.containerSearchField != null) {
            if (!searchQuery.startsWith("#")) {
                return;
            }
            Slot hoveredSlot = this.getSlotUnderMouse();
            if (hoveredSlot == null || !hoveredSlot.hasItem()) {
                return;
            }
            ItemStack stack = hoveredSlot.getItem();
            Registry itemRegistry = this.minecraft.level.registryAccess().registryOrThrow(Registries.ITEM);
            List originalTooltip = stack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)this.minecraft.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            boolean foundTags = false;
            for (Pair tag : itemRegistry.getTags().toList()) {
                if (!stack.is((TagKey)tag.getFirst())) continue;
                String tagString = "#" + String.valueOf(((TagKey)tag.getFirst()).location());
                originalTooltip.add(1, Component.literal((String)tagString).withStyle(ChatFormatting.LIGHT_PURPLE));
                foundTags = true;
            }
            if (foundTags) {
                graphics.renderTooltip(this.font, originalTooltip, Optional.empty(), x, y);
                ci.cancel();
            }
        }
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void closeButtonOnClickOutOfBounds(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_GUI_EXIT.get()).booleanValue() && this.menu.getCarried().isEmpty() && button == 0 && slot == null) {
            this.onClose();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseClicking(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.minecraft)) {
            if (button == 1 && this.hoveredSlot != null && ButtonUtil.isQuicklyEquippable(this.hoveredSlot.getItem())) {
                ButtonUtil.quickEquip(this.screen, this.hoveredSlot);
                cir.setReturnValue((Object)true);
            }
            if (this.inventorySearchField != null && this.inventorySearchField.mouseClicked(mouseX, mouseY, button)) {
                this.inventorySearchField.setFocused(true);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleKeyPressing(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.minecraft)) {
            AbstractContainerScreen<?> abstractContainerScreen;
            boolean cannotType;
            if (Screen.hasControlDown() && ((Boolean)ModClientOptions.SHORTCUT_KEYS.get()).booleanValue()) {
                if (this.transferContainerButton != null && this.transferContainerButton.active && keyCode == ModKeybinds.MOVE_CONTAINER.getKey().getValue()) {
                    this.transferItems(true);
                }
                if (this.transferInventoryButton != null && this.transferInventoryButton.active && keyCode == ModKeybinds.MOVE_INVENTORY.getKey().getValue()) {
                    this.transferItems(false);
                }
                if (this.swapCooldown == 0 && this.swapButton != null && this.swapButton.active && keyCode == ModKeybinds.SWAP_ITEMS.getKey().getValue()) {
                    ButtonUtil.swapItems(this.menu, this.container);
                    this.swapCooldown = 120;
                }
                if (this.quickDropButton != null && this.quickDropButton.active && Screen.hasAltDown() && keyCode == 81) {
                    this.dropItems(!ButtonUtil.isContainerScreen(this.screen));
                }
            }
            if (keyCode == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
                ButtonUtil.quickEquip(this.screen, this.hoveredSlot);
            }
            if (keyCode == 69 && ((Boolean)ModClientOptions.PREVENT_E_FROM_TYPING.get()).booleanValue() && (ButtonUtil.isInventoryScreen(this.screen) || ButtonUtil.isCreativeInventoryScreen(this.screen))) {
                this.onClose();
                cir.setReturnValue((Object)true);
            }
            boolean ignoreTyping = ButtonUtil.hoveredSlotHasItem(this.hoveredSlot);
            boolean secondaryIgnoreTyping = false;
            boolean numberKeyPressed = false;
            boolean hotbarKeyPressed = false;
            boolean dropKeyPressed = false;
            boolean swapKeyPressed = false;
            for (int key : QoQ.allDisallowedKeys) {
                if (keyCode != key) continue;
                ignoreTyping = true;
                secondaryIgnoreTyping = true;
                break;
            }
            if (this.menu.getCarried().isEmpty() && this.hoveredSlot != null) {
                for (int i = 0; i < 9; ++i) {
                    if (!this.minecraft.options.keyHotbarSlots[i].matches(keyCode, scanCode)) continue;
                    ignoreTyping = true;
                    secondaryIgnoreTyping = true;
                    hotbarKeyPressed = true;
                    break;
                }
                if (this.screen instanceof InventoryScreen && keyCode == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
                    ignoreTyping = true;
                }
            }
            for (int key : QoQ.popularKeys) {
                if (keyCode != key) continue;
                secondaryIgnoreTyping = false;
                cir.setReturnValue((Object)true);
                break;
            }
            List<Integer> numbers = List.of(Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(51), Integer.valueOf(52), Integer.valueOf(53), Integer.valueOf(54), Integer.valueOf(55), Integer.valueOf(56), Integer.valueOf(57));
            for (int key : numbers) {
                if (keyCode != key) continue;
                numberKeyPressed = true;
                break;
            }
            if (keyCode == Minecraft.getInstance().options.keyDrop.getKey().getValue()) {
                secondaryIgnoreTyping = true;
                dropKeyPressed = true;
            } else if (keyCode == Minecraft.getInstance().options.keySwapOffhand.getKey().getValue()) {
                secondaryIgnoreTyping = true;
                swapKeyPressed = true;
            }
            boolean bl = cannotType = (numberKeyPressed || hotbarKeyPressed || dropKeyPressed || swapKeyPressed) && ButtonUtil.hoveredSlotHasItem(this.hoveredSlot);
            if (((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue() && (abstractContainerScreen = this.screen) instanceof InventoryScreen) {
                InventoryScreen recipeScreen = (InventoryScreen)abstractContainerScreen;
                if (!Screen.hasControlDown()) {
                    boolean swapKeyValid;
                    boolean bl2 = swapKeyValid = swapKeyPressed && (ButtonUtil.hoveredSlotHasItem(this.hoveredSlot) || this.menu.getSlot(45).hasItem());
                    if (!(ignoreTyping || swapKeyValid || recipeScreen.getRecipeBookComponent().isVisible() || this.inventorySearchField != null && this.inventorySearchField.isFocused())) {
                        recipeScreen.getRecipeBookComponent().toggleVisibility();
                        this.repositionElements();
                    }
                    if (recipeScreen.getRecipeBookComponent().searchBox != null) {
                        recipeScreen.getRecipeBookComponent().searchBox.setFocused(!cannotType);
                        if (recipeScreen.getRecipeBookComponent().searchBox.isFocused()) {
                            cir.setReturnValue((Object)(recipeScreen.getRecipeBookComponent().keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers) ? 1 : 0));
                        }
                    }
                }
            }
            if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() && this.inventorySearchField != null) {
                InventoryScreen recipeScreen;
                if (!Screen.hasControlDown() && (abstractContainerScreen = this.screen) instanceof InventoryScreen && (recipeScreen = (InventoryScreen)abstractContainerScreen).getRecipeBookComponent().isVisible() && !this.inventorySearchField.isFocused()) {
                    recipeScreen.getRecipeBookComponent().searchBox.setFocused(!cannotType);
                } else if (!secondaryIgnoreTyping && (!Screen.hasControlDown() || Screen.hasControlDown() && keyCode == 65)) {
                    this.inventorySearchField.setFocused(true);
                    this.setFocused((GuiEventListener)this.inventorySearchField);
                } else if (this.inventorySearchField.isFocused() && cannotType) {
                    this.inventorySearchField.setFocused(false);
                }
                abstractContainerScreen = this.screen;
                if (abstractContainerScreen instanceof InventoryScreen) {
                    InventoryScreen recipeScreen2 = (InventoryScreen)abstractContainerScreen;
                    if (recipeScreen2.getRecipeBookComponent().searchBox != null) {
                        if (this.inventorySearchField.isFocused()) {
                            recipeScreen2.getRecipeBookComponent().searchBox.setFocused(false);
                        } else if (recipeScreen2.getRecipeBookComponent().searchBox.isFocused() && this.inventorySearchField != null) {
                            this.inventorySearchField.setFocused(false);
                        }
                    }
                }
                if (this.inventorySearchField.isFocused() && this.inventorySearchField.keyPressed(keyCode, scanCode, modifiers)) {
                    cir.setReturnValue((Object)true);
                }
            }
            if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && ButtonUtil.isContainerScreen(this.screen)) {
                if (!secondaryIgnoreTyping && (!Screen.hasControlDown() || Screen.hasControlDown() && keyCode == 65)) {
                    this.containerSearchField.setFocused(true);
                } else if (this.containerSearchField.isFocused() && cannotType) {
                    this.containerSearchField.setFocused(false);
                }
                if (this.containerSearchField.isFocused() && this.containerSearchField.keyPressed(keyCode, scanCode, modifiers)) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    public boolean charTyped(char chr, int modifiers) {
        if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && this.containerSearchField != null && this.containerSearchField.isFocused()) {
            return this.containerSearchField.charTyped(chr, modifiers);
        }
        return super.charTyped(chr, modifiers);
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void saveSearchText(CallbackInfo ci) {
        if (((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue()) {
            if (ButtonUtil.isInventoryScreen(this.screen) && this.inventorySearchField != null) {
                QoQ.SAVED_TEXT = this.inventorySearchField.getValue();
            } else if (ButtonUtil.isContainerScreen(this.screen) && this.containerSearchField != null) {
                QoQ.SAVED_TEXT = this.containerSearchField.getValue();
            }
        }
    }

    public void resize(Minecraft client, int width, int height) {
        if (this.containerSearchField != null) {
            String text = this.getSearchFieldText();
            boolean refocus = this.containerSearchField.isFocused();
            this.init(client, width, height);
            this.containerSearchField.setValue(text);
            this.containerSearchField.setFocused(refocus);
        }
    }
}

