/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.option;

import java.util.ArrayList;
import net.dillon.qualityofqueso.option.AbstractModOptionsScreen;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModCommonOptions;
import net.dillon.qualityofqueso.option.options.InventoryManagementOptionsScreen;
import net.dillon.qualityofqueso.option.options.InventorySearchingOptionsScreen;
import net.dillon.qualityofqueso.option.options.ItemFrameSearchingOptionsScreen;
import net.dillon.qualityofqueso.option.options.MiscOptionsScreen;
import net.dillon.qualityofqueso.screen.ItemFrameSearchScreen;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModOptionsScreen
extends AbstractModOptionsScreen {
    private Button chestSearchingOptions;
    private Button inventoryManagementOptions;
    private Button itemFrameSearchingOptions;
    private Button openItemFrameSearchGUIOptions;
    private Button otherOptions;
    private Button reportBugs;

    public ModOptionsScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"qualityofqueso.gui.options.title"));
    }

    @Override
    protected void init() {
        super.init();
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.chestSearchingOptions = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.inventory_searching_options"), button -> this.minecraft.setScreen((Screen)new InventorySearchingOptionsScreen((Screen)this))).build());
        buttons.add(this.chestSearchingOptions);
        this.inventoryManagementOptions = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.inventory_management_options"), button -> this.minecraft.setScreen((Screen)new InventoryManagementOptionsScreen((Screen)this))).build());
        buttons.add(this.inventoryManagementOptions);
        this.itemFrameSearchingOptions = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.item_frame_searching_options"), button -> this.minecraft.setScreen((Screen)new ItemFrameSearchingOptionsScreen((Screen)this))).build());
        buttons.add(this.itemFrameSearchingOptions);
        this.openItemFrameSearchGUIOptions = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.open_item_frame_search_gui"), button -> {
            if (((Boolean)ModCommonOptions.ITEM_FRAME_SEARCHING.get()).booleanValue() && this.minecraft.level != null) {
                this.minecraft.setScreen((Screen)new ItemFrameSearchScreen());
            }
        }).build());
        buttons.add(this.openItemFrameSearchGUIOptions);
        this.otherOptions = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.misc_options"), button -> this.minecraft.setScreen((Screen)new MiscOptionsScreen((Screen)this))).build());
        buttons.add(this.otherOptions);
        this.reportBugs = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.report_bugs"), (Button.OnPress)ConfirmLinkScreen.confirmLink((Screen)this, (String)"https://github.com/Dillon8775/Quality-of-Queso/issues", (boolean)false)).build());
        buttons.add(this.reportBugs);
        this.list.addSmall(buttons);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        super.render(graphics, mouseX, mouseY, deltaTicks);
        boolean bl = this.openItemFrameSearchGUIOptions.active = (Boolean)ModCommonOptions.ITEM_FRAME_SEARCHING.get() != false && this.minecraft.level != null;
        if (this.chestSearchingOptions.isHovered()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.chest_searching_options.tooltip"), graphics, this.font, mouseX, mouseY);
        }
        if (this.inventoryManagementOptions.isHovered()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.inventory_management_options.tooltip"), graphics, this.font, mouseX, mouseY);
        }
        if (this.itemFrameSearchingOptions.isHovered()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.item_frame_searching_options.tooltip"), graphics, this.font, mouseX, mouseY);
        }
        if (this.openItemFrameSearchGUIOptions.isHovered()) {
            if (!((Boolean)ModCommonOptions.ITEM_FRAME_SEARCHING.get()).booleanValue()) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.open_item_frame_search_gui.disabled"), graphics, this.font, mouseX, mouseY);
            } else if (this.minecraft.level == null) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.open_item_frame_search_gui.null_world"), graphics, this.font, mouseX, mouseY);
            }
        }
        if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue()) {
            if (this.otherOptions.isHovered()) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.misc_options.tooltip"), graphics, this.font, mouseX, mouseY);
            }
            if (this.reportBugs.isHovered()) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.report_bugs.tooltip"), graphics, this.font, mouseX, mouseY);
            }
        }
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    @Override
    protected OptionInstance<?>[] options() {
        return new OptionInstance[0];
    }
}

