/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin;

import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.dillon.qualityofqueso.util.ModTexts;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_433.class})
public class GameMenuScreenMixin
extends class_437 {
    @Shadow
    @Final
    private boolean field_19319;
    @Shadow
    @Nullable
    private class_4185 field_40792;
    @Unique
    private class_4185 settingsButton;
    @Unique
    private class_4185 blacklistServerButton;

    public GameMenuScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (this.field_19319) {
            if (QoQ.options().showQoQButtons) {
                this.settingsButton = (class_4185)this.method_37063((class_364)ButtonUtil.initializeButton(this.field_22787, this, this.field_22789 / 2 + 106, this.field_22790 / 4 + 72 - 16));
            }
            if (this.field_40792 != null && QoQ.options().preventRageQuitting) {
                this.field_40792.field_22763 = false;
            }
            if (this.field_22787.method_1558() != null) {
                String address = this.getServerAddress();
                this.blacklistServerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.BLANK, button -> {
                    if (QoQ.options().blacklistedServers.contains(address)) {
                        QoQ.options().blacklistedServers.remove(address);
                    } else {
                        QoQ.options().blacklistedServers.add(address);
                    }
                    QoQ.saveAll();
                }).method_46434(this.field_22789 / 2 + 106, QoQ.isFlashbackLoaded() ? this.field_22790 / 4 + 120 - 16 : this.field_22790 / 4 + 96 - 16, 20, 20).method_46431());
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderTooltipsAndTextures(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.field_19319) {
            if (QoQ.options().showQoQButtons) {
                ButtonUtil.drawTooltipAndTexture(ModTexts.CONFIGURE_QOQ, "cheese_wheel", context, this.field_22793, this.settingsButton, mouseX, mouseY);
            }
            if (QoQ.options().preventRageQuitting && QoQ.options().helpfulTooltips && this.field_40792 != null && this.field_40792.method_49606()) {
                ButtonUtil.drawTooltip((class_2561)class_2561.method_43471((String)"qualityofqueso.gui.disconnect"), context, this.field_22793, mouseX, mouseY);
            }
            if (this.field_22787.method_1558() != null && this.blacklistServerButton != null) {
                this.blacklistServerButton.field_22763 = QoQ.isOnServer(this.field_22787);
                String address = this.getServerAddress();
                if (this.blacklistServerButton.method_49606()) {
                    ButtonUtil.drawTexture(context, this.isServerBlacklisted(address) ? "qoq_enabled" : "qoq_disabled", this.blacklistServerButton);
                    ButtonUtil.drawTooltip(this.tooltipWithPrefix((class_2561)(this.isServerBlacklisted(address) ? class_2561.method_43471((String)"qualityofqueso.gui.remove_blacklisted_server") : class_2561.method_43471((String)"qualityofqueso.gui.add_blacklisted_server"))), context, this.field_22793, mouseX, mouseY);
                } else {
                    ButtonUtil.drawTexture(context, this.isServerBlacklisted(address) ? "qoq_disabled" : "qoq_enabled", this.blacklistServerButton);
                }
            }
        }
    }

    @Unique
    private class_2561 tooltipWithPrefix(class_2561 text) {
        return class_2561.method_43471((String)"qualityofqueso.gui.blacklisted_server_button_prefix").method_27693("\n").method_10852(text);
    }

    @Unique
    private String getServerAddress() {
        return this.field_22787.method_1558().field_3761;
    }

    @Unique
    private boolean isServerBlacklisted(String serverAddress) {
        return QoQ.options().blacklistedServers.contains(serverAddress);
    }
}

