/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dillon.qualityofqueso.keybind.ModKeybinds;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.screen.gui.IncludeHotbarButton;
import net.dillon.qualityofqueso.screen.gui.QuickDropButton;
import net.dillon.qualityofqueso.screen.gui.SearchField;
import net.dillon.qualityofqueso.screen.gui.SwapButton;
import net.dillon.qualityofqueso.screen.gui.TransferButton;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97736_;
    @Shadow
    protected int f_97729_;
    @Shadow
    @Final
    protected T f_97732_;
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Unique
    private final AbstractContainerScreen<?> screen = (AbstractContainerScreen)this;
    @Unique
    private EditBox containerSearchField;
    @Unique
    private EditBox inventorySearchField;
    @Unique
    private TransferButton transferContainerButton;
    @Unique
    private TransferButton transferInventoryButton;
    @Unique
    private TransferButton includeHotbarButton;
    @Unique
    private TransferButton quickDropButton;
    @Unique
    private TransferButton swapButton;
    @Unique
    private int swapCooldown = 0;
    @Unique
    private Container container;

    @Shadow
    @Nullable
    public abstract Slot getSlotUnderMouse();

    public AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (QoQ.modEnabled(this.f_96541_)) {
            if (ButtonUtil.isContainerScreen(this.screen)) {
                AbstractContainerScreen<?> abstractContainerScreen = this.screen;
                if (abstractContainerScreen instanceof ShulkerBoxScreen) {
                    ShulkerBoxScreen shulkerBoxScreen = (ShulkerBoxScreen)abstractContainerScreen;
                    this.container = ((ShulkerBoxMenu)shulkerBoxScreen.m_6262_()).f_40186_;
                } else {
                    abstractContainerScreen = this.screen;
                    if (abstractContainerScreen instanceof ContainerScreen) {
                        ContainerScreen genericContainerScreen = (ContainerScreen)abstractContainerScreen;
                        this.container = ((ChestMenu)genericContainerScreen.m_6262_()).m_39261_();
                    } else {
                        this.container = null;
                    }
                }
                if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue()) {
                    this.containerSearchField = this.initializeSearchField(false);
                    this.m_142416_((GuiEventListener)this.containerSearchField);
                }
            } else if (ButtonUtil.isInventoryScreen(this.screen)) {
                this.container = this.f_96541_.f_91074_.m_150109_();
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue()) {
                    this.inventorySearchField = this.initializeSearchField(true);
                    this.m_142416_((GuiEventListener)this.inventorySearchField);
                }
            }
        }
    }

    @Unique
    private SearchField initializeSearchField(boolean inventory) {
        return new SearchField(this.f_96547_, this.f_96543_ / 2 + ButtonUtil.getBarWidth(this.f_97726_) / 2 - (inventory ? 60 : 64), this.f_97736_ + this.f_97729_ - 2);
    }

    @Unique
    private String getSearchFieldText() {
        return this.inventorySearchField != null ? this.inventorySearchField.m_94155_() : (this.containerSearchField != null ? this.containerSearchField.m_94155_() : "");
    }

    @Unique
    private void dropItems(boolean fromInventory) {
        this.moveItems(true, true, fromInventory);
    }

    @Unique
    private void transferItems(boolean toInventory) {
        this.moveItems(toInventory, false, false);
    }

    @Unique
    private void moveItems(boolean toInventory, boolean drop, boolean fromInventory) {
        int toEnd;
        int containerSize = ButtonUtil.getContainerSize(this.container);
        int totalSlots = ButtonUtil.getTotalSlots(this.f_97732_);
        int fromStart = toInventory ? 0 : containerSize;
        int fromEnd = toInventory ? containerSize : totalSlots;
        int toStart = toInventory ? containerSize : 0;
        int n = toEnd = toInventory ? totalSlots : containerSize;
        if (drop && fromInventory) {
            fromStart = 9;
            fromEnd = 45;
        }
        block0: for (int i = fromStart; i < fromEnd; ++i) {
            Slot fromSlot = this.f_97732_.m_38853_(i);
            ItemStack fromStack = fromSlot.m_7993_();
            if ((this.containerSearchField != null || this.inventorySearchField != null) && !this.getSearchFieldText().isEmpty() && !this.search(this.getSearchFieldText(), fromSlot, false) || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && (!drop ? !toInventory && ButtonUtil.isHotbarSlot(fromEnd, fromSlot.f_40219_) : ButtonUtil.isExcludedSlot(this.screen, fromSlot.f_40219_) || ButtonUtil.isInventoryHotbarSlot(ButtonUtil.isInventoryScreen(this.screen), fromSlot.f_40219_))) continue;
            if (fromStack.m_41619_()) continue;
            for (int j = toStart; j < toEnd; ++j) {
                ClickType slotActionType;
                Slot toSlot = this.f_97732_.m_38853_(j);
                if (!drop && !toSlot.m_7993_().m_41619_()) continue;
                ClickType clickType = slotActionType = drop ? ClickType.THROW : ClickType.QUICK_MOVE;
                if (!this.f_97732_.m_142621_().m_41619_()) {
                    if (!fromStack.m_150930_(this.f_97732_.m_142621_().m_41720_())) continue;
                    ButtonUtil.sendClickSlotPacket(i, slotActionType);
                    continue block0;
                }
                ButtonUtil.sendClickSlotPacket(i, slotActionType);
                continue block0;
            }
        }
    }

    @Unique
    private boolean shouldButtonBeActive(boolean isPlayerInventory, @Nullable Inventory playerInventory, AbstractWidget button) {
        if (button == null) {
            return false;
        }
        int size = isPlayerInventory ? playerInventory.f_35974_.size() : this.container.m_6643_();
        int filledSlots = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = isPlayerInventory ? playerInventory.m_8020_(i) : this.f_97732_.m_38853_(i).m_7993_();
            boolean isShulkerScreen = this.screen instanceof ShulkerBoxScreen;
            boolean isCursorShulker = false;
            boolean isStackShulker = false;
            for (Item shulker : QoQ.shulkerBoxes) {
                if (this.f_97732_.m_142621_().m_150930_(shulker)) {
                    isCursorShulker = isShulkerScreen;
                }
                if (!stack.m_150930_(shulker)) continue;
                isStackShulker = isShulkerScreen;
            }
            if (!this.f_97732_.m_142621_().m_41619_()) {
                if (!stack.m_150930_(this.f_97732_.m_142621_().m_41720_()) || isCursorShulker) continue;
                ++filledSlots;
                continue;
            }
            if (stack.m_41619_() || isStackShulker) continue;
            ++filledSlots;
        }
        return filledSlots != 0 && !this.areAllSlotsUnavailable(isPlayerInventory, (Inventory)(isPlayerInventory ? playerInventory : null));
    }

    @Unique
    private boolean areAllSlotsUnavailable(boolean isPlayerInventory, @Nullable Inventory playerInventory) {
        int foundQuerys = 0;
        ArrayList<Slot> playerSlots = new ArrayList<Slot>();
        if (isPlayerInventory) {
            for (Slot s : ((AbstractContainerMenu)this.f_97732_).f_38839_) {
                if (s.f_40218_ != playerInventory) continue;
                playerSlots.add(s);
            }
            for (Slot slot : playerSlots) {
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        } else {
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                Slot slot = this.f_97732_.m_38853_(i);
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        }
        return foundQuerys == 0;
    }

    @Unique
    private boolean search(String searchQuery, Slot slot, boolean dropping) {
        ItemStack stack = slot.m_7993_();
        if (stack.m_41619_() || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && ((Boolean)ModClientOptions.SEARCH_INVENTORY.get()).booleanValue() && ButtonUtil.isHotbarSlot(((AbstractContainerMenu)this.f_97732_).f_38839_.size(), dropping ? slot.f_40219_ + 1 : slot.f_40219_) && (!dropping || !ButtonUtil.isInventoryScreen(this.screen) || slot.f_40219_ != 45)) {
            return false;
        }
        String itemName = stack.m_41786_().getString().toLowerCase();
        String[] terms = searchQuery.split(",");
        for (String term : terms) {
            if (!itemName.contains(term.trim().toLowerCase())) continue;
            return true;
        }
        if (searchQuery.startsWith("!")) {
            return !itemName.contains(searchQuery.substring(1));
        }
        if (searchQuery.startsWith("#")) {
            String tagSearch = searchQuery.substring(1);
            RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
            Registry itemRegistry = registryAccess.m_175515_(Registries.f_256913_);
            for (Pair tag : itemRegistry.m_203612_().toList()) {
                ResourceLocation location = ((TagKey)tag.getFirst()).f_203868_();
                if (!location.m_135815_().toLowerCase().contains(tagSearch) && !location.toString().toLowerCase().contains(tagSearch) || !stack.m_204117_((TagKey)tag.getFirst())) continue;
                return true;
            }
        }
        if (stack.m_41793_() || stack.m_150930_(Items.f_42690_)) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                String encName = Component.m_237115_((String)((Enchantment)entry.getKey()).m_44704_()).getString();
                String fullName = encName + " " + entry.getValue();
                if (!fullName.toLowerCase().contains(searchQuery)) continue;
                return true;
            }
        }
        return itemName.contains(searchQuery);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void grayOutSlot(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        boolean inventorySearchFieldPresent;
        boolean bl = inventorySearchFieldPresent = this.inventorySearchField != null;
        if (this.containerSearchField != null || inventorySearchFieldPresent) {
            for (int i = 0; i < ButtonUtil.getInventorySize(this.f_97732_, this.container); ++i) {
                Slot slot = this.f_97732_.m_38853_(i);
                if (this.getSearchFieldText().isEmpty() || this.search(this.getSearchFieldText(), slot, this.inventorySearchField != null)) continue;
                ButtonUtil.makeSlotUnavailable(graphics, slot, false);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.containerSearchField != null) {
            this.containerSearchField.m_88315_(graphics, mouseX, mouseY, deltaTicks);
        }
        if (this.inventorySearchField != null) {
            InventoryScreen recipeBookScreen;
            AbstractContainerScreen<?> abstractContainerScreen;
            this.inventorySearchField.m_252865_(this.f_96543_ / 2 + ButtonUtil.getBarWidth(this.f_97726_) / 2 - ((abstractContainerScreen = this.screen) instanceof InventoryScreen && (recipeBookScreen = (InventoryScreen)abstractContainerScreen).m_5564_().m_100385_() ? -16 : 60));
            this.inventorySearchField.m_88315_(graphics, mouseX, mouseY, deltaTicks);
        }
        if (QoQ.modEnabled(this.f_96541_) && ((Boolean)ModClientOptions.INVENTORY_MANAGEMENT.get()).booleanValue()) {
            boolean validScreen;
            Inventory playerInventory = this.f_96541_.f_91074_.m_150109_();
            boolean containerScreen = ButtonUtil.isContainerScreen(this.screen);
            boolean inventoryScreen = ButtonUtil.isInventoryScreen(this.screen);
            boolean bl = validScreen = containerScreen || inventoryScreen;
            if (containerScreen) {
                this.transferContainerButton = (TransferButton)this.m_7787_((GuiEventListener)new TransferButton((AbstractContainerMenu)this.f_97732_, this.f_96547_, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.f_97726_, this.f_96543_), ButtonUtil.getManagementButtonY(this.screen, this.container, this.f_97736_, this.f_97729_), "transfer_container", b -> this.transferItems(true), () -> !ButtonUtil.isContainerFull(this.f_97732_, this.container, true) && this.shouldButtonBeActive(false, null, (AbstractWidget)this.transferContainerButton)));
                this.transferContainerButton.m_88315_(graphics, mouseX, mouseY, deltaTicks);
                this.transferInventoryButton = (TransferButton)this.m_7787_((GuiEventListener)new TransferButton((AbstractContainerMenu)this.f_97732_, this.f_96547_, this.getSearchFieldText(), ButtonUtil.getButtonX(this.transferContainerButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.f_97736_, this.f_97729_), "transfer_inventory", b -> this.transferItems(false), () -> !ButtonUtil.isContainerFull(this.f_97732_, this.container, false) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.transferInventoryButton)));
                this.transferInventoryButton.m_88315_(graphics, mouseX, mouseY, deltaTicks);
            }
            if (validScreen) {
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() || ((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.includeHotbarButton = (TransferButton)this.m_7787_((GuiEventListener)new IncludeHotbarButton((AbstractContainerMenu)this.f_97732_, this.f_96547_, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.f_97726_, this.f_96543_) - 24, ButtonUtil.getManagementButtonY(this.screen, this.container, this.f_97736_, this.f_97729_), "include_hotbar", b -> {
                        ModClientOptions.INCLUDE_HOTBAR.set((Object)((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() == false ? 1 : 0));
                        QoQ.saveAll();
                    }));
                    this.includeHotbarButton.m_88315_(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.SWAPPING.get()).booleanValue() && containerScreen) {
                    this.swapButton = (TransferButton)this.m_7787_((GuiEventListener)new SwapButton((AbstractContainerMenu)this.f_97732_, this.f_96547_, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.f_97736_, this.f_97729_), "swap", b -> ButtonUtil.swapItems(this.f_97732_, this.container), () -> {
                        if (this.swapCooldown > 0) {
                            --this.swapCooldown;
                        }
                        return (ButtonUtil.getContainerSize(this.container) != 27 || ButtonUtil.isAnySlotFilled(this.f_97732_, false, 27, 54)) && this.f_97732_.m_142621_().m_41619_() && this.getSearchFieldText().isEmpty() && this.shouldButtonBeActive(false, null, (AbstractWidget)this.swapButton) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.swapButton);
                    }));
                    this.swapButton.m_88315_(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.quickDropButton = (TransferButton)this.m_7787_((GuiEventListener)new QuickDropButton((AbstractContainerMenu)this.f_97732_, this.f_96547_, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - (containerScreen && (Boolean)ModClientOptions.SWAPPING.get() != false ? 24 : 12), ButtonUtil.getManagementButtonY(this.screen, this.container, this.f_97736_, this.f_97729_), "quick_drop", b -> this.dropItems(!containerScreen), () -> (ButtonUtil.isInventoryScreen(this.screen) ? ButtonUtil.isAnySlotFilled(this.f_97732_, true, 9, 36) : ButtonUtil.isAnySlotFilled(this.f_97732_, false, 0, ButtonUtil.getContainerSize(this.container))) && this.f_97732_.m_142621_().m_41619_() && this.shouldButtonBeActive(!containerScreen, containerScreen ? null : playerInventory, (AbstractWidget)this.quickDropButton)));
                    this.quickDropButton.m_88315_(graphics, mouseX, mouseY, deltaTicks);
                }
            }
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAllItemTagsToTooltip(GuiGraphics graphics, int x, int y, CallbackInfo ci) {
        String searchQuery = this.getSearchFieldText();
        if (this.containerSearchField != null) {
            if (!searchQuery.startsWith("#")) {
                return;
            }
            Slot hoveredSlot = this.getSlotUnderMouse();
            if (hoveredSlot == null || !hoveredSlot.m_6657_()) {
                return;
            }
            ItemStack stack = hoveredSlot.m_7993_();
            Registry itemRegistry = this.f_96541_.f_91073_.m_9598_().m_175515_(Registries.f_256913_);
            List originalTooltip = stack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_));
            boolean foundTags = false;
            for (Pair tag : itemRegistry.m_203612_().toList()) {
                if (!stack.m_204117_((TagKey)tag.getFirst())) continue;
                String tagString = "#" + ((TagKey)tag.getFirst()).f_203868_();
                originalTooltip.add(1, Component.m_237113_((String)tagString).m_130940_(ChatFormatting.LIGHT_PURPLE));
                foundTags = true;
            }
            if (foundTags) {
                graphics.m_280677_(this.f_96547_, originalTooltip, Optional.empty(), x, y);
                ci.cancel();
            }
        }
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void closeButtonOnClickOutOfBounds(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        if (QoQ.modEnabled(this.f_96541_) && ((Boolean)ModClientOptions.BETTER_GUI_EXIT.get()).booleanValue() && this.f_97732_.m_142621_().m_41619_() && button == 0 && slot == null) {
            this.m_7379_();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseClicking(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.f_96541_)) {
            if (button == 1 && this.f_97734_ != null && ButtonUtil.isQuicklyEquippable(this.f_97734_.m_7993_())) {
                ButtonUtil.quickEquip(this.screen, this.f_97734_);
                cir.setReturnValue((Object)true);
            }
            if (this.inventorySearchField != null && this.inventorySearchField.m_6375_(mouseX, mouseY, button)) {
                this.inventorySearchField.m_93692_(true);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleKeyPressing(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.f_96541_)) {
            AbstractContainerScreen<?> swapKeyValid2;
            AbstractContainerScreen<?> abstractContainerScreen;
            boolean cannotType;
            if (Screen.m_96637_() && ((Boolean)ModClientOptions.SHORTCUT_KEYS.get()).booleanValue()) {
                if (this.transferContainerButton != null && this.transferContainerButton.f_93623_ && keyCode == ModKeybinds.MOVE_CONTAINER.getKey().m_84873_()) {
                    this.transferItems(true);
                }
                if (this.transferInventoryButton != null && this.transferInventoryButton.f_93623_ && keyCode == ModKeybinds.MOVE_INVENTORY.getKey().m_84873_()) {
                    this.transferItems(false);
                }
                if (this.swapCooldown == 0 && this.swapButton != null && this.swapButton.f_93623_ && keyCode == ModKeybinds.SWAP_ITEMS.getKey().m_84873_()) {
                    ButtonUtil.swapItems(this.f_97732_, this.container);
                    this.swapCooldown = 120;
                }
                if (this.quickDropButton != null && this.quickDropButton.f_93623_ && Screen.m_96639_() && keyCode == 81) {
                    this.dropItems(!ButtonUtil.isContainerScreen(this.screen));
                }
            }
            if (keyCode == ModKeybinds.QUICK_EQUIP.getKey().m_84873_()) {
                ButtonUtil.quickEquip(this.screen, this.f_97734_);
            }
            if (keyCode == 69 && ((Boolean)ModClientOptions.PREVENT_E_FROM_TYPING.get()).booleanValue() && (ButtonUtil.isInventoryScreen(this.screen) || ButtonUtil.isCreativeInventoryScreen(this.screen))) {
                this.m_7379_();
                cir.setReturnValue((Object)true);
            }
            boolean ignoreTyping = ButtonUtil.hoveredSlotHasItem(this.f_97734_);
            boolean secondaryIgnoreTyping = false;
            boolean numberKeyPressed = false;
            boolean hotbarKeyPressed = false;
            boolean dropKeyPressed = false;
            boolean swapKeyPressed = false;
            for (int key : QoQ.allDisallowedKeys) {
                if (keyCode != key) continue;
                ignoreTyping = true;
                secondaryIgnoreTyping = true;
                break;
            }
            if (this.f_97732_.m_142621_().m_41619_() && this.f_97734_ != null) {
                for (int i = 0; i < 9; ++i) {
                    if (!this.f_96541_.f_91066_.f_92056_[i].m_90832_(keyCode, scanCode)) continue;
                    ignoreTyping = true;
                    secondaryIgnoreTyping = true;
                    hotbarKeyPressed = true;
                    break;
                }
                if (this.screen instanceof InventoryScreen && keyCode == ModKeybinds.QUICK_EQUIP.getKey().m_84873_()) {
                    ignoreTyping = true;
                }
            }
            for (int key : QoQ.popularKeys) {
                if (keyCode != key) continue;
                secondaryIgnoreTyping = false;
                cir.setReturnValue((Object)true);
                break;
            }
            List<Integer> numbers = List.of(Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(51), Integer.valueOf(52), Integer.valueOf(53), Integer.valueOf(54), Integer.valueOf(55), Integer.valueOf(56), Integer.valueOf(57));
            for (int key : numbers) {
                if (keyCode != key) continue;
                numberKeyPressed = true;
                break;
            }
            if (keyCode == Minecraft.m_91087_().f_91066_.f_92094_.getKey().m_84873_()) {
                secondaryIgnoreTyping = true;
                dropKeyPressed = true;
            } else if (keyCode == Minecraft.m_91087_().f_91066_.f_92093_.getKey().m_84873_()) {
                secondaryIgnoreTyping = true;
                swapKeyPressed = true;
            }
            boolean bl = cannotType = (numberKeyPressed || hotbarKeyPressed || dropKeyPressed || swapKeyPressed) && ButtonUtil.hoveredSlotHasItem(this.f_97734_);
            if (((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue() && (abstractContainerScreen = this.screen) instanceof InventoryScreen) {
                InventoryScreen recipeScreen = (InventoryScreen)abstractContainerScreen;
                if (!Screen.m_96637_()) {
                    boolean swapKeyValid2;
                    boolean bl2 = swapKeyValid2 = swapKeyPressed && (ButtonUtil.hoveredSlotHasItem(this.f_97734_) || this.f_97732_.m_38853_(45).m_6657_());
                    if (!(ignoreTyping || swapKeyValid2 || recipeScreen.m_5564_().m_100385_() || this.inventorySearchField != null && this.inventorySearchField.m_93696_())) {
                        recipeScreen.m_5564_().m_100384_();
                        this.m_267719_();
                    }
                    if (recipeScreen.m_5564_().f_100281_ != null) {
                        recipeScreen.m_5564_().f_100281_.m_93692_(!cannotType);
                        if (recipeScreen.m_5564_().f_100281_.m_93696_()) {
                            cir.setReturnValue((Object)(recipeScreen.m_5564_().m_7933_(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers) ? 1 : 0));
                        }
                    }
                }
            }
            if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() && this.inventorySearchField != null) {
                InventoryScreen recipeScreen;
                if (!Screen.m_96637_() && (swapKeyValid2 = this.screen) instanceof InventoryScreen && (recipeScreen = (InventoryScreen)swapKeyValid2).m_5564_().m_100385_() && !this.inventorySearchField.m_93696_()) {
                    recipeScreen.m_5564_().f_100281_.m_93692_(!cannotType);
                } else if (!secondaryIgnoreTyping && (!Screen.m_96637_() || Screen.m_96637_() && keyCode == 65)) {
                    this.inventorySearchField.m_93692_(true);
                    this.m_7522_((GuiEventListener)this.inventorySearchField);
                } else if (this.inventorySearchField.m_93696_() && cannotType) {
                    this.inventorySearchField.m_93692_(false);
                }
                swapKeyValid2 = this.screen;
                if (swapKeyValid2 instanceof InventoryScreen) {
                    InventoryScreen recipeScreen2 = (InventoryScreen)swapKeyValid2;
                    if (recipeScreen2.m_5564_().f_100281_ != null) {
                        if (this.inventorySearchField.m_93696_()) {
                            recipeScreen2.m_5564_().f_100281_.m_93692_(false);
                        } else if (recipeScreen2.m_5564_().f_100281_.m_93696_() && this.inventorySearchField != null) {
                            this.inventorySearchField.m_93692_(false);
                        }
                    }
                }
                if (this.inventorySearchField.m_93696_() && this.inventorySearchField.m_7933_(keyCode, scanCode, modifiers)) {
                    cir.setReturnValue((Object)true);
                }
            }
            if ((swapKeyValid2 = this.screen) instanceof InventoryScreen) {
                InventoryScreen inventoryScreen = (InventoryScreen)swapKeyValid2;
                EditBox searchBox = inventoryScreen.m_5564_().f_100281_;
                if (searchBox != null && searchBox.m_93696_()) {
                    this.m_7522_((GuiEventListener)searchBox);
                }
            }
            if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && ButtonUtil.isContainerScreen(this.screen)) {
                if (!secondaryIgnoreTyping && (!Screen.m_96637_() || Screen.m_96637_() && keyCode == 65)) {
                    this.containerSearchField.m_93692_(true);
                } else if (this.containerSearchField.m_93696_() && cannotType) {
                    this.containerSearchField.m_93692_(false);
                }
                if (this.containerSearchField.m_93696_() && this.containerSearchField.m_7933_(keyCode, scanCode, modifiers)) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && this.containerSearchField != null && this.containerSearchField.m_93696_()) {
            return this.containerSearchField.m_5534_(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void saveSearchText(CallbackInfo ci) {
        if (((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue()) {
            if (ButtonUtil.isInventoryScreen(this.screen) && this.inventorySearchField != null) {
                QoQ.SAVED_TEXT = this.inventorySearchField.m_94155_();
            } else if (ButtonUtil.isContainerScreen(this.screen) && this.containerSearchField != null) {
                QoQ.SAVED_TEXT = this.containerSearchField.m_94155_();
            }
        }
    }

    public void m_6574_(Minecraft client, int width, int height) {
        if (this.containerSearchField != null) {
            String text = this.getSearchFieldText();
            boolean refocus = this.containerSearchField.m_93696_();
            this.m_6575_(client, width, height);
            this.containerSearchField.m_94144_(text);
            this.containerSearchField.m_93692_(refocus);
        }
    }
}

