/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.dillon.qualityofqueso.util.ModTexts;
import net.dillon.qualityofqueso.util.ModUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PauseScreen.class})
public class PauseScreenMixin
extends Screen {
    @Shadow
    @Final
    private boolean f_96306_;
    @Shadow
    @Nullable
    private Button f_252482_;
    @Unique
    private Button settingsButton;
    @Unique
    private Button blacklistServerButton;

    public PauseScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (this.f_96306_) {
            if (((Boolean)ModClientOptions.SHOW_QOQ_BUTTONS.get()).booleanValue()) {
                this.settingsButton = (Button)this.m_142416_((GuiEventListener)ButtonUtil.initializeButton(this.f_96541_, this, this.f_96543_ / 2 + 106, this.f_96544_ / 4 + 72 - 16));
            }
            if (this.f_252482_ != null && ((Boolean)ModClientOptions.PREVENT_RAGE_QUITTING.get()).booleanValue()) {
                this.f_252482_.f_93623_ = false;
            }
            if (this.f_96541_.m_91089_() != null) {
                String address = this.getServerAddress();
                this.blacklistServerButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ModTexts.BLANK, button -> {
                    ArrayList<String> servers = new ArrayList<String>((Collection)ModClientOptions.BLACKLISTED_SERVERS.get());
                    if (((List)ModClientOptions.BLACKLISTED_SERVERS.get()).contains(address)) {
                        servers.remove(address);
                    } else {
                        servers.add(address);
                    }
                    ModClientOptions.BLACKLISTED_SERVERS.set(servers);
                    ModClientOptions.SPEC.save();
                }).m_252987_(this.f_96543_ / 2 + 106, this.f_96544_ / 4 + 96 - 16, 20, 20).m_253136_());
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderTooltipsAndTextures(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.f_96306_) {
            if (((Boolean)ModClientOptions.SHOW_QOQ_BUTTONS.get()).booleanValue()) {
                ButtonUtil.drawTooltipAndTexture(ModTexts.CONFIGURE_QOQ, "cheese_wheel", graphics, this.f_96547_, this.settingsButton, mouseX, mouseY);
            }
            if (((Boolean)ModClientOptions.PREVENT_RAGE_QUITTING.get()).booleanValue() && ((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && this.f_252482_ != null && this.f_252482_.m_274382_()) {
                ButtonUtil.drawTooltip((Component)Component.m_237115_((String)"qualityofqueso.gui.disconnect"), graphics, this.f_96547_, mouseX, mouseY);
            }
            if (this.f_96541_.m_91089_() != null && this.blacklistServerButton != null) {
                this.blacklistServerButton.f_93623_ = ModUtil.isOnServer(this.f_96541_);
                String address = this.getServerAddress();
                if (this.blacklistServerButton.m_274382_()) {
                    ButtonUtil.drawTexture(graphics, this.isServerBlacklisted(address) ? "qoq_enabled" : "qoq_disabled", this.blacklistServerButton);
                    ButtonUtil.drawTooltip(this.tooltipWithPrefix((Component)(this.isServerBlacklisted(address) ? Component.m_237115_((String)"qualityofqueso.gui.remove_blacklisted_server") : Component.m_237115_((String)"qualityofqueso.gui.add_blacklisted_server"))), graphics, this.f_96547_, mouseX, mouseY);
                } else {
                    ButtonUtil.drawTexture(graphics, this.isServerBlacklisted(address) ? "qoq_disabled" : "qoq_enabled", this.blacklistServerButton);
                }
            }
        }
    }

    @Unique
    private Component tooltipWithPrefix(Component text) {
        return Component.m_237115_((String)"qualityofqueso.gui.blacklisted_server_button_prefix").m_130946_("\n").m_7220_(text);
    }

    @Unique
    private String getServerAddress() {
        return this.f_96541_.m_91089_().f_105363_;
    }

    @Unique
    private boolean isServerBlacklisted(String serverAddress) {
        return ((List)ModClientOptions.BLACKLISTED_SERVERS.get()).contains(serverAddress);
    }
}

