/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.packet;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import net.dillon.qualityofqueso.option.ModCommonOptions;
import net.dillon.qualityofqueso.util.GlowCountdown;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record GlowSearchC2SPayload(String query, boolean matchCase, boolean clear, int timer, int radius) {
    public GlowSearchC2SPayload(FriendlyByteBuf buf) {
        this(buf.m_130277_(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.query);
        buf.writeBoolean(this.matchCase);
        buf.writeBoolean(this.clear);
        buf.writeInt(this.timer);
        buf.writeInt(this.radius);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        if (((Boolean)ModCommonOptions.ITEM_FRAME_SEARCHING.get()).booleanValue()) {
            ServerPlayer player = context.get().getSender();
            ServerLevel world = (ServerLevel)player.m_9236_();
            Vec3 playerPos = player.m_20182_();
            List nearbyFrames = world.m_6443_(ItemFrame.class, new AABB(playerPos.m_82520_((double)(-this.radius), (double)(-this.radius), (double)(-this.radius)), playerPos.m_82520_((double)this.radius, (double)this.radius, (double)this.radius)), frame -> {
                String[] terms = this.query.split(",");
                if (this.clear) {
                    return true;
                }
                ItemStack stack = frame.m_31822_();
                if (stack.m_41619_()) {
                    return false;
                }
                String itemName = stack.m_41611_().getString().toLowerCase();
                String itemId = ForgeRegistries.ITEMS.getResourceKey((Object)stack.m_41720_()).toString().toLowerCase();
                for (String term : terms) {
                    String trimmed = term.trim().toLowerCase();
                    if (!(this.matchCase ? itemName.matches(trimmed) || itemId.matches(trimmed) : itemName.contains(trimmed) || itemId.matches(trimmed))) continue;
                    return true;
                }
                if (this.query.startsWith("#")) {
                    String tagSearch = this.query.substring(1);
                    Registry itemRegistry = world.m_9598_().m_175515_(Registries.f_256913_);
                    for (Pair tag : itemRegistry.m_203612_().toList()) {
                        ResourceLocation id = ((TagKey)tag.getFirst()).f_203868_();
                        if (!(this.matchCase ? id.m_135815_().toLowerCase().matches(tagSearch) || id.toString().toLowerCase().matches(tagSearch) : id.m_135815_().toLowerCase().contains(tagSearch) || id.toString().toLowerCase().contains(tagSearch)) || !stack.m_204117_((TagKey)tag.getFirst())) continue;
                        return true;
                    }
                }
                return false;
            });
            int searched = 0;
            for (ItemFrame frame2 : nearbyFrames) {
                boolean alreadyGlowing = frame2.m_142038_();
                frame2.m_146915_(!this.clear);
                ++searched;
                if (this.clear && !alreadyGlowing) {
                    --searched;
                }
                if (this.clear || this.timer == 0) continue;
                ((GlowCountdown)frame2).startGlowCountdown(this.timer * 20);
            }
            if (nearbyFrames.isEmpty()) {
                player.m_240418_((Component)(this.matchCase ? Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.found_none.match_case", (Object[])new Object[]{searched, this.query}) : Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.found_none", (Object[])new Object[]{searched, this.query})), false);
                player.m_6330_((SoundEvent)SoundEvents.f_12209_.get(), SoundSource.AMBIENT, 2.0f, 1.0f);
            } else if (this.clear) {
                player.m_240418_((Component)Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.cleared", (Object[])new Object[]{searched}), false);
                player.m_6330_(SoundEvents.f_12277_, SoundSource.AMBIENT, 1.0f, 1.0f);
            } else {
                if (this.timer == 0) {
                    player.m_213846_((Component)(this.matchCase ? Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.without_timer.match_case", (Object[])new Object[]{searched, this.query}) : Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.without_timer", (Object[])new Object[]{searched, this.query})));
                } else {
                    player.m_240418_((Component)(this.matchCase ? Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.with_timer.match_case", (Object[])new Object[]{searched, this.query, this.timer}) : Component.m_237110_((String)"qualityofqueso.item_frame_searcher.executed.with_timer", (Object[])new Object[]{searched, this.query, this.timer})), false);
                }
                player.m_6330_(SoundEvents.f_11686_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }
}

