/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModOptionsScreen;
import net.dillon.qualityofqueso.util.ModTexts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonUtil {
    public static final String CHEESE_WHEEL = "cheese_wheel";
    public static final String ENABLED_TEXTURE = "qoq_enabled";
    public static final String DISABLED_TEXTURE = "qoq_disabled";

    public static Button initializeButton(Minecraft client, Screen parent, int width, int height) {
        return new Button.Builder(ModTexts.BLANK, button -> client.m_91152_((Screen)new ModOptionsScreen(parent))).m_252987_(width, height, 20, 20).m_253136_();
    }

    public static void drawTooltipAndTexture(Component tooltip, String name, GuiGraphics graphics, Font font, Button button, int mouseX, int mouseY) {
        if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && button.m_274382_()) {
            ButtonUtil.drawTooltip(tooltip, graphics, font, mouseX, mouseY);
        }
        ButtonUtil.drawTexture(graphics, name, button);
    }

    public static void drawTooltip(Component tooltip, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        graphics.m_280245_(font, font.m_92923_((FormattedText)tooltip, 200), mouseX, mouseY);
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button, float f) {
        graphics.m_280163_(ResourceLocation.parse((String)("qualityofqueso:textures/gui/" + name + ".png")), button.m_252754_() + 1, button.m_252907_() + 1, 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button) {
        ButtonUtil.drawTexture(graphics, name, button, 1.0f);
    }

    public static int getBarWidth(int backgroundWidth) {
        return (int)((double)backgroundWidth * 0.6);
    }

    public static int getButtonX(Button button) {
        return button.m_252754_();
    }

    public static int getManagementButtonX(Screen screen, int backgroundWidth, int width) {
        int barWidth = ButtonUtil.getBarWidth(backgroundWidth);
        int modifier = 18;
        if (screen instanceof InventoryScreen) {
            InventoryScreen recipeBookScreen = (InventoryScreen)screen;
            modifier = 42;
            if (recipeBookScreen.m_5564_().m_100385_()) {
                modifier = 119;
            }
        }
        return width / 2 + barWidth / 2 + modifier;
    }

    public static int getManagementButtonY(Screen screen, Container inventory, int screenY, int titleY) {
        int y = 2 * inventory.m_6643_() + 12;
        return screenY + titleY + (screen instanceof InventoryScreen ? 64 : y);
    }

    public static int getContainerSize(Container inventory) {
        return inventory.m_6643_();
    }

    public static int getTotalSlots(AbstractContainerMenu handler) {
        return handler.f_38839_.size();
    }

    public static int getInventorySize(AbstractContainerMenu handler, Container inventory) {
        return (Boolean)ModClientOptions.SEARCH_INVENTORY.get() != false ? handler.f_38839_.size() : inventory.m_6643_();
    }

    public static boolean isHotbarSlot(int totalSlots, int slotIndex) {
        return slotIndex >= totalSlots - 9;
    }

    public static boolean isInventoryHotbarSlot(boolean isInventoryScreen, int slotIndex) {
        return isInventoryScreen && slotIndex <= 44 && slotIndex >= 36;
    }

    public static boolean isExcludedSlot(Screen screen, int slotIndex) {
        return screen instanceof InventoryScreen && (slotIndex <= 8 && slotIndex >= 5 || slotIndex == 45);
    }

    public static boolean isAnySlotFilled(AbstractContainerMenu handler, boolean checkHotbar, int start, int end) {
        for (int i = start; i < ((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() != false && checkHotbar ? end + 9 : end); ++i) {
            Slot slot = handler.m_38853_(i);
            if (!slot.m_6657_()) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainerFull(AbstractContainerMenu handler, Container inv, boolean inventory) {
        int j = 0;
        int containerSize = ButtonUtil.getContainerSize(inv);
        for (int i = inventory ? containerSize : 0; i < (inventory ? containerSize + 36 : containerSize); ++i) {
            Slot slot = handler.m_38853_(i);
            if (!slot.m_6657_()) continue;
            ++j;
        }
        return j == (inventory ? 36 : containerSize);
    }

    public static boolean hoveredSlotHasItem(Slot focusedSlot) {
        return focusedSlot != null && focusedSlot.m_7993_() != ItemStack.f_41583_;
    }

    public static void swapItems(AbstractContainerMenu handler, Container inventory) {
        int totalSlots = ButtonUtil.getTotalSlots(handler);
        int containerSize = ButtonUtil.getContainerSize(inventory);
        int offset = totalSlots - 27 - 9;
        int swaps = Math.min(totalSlots - containerSize, containerSize);
        for (int i = 0; i < swaps; ++i) {
            int playerSlotIndex = i + offset;
            if (i >= totalSlots || playerSlotIndex >= totalSlots) continue;
            Slot chestSlot = handler.m_38853_(i);
            Slot playerSlot = handler.m_38853_(playerSlotIndex);
            if (!((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && ButtonUtil.isHotbarSlot(handler.f_38839_.size(), playerSlot.f_40219_)) continue;
            ItemStack chestStack = chestSlot.m_7993_();
            ItemStack playerStack = playerSlot.m_7993_();
            if (chestStack.m_41619_() && playerStack.m_41619_()) continue;
            ButtonUtil.sendSwapSlotPacket(playerSlot.f_40219_, chestSlot.f_40219_);
        }
    }

    public static void sendSwapSlotPacket(int source, int index) {
        ButtonUtil.sendClickSlotPacket(source, ClickType.PICKUP);
        ButtonUtil.sendClickSlotPacket(index, ClickType.PICKUP);
        ButtonUtil.sendClickSlotPacket(source, ClickType.PICKUP);
    }

    public static void sendClickSlotPacket(int slotIndex, ClickType clickType) {
        Minecraft client = Minecraft.m_91087_();
        ClientPacketListener networkHandler = client.m_91403_();
        if (client.f_91074_ == null || networkHandler == null || client.f_91074_.f_36096_ == null) {
            return;
        }
        AbstractContainerMenu handler = client.f_91074_.f_36096_;
        int syncId = handler.f_38840_;
        int stateId = handler.m_182424_();
        ItemStack carriedStack = handler.m_142621_();
        ItemStack clickedStack = handler.m_38853_(slotIndex).m_7993_();
        if (clickType == ClickType.THROW) {
            if (!handler.m_38853_(slotIndex).m_7993_().m_41619_()) {
                client.f_91072_.m_171799_(syncId, slotIndex, 1, clickType, (Player)client.f_91074_);
            }
            return;
        }
        Int2ObjectOpenHashMap modifiedStacks = new Int2ObjectOpenHashMap();
        modifiedStacks.put(slotIndex, (Object)clickedStack);
        ServerboundContainerClickPacket packet = new ServerboundContainerClickPacket(syncId, stateId, (int)((short)slotIndex), 0, clickType, carriedStack, (Int2ObjectMap)modifiedStacks);
        networkHandler.m_104955_((Packet)packet);
    }

    public static boolean isQuicklyEquippable(ItemStack stack) {
        for (TagKey<Item> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
            if (!stack.m_204117_(quicklyEquippable) && !stack.m_150930_(Items.f_42741_)) continue;
            return true;
        }
        return false;
    }

    public static void quickSwap(int sourceSlot, EquipmentSlot slot) {
        int slotIndex = slot == EquipmentSlot.HEAD ? 5 : (slot == EquipmentSlot.CHEST ? 6 : (slot == EquipmentSlot.LEGS ? 7 : (slot == EquipmentSlot.FEET ? 8 : 6)));
        ButtonUtil.sendSwapSlotPacket(sourceSlot, slotIndex);
    }

    public static void quickEquip(Screen screen, Slot focusedSlot) {
        if (((Boolean)ModClientOptions.QUICK_EQUIP.get()).booleanValue() && focusedSlot != null && focusedSlot.f_40219_ >= 5 && (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen)) {
            ItemStack stack = focusedSlot.m_7993_();
            EquipmentSlot targetSlot = null;
            for (TagKey<Item> quicklyEquippable : QoQ.quicklyEquippables.keySet()) {
                if (!stack.m_204117_(quicklyEquippable)) continue;
                targetSlot = QoQ.quicklyEquippables.get(quicklyEquippable);
            }
            if (stack.m_150930_(Items.f_42741_)) {
                targetSlot = EquipmentSlot.CHEST;
            }
            if (targetSlot != null) {
                Minecraft client = Minecraft.m_91087_();
                ItemStack equippedStack = client.f_91074_.m_6844_(targetSlot);
                if (equippedStack.m_41619_()) {
                    ButtonUtil.sendClickSlotPacket(focusedSlot.f_40219_, ClickType.QUICK_MOVE);
                } else {
                    ButtonUtil.quickSwap(focusedSlot.f_40219_, targetSlot);
                }
            }
        }
    }

    public static void makeSlotUnavailable(GuiGraphics graphics, Slot slot, boolean hotbar) {
        int color = hotbar ? -2139062148 : -1275068416;
        graphics.m_285978_(RenderType.m_286086_(), slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, color, color, 0);
    }

    public static boolean isContainerScreen(Screen screen) {
        return screen instanceof ContainerScreen || screen instanceof ShulkerBoxScreen;
    }

    public static boolean isInventoryScreen(Screen screen) {
        return screen instanceof InventoryScreen;
    }

    public static boolean isCreativeInventoryScreen(Screen screen) {
        return screen instanceof CreativeModeInventoryScreen;
    }
}

