/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.dillon.qualityofqueso.util.ModTexts;
import net.dillon.qualityofqueso.util.ModUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PauseScreen.class})
public class PauseScreenMixin
extends Screen {
    @Shadow
    @Final
    private boolean showPauseMenu;
    @Shadow
    @Nullable
    private Button disconnectButton;
    @Unique
    private Button settingsButton;
    @Unique
    private Button blacklistServerButton;

    public PauseScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (this.showPauseMenu) {
            if (((Boolean)ModClientOptions.SHOW_QOQ_BUTTONS.get()).booleanValue()) {
                this.settingsButton = (Button)this.addRenderableWidget((GuiEventListener)ButtonUtil.initializeButton(this.minecraft, this, this.width / 2 + 106, this.height / 4 + 72 - 16));
            }
            if (this.disconnectButton != null && ((Boolean)ModClientOptions.PREVENT_RAGE_QUITTING.get()).booleanValue()) {
                this.disconnectButton.active = false;
            }
            if (this.minecraft.getCurrentServer() != null) {
                String address = this.getServerAddress();
                this.blacklistServerButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ModTexts.BLANK, button -> {
                    ArrayList<String> servers = new ArrayList<String>((Collection)ModClientOptions.BLACKLISTED_SERVERS.get());
                    if (((List)ModClientOptions.BLACKLISTED_SERVERS.get()).contains(address)) {
                        servers.remove(address);
                    } else {
                        servers.add(address);
                    }
                    ModClientOptions.BLACKLISTED_SERVERS.set(servers);
                    ModClientOptions.SPEC.save();
                }).bounds(this.width / 2 + 106, this.height / 4 + 96 - 16, 20, 20).build());
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderTooltipsAndTextures(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (this.showPauseMenu) {
            if (((Boolean)ModClientOptions.SHOW_QOQ_BUTTONS.get()).booleanValue()) {
                ButtonUtil.drawTooltipAndTexture(ModTexts.CONFIGURE_QOQ, "cheese_wheel", graphics, this.font, this.settingsButton, mouseX, mouseY);
            }
            if (((Boolean)ModClientOptions.PREVENT_RAGE_QUITTING.get()).booleanValue() && ((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && this.disconnectButton != null && this.disconnectButton.isHovered()) {
                ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.disconnect"), graphics, this.font, mouseX, mouseY);
            }
            if (this.minecraft.getCurrentServer() != null && this.blacklistServerButton != null) {
                this.blacklistServerButton.active = ModUtil.isOnServer(this.minecraft);
                String address = this.getServerAddress();
                if (this.blacklistServerButton.isHovered()) {
                    ButtonUtil.drawTexture(graphics, this.isServerBlacklisted(address) ? "qoq_enabled" : "qoq_disabled", this.blacklistServerButton);
                    ButtonUtil.drawTooltip(this.tooltipWithPrefix((Component)(this.isServerBlacklisted(address) ? Component.translatable((String)"qualityofqueso.gui.remove_blacklisted_server") : Component.translatable((String)"qualityofqueso.gui.add_blacklisted_server"))), graphics, this.font, mouseX, mouseY);
                } else {
                    ButtonUtil.drawTexture(graphics, this.isServerBlacklisted(address) ? "qoq_disabled" : "qoq_enabled", this.blacklistServerButton);
                }
            }
        }
    }

    @Unique
    private Component tooltipWithPrefix(Component text) {
        return Component.translatable((String)"qualityofqueso.gui.blacklisted_server_button_prefix").append("\n").append(text);
    }

    @Unique
    private String getServerAddress() {
        return this.minecraft.getCurrentServer().ip;
    }

    @Unique
    private boolean isServerBlacklisted(String serverAddress) {
        return ((List)ModClientOptions.BLACKLISTED_SERVERS.get()).contains(serverAddress);
    }
}

