/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.option.options;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.dillon.qualityofqueso.option.AbstractModOptionsScreen;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModListOptions;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MiscOptionsScreen
extends AbstractModOptionsScreen {
    private EditBox blacklistedServersField;
    private List<String> blacklistedServers = new ArrayList<String>();

    public MiscOptionsScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"qualityofqueso.gui.title.chest_searching_options"));
    }

    @Override
    protected OptionInstance<?>[] options() {
        return new OptionInstance[]{ModListOptions.ENABLE_MOD, ModListOptions.QUICK_EQUIP, ModListOptions.BETTER_SEARCHING, ModListOptions.BETTER_GUI_EXIT, ModListOptions.PREVENT_RAGE_QUITTING, ModListOptions.PREVENT_E_FROM_TYPING, ModListOptions.HELPFUL_TOOLTIPS, ModListOptions.SHOW_QOQ_BUTTONS};
    }

    @Override
    protected void init() {
        super.init();
        this.list.addSmall(this.options());
        this.blacklistedServers = new ArrayList<String>((Collection)ModClientOptions.BLACKLISTED_SERVERS.get());
        this.blacklistedServersField = new EditBox(this.font, this.width / 2 - 150, 70, 310, 20, (Component)Component.empty());
        this.blacklistedServersField.setMaxLength(Integer.MAX_VALUE);
        this.blacklistedServersField.setHint((Component)Component.translatable((String)"qualityofqueso.options.blacklisted_servers").withStyle(ChatFormatting.GRAY));
        this.blacklistedServersField.setValue(String.join((CharSequence)", ", this.blacklistedServers));
        this.blacklistedServersField.setResponder(this::onTextChanged);
        ImmutableList widgets = ImmutableList.of((Object)this.blacklistedServersField);
        this.list.addSmall((List)widgets);
    }

    private void onTextChanged(String newText) {
        String[] servers;
        this.blacklistedServers.clear();
        for (String server : servers = newText.split(",")) {
            String trimmed = server.trim();
            if (trimmed.isEmpty()) continue;
            this.blacklistedServers.add(trimmed);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        super.render(graphics, mouseX, mouseY, deltaTicks);
        if (this.blacklistedServersField.isHovered()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.options.blacklisted_servers.tooltip"), graphics, this.font, mouseX, mouseY);
        }
    }

    @Override
    public void onClose() {
        ModClientOptions.BLACKLISTED_SERVERS.set(List.of());
        ArrayList<String> updated = new ArrayList<String>(this.blacklistedServers);
        ModClientOptions.BLACKLISTED_SERVERS.set(updated);
        super.onClose();
    }

    @Override
    protected boolean addOptionsByDefault() {
        return false;
    }
}

