/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.screen;

import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModListOptions;
import net.dillon.qualityofqueso.packet.GlowSearchC2SPayload;
import net.dillon.qualityofqueso.packet.ServerHandler;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.dillon.qualityofqueso.util.ModTexts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemFrameSearchScreen
extends Screen {
    private EditBox searchField;
    private Button searchButton;
    private Button clearButton;

    public ItemFrameSearchScreen() {
        super(ModTexts.BLANK);
    }

    protected void init() {
        this.searchField = new EditBox(this.font, this.width / 2 - 100, this.height / 2 - 24, 200, 20, (Component)Component.empty());
        if (((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue()) {
            this.searchField.setValue(QoQ.SAVED_ITEM_FRAME_TEXT);
        }
        this.searchField.setMaxLength(50);
        this.searchButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.search"), button -> this.sendPacket(false, (Integer)ModClientOptions.ITEM_FRAME_SEARCH_TIMER.get() != 0 ? (Integer)ModClientOptions.ITEM_FRAME_SEARCH_TIMER.get() : 0, (Integer)ModClientOptions.ITEM_FRAME_SEARCH_RADIUS.get())).bounds(this.width / 2 + 115, this.height / 2 + 24, 100, 20).build());
        AbstractWidget itemFrameSearchTimer = (AbstractWidget)this.addRenderableWidget((GuiEventListener)ModListOptions.ITEM_FRAME_SEARCH_TIMER.createButton(Minecraft.getInstance().options, this.width / 2 + 5, 20, 100));
        itemFrameSearchTimer.setY(this.height / 2 + 24);
        AbstractWidget itemFrameSearchRadius = (AbstractWidget)this.addRenderableWidget((GuiEventListener)ModListOptions.ITEM_FRAME_SEARCH_RADIUS.createButton(Minecraft.getInstance().options, itemFrameSearchTimer.getX(), 20, 100));
        itemFrameSearchRadius.setY(itemFrameSearchTimer.getY() + 32);
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.clear"), button -> {
            this.searchField.setValue("");
            this.sendPacket(true, 0, (Integer)ModClientOptions.ITEM_FRAME_SEARCH_RADIUS.get());
        }).bounds(this.width / 2 - 105, this.height / 2 + 24, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"qualityofqueso.gui.close"), button -> this.onClose()).bounds(this.width / 2 - 215, this.height / 2 + 24, 100, 20).build());
        this.addWidget((GuiEventListener)this.searchField);
        this.setInitialFocus((GuiEventListener)this.searchField);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
        super.render(graphics, mouseX, mouseY, deltaTicks);
        this.searchField.render(graphics, mouseX, mouseY, deltaTicks);
        graphics.drawString(this.font, (Component)Component.translatable((String)"qualityofqueso.gui.search_item_frames"), this.width / 2 - 135, this.height / 2 - 104, -1);
        graphics.drawString(this.font, (Component)Component.translatable((String)"qualityofqueso.gui.search_item_frames.warning.line1"), this.width / 2 - 175, this.height / 2 - 80, -1);
        graphics.drawString(this.font, (Component)Component.translatable((String)"qualityofqueso.gui.search_item_frames.warning.line2"), this.width / 2 - 110, this.height / 2 - 56, -1);
        boolean bl = this.searchButton.active = !this.searchField.getValue().isEmpty();
        if (!this.searchField.getValue().isEmpty() && this.searchButton.isHovered()) {
            ButtonUtil.drawTooltip((Component)(!Screen.hasControlDown() ? Component.translatable((String)"qualityofqueso.gui.search.tooltip", (Object[])new Object[]{this.searchField.getValue()}) : Component.translatable((String)"qualityofqueso.gui.search.match_case.tooltip", (Object[])new Object[]{this.searchField.getValue()})), graphics, this.font, mouseX, mouseY);
        }
        if (this.clearButton.isHovered()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.clear.tooltip"), graphics, this.font, mouseX, mouseY);
        }
        if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && this.searchField.isHovered() && this.searchField.getValue().isEmpty()) {
            ButtonUtil.drawTooltip((Component)Component.translatable((String)"qualityofqueso.gui.search_item_frames.search_filtering"), graphics, this.font, mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && !this.searchField.getValue().isEmpty()) {
            this.sendPacket(false, (Integer)ModClientOptions.ITEM_FRAME_SEARCH_TIMER.get() != 0 ? (Integer)ModClientOptions.ITEM_FRAME_SEARCH_TIMER.get() : 0, (Integer)ModClientOptions.ITEM_FRAME_SEARCH_RADIUS.get());
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        QoQ.SAVED_ITEM_FRAME_TEXT = this.searchField.getValue();
        QoQ.saveAll();
        super.onClose();
    }

    private void sendPacket(boolean clear, int timer, int radius) {
        this.onClose();
        ServerHandler.sendToServer(new GlowSearchC2SPayload(this.searchField.getValue(), Screen.hasControlDown(), clear, timer, radius));
    }
}

