/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.util;

import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.option.ModOptionsScreen;
import net.dillon.qualityofqueso.util.ModTexts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonUtil {
    public static final String CHEESE_WHEEL = "cheese_wheel";
    public static final String ENABLED_TEXTURE = "qoq_enabled";
    public static final String DISABLED_TEXTURE = "qoq_disabled";

    public static Button initializeButton(Minecraft client, Screen parent, int width, int height) {
        return new Button.Builder(ModTexts.BLANK, button -> client.setScreen((Screen)new ModOptionsScreen(parent))).bounds(width, height, 20, 20).build();
    }

    public static void drawTooltipAndTexture(Component tooltip, String name, GuiGraphics graphics, Font font, Button button, int mouseX, int mouseY) {
        if (((Boolean)ModClientOptions.HELPFUL_TOOLTIPS.get()).booleanValue() && button.isHovered()) {
            ButtonUtil.drawTooltip(tooltip, graphics, font, mouseX, mouseY);
        }
        ButtonUtil.drawTexture(graphics, name, button);
    }

    public static void drawTooltip(Component tooltip, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        graphics.renderTooltip(font, font.split((FormattedText)tooltip, 200), mouseX, mouseY);
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button, float f) {
        graphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)("qualityofqueso:textures/gui/" + name + ".png")), button.getX() + 1, button.getY() + 1, 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void drawTexture(GuiGraphics graphics, String name, Button button) {
        ButtonUtil.drawTexture(graphics, name, button, 1.0f);
    }
}

