/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.packet;

import java.util.List;
import net.dillon.qualityofqueso.option.ModCommonOptions;
import net.dillon.qualityofqueso.packet.GlowSearchC2SPayload;
import net.dillon.qualityofqueso.util.GlowCountdown;
import net.dillon.qualityofqueso.util.ModUtil;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class ServerHandler
implements ModInitializer {
    public void onInitialize() {
        if (((ModCommonOptions)ModCommonOptions.COMMON_OPTIONS.getInstance()).itemFrameSearching) {
            ServerHandler.registerGlowSearchPacketReceiver();
            ModUtil.debug("Registered glowing packet on server.");
        } else {
            ModUtil.debug("Did NOT register glowing packet, \"itemFrameSearchingOnServer\" is disabled. No-one can use this feature unless enabled here on server environment.");
        }
    }

    private static void registerGlowSearchPacketReceiver() {
        PayloadTypeRegistry.playC2S().register(GlowSearchC2SPayload.ID, GlowSearchC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(GlowSearchC2SPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            class_3218 world = player.method_51469();
            class_243 playerPos = player.method_19538();
            double radius = payload.radius();
            List nearbyFrames = world.method_8390(class_1533.class, new class_238(playerPos.method_1031(-radius, -radius, -radius), playerPos.method_1031(radius, radius, radius)), frame -> {
                String[] terms = payload.query().split(",");
                if (payload.clear()) {
                    return true;
                }
                class_1799 stack = frame.method_6940();
                if (stack.method_7960()) {
                    return false;
                }
                String itemName = stack.method_7909().method_63680().getString().toLowerCase();
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().toLowerCase();
                for (String term : terms) {
                    String trimmed = term.trim().toLowerCase();
                    if (!(payload.matchCase() ? itemName.matches(trimmed) || itemId.matches(trimmed) : itemName.contains(trimmed) || itemId.contains(trimmed))) continue;
                    return true;
                }
                if (payload.query().startsWith("#")) {
                    String tagSearch = payload.query().substring(1);
                    class_5455 lookup = world.method_30349();
                    class_7225.class_7226 itemRegistry = lookup.method_46762(class_7924.field_41197);
                    for (class_6862 tagKey : itemRegistry.method_46755().toList()) {
                        class_2960 id = tagKey.comp_327();
                        if (!(payload.matchCase() ? id.method_12832().toLowerCase().matches(tagSearch) || id.toString().toLowerCase().matches(tagSearch) : id.method_12832().toLowerCase().contains(tagSearch) || id.toString().toLowerCase().contains(tagSearch)) || !stack.method_31573(tagKey)) continue;
                        return true;
                    }
                }
                return false;
            });
            int searched = 0;
            for (class_1533 frame2 : nearbyFrames) {
                boolean alreadyGlowing = frame2.method_5851();
                frame2.method_5834(!payload.clear());
                ++searched;
                if (payload.clear() && !alreadyGlowing) {
                    --searched;
                }
                if (payload.clear() || payload.timer() == 0) continue;
                ((GlowCountdown)frame2).startGlowCountdown(payload.timer() * 20);
            }
            if (nearbyFrames.isEmpty()) {
                player.method_7353((class_2561)(payload.matchCase() ? class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.found_none.match_case", (Object[])new Object[]{searched, payload.query()}) : class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.found_none", (Object[])new Object[]{searched, payload.query()})), false);
                player.method_17356((class_3414)class_3417.field_14624.comp_349(), class_3419.field_15256, 2.0f, 1.0f);
            } else if (payload.clear()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.cleared", (Object[])new Object[]{searched}), false);
                player.method_17356(class_3417.field_14810, class_3419.field_15256, 1.0f, 1.0f);
            } else {
                if (payload.timer() == 0) {
                    player.method_7353((class_2561)(payload.matchCase() ? class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.without_timer.match_case", (Object[])new Object[]{searched, payload.query()}) : class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.without_timer", (Object[])new Object[]{searched, payload.query()})), false);
                } else {
                    player.method_7353((class_2561)(payload.matchCase() ? class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.with_timer.match_case", (Object[])new Object[]{searched, payload.query(), payload.timer()}) : class_2561.method_43469((String)"qualityofqueso.item_frame_searcher.executed.with_timer", (Object[])new Object[]{searched, payload.query(), payload.timer()})), false);
                }
                player.method_17356(class_3417.field_15224, class_3419.field_15256, 1.0f, 1.0f);
            }
        });
    }
}

