/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.dillon.qualityofqueso.keybind.ModKeybinds;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.dillon.qualityofqueso.screen.gui.IncludeHotbarButton;
import net.dillon.qualityofqueso.screen.gui.QuickDropButton;
import net.dillon.qualityofqueso.screen.gui.SearchField;
import net.dillon.qualityofqueso.screen.gui.SwapButton;
import net.dillon.qualityofqueso.screen.gui.TransferButton;
import net.dillon.qualityofqueso.util.ButtonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int topPos;
    @Shadow
    protected int titleLabelY;
    @Shadow
    @Final
    protected T menu;
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Unique
    private final AbstractContainerScreen<?> screen = (AbstractContainerScreen)this;
    @Unique
    private EditBox containerSearchField;
    @Unique
    private EditBox inventorySearchField;
    @Unique
    private TransferButton transferContainerButton;
    @Unique
    private TransferButton transferInventoryButton;
    @Unique
    private TransferButton includeHotbarButton;
    @Unique
    private TransferButton quickDropButton;
    @Unique
    private TransferButton swapButton;
    @Unique
    private int swapCooldown = 0;
    @Unique
    private Container container;

    @Shadow
    @Nullable
    public abstract Slot getSlotUnderMouse();

    public AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft)) {
            if (ButtonUtil.isContainerScreen(this.screen)) {
                AbstractContainerScreen<?> abstractContainerScreen = this.screen;
                if (abstractContainerScreen instanceof ShulkerBoxScreen) {
                    ShulkerBoxScreen shulkerBoxScreen = (ShulkerBoxScreen)abstractContainerScreen;
                    this.container = ((ShulkerBoxMenu)shulkerBoxScreen.getMenu()).container;
                } else {
                    abstractContainerScreen = this.screen;
                    if (abstractContainerScreen instanceof ContainerScreen) {
                        ContainerScreen genericContainerScreen = (ContainerScreen)abstractContainerScreen;
                        this.container = ((ChestMenu)genericContainerScreen.getMenu()).getContainer();
                    } else {
                        this.container = null;
                    }
                }
                if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue()) {
                    this.containerSearchField = this.initializeSearchField(false);
                    this.addRenderableWidget((GuiEventListener)this.containerSearchField);
                }
            } else if (ButtonUtil.isInventoryScreen(this.screen)) {
                this.container = this.minecraft.player.getInventory();
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue()) {
                    this.inventorySearchField = this.initializeSearchField(true);
                    this.addRenderableWidget((GuiEventListener)this.inventorySearchField);
                }
            }
        }
    }

    @Unique
    private SearchField initializeSearchField(boolean inventory) {
        return new SearchField(this.font, this.width / 2 + ButtonUtil.getBarWidth(this.imageWidth) / 2 - (inventory ? 60 : 64), this.topPos + this.titleLabelY - 2);
    }

    @Unique
    private String getSearchFieldText() {
        return this.inventorySearchField != null ? this.inventorySearchField.getValue() : (this.containerSearchField != null ? this.containerSearchField.getValue() : "");
    }

    @Unique
    private void dropItems(boolean fromInventory) {
        this.moveItems(true, true, fromInventory);
    }

    @Unique
    private void transferItems(boolean toInventory) {
        this.moveItems(toInventory, false, false);
    }

    @Unique
    private void moveItems(boolean toInventory, boolean drop, boolean fromInventory) {
        int toEnd;
        int containerSize = ButtonUtil.getContainerSize(this.container);
        int totalSlots = ButtonUtil.getTotalSlots(this.menu);
        int fromStart = toInventory ? 0 : containerSize;
        int fromEnd = toInventory ? containerSize : totalSlots;
        int toStart = toInventory ? containerSize : 0;
        int n = toEnd = toInventory ? totalSlots : containerSize;
        if (drop && fromInventory) {
            fromStart = 9;
            fromEnd = 45;
        }
        block0: for (int i = fromStart; i < fromEnd; ++i) {
            Slot fromSlot = this.menu.getSlot(i);
            ItemStack fromStack = fromSlot.getItem();
            if ((this.containerSearchField != null || this.inventorySearchField != null) && !this.getSearchFieldText().isEmpty() && !this.search(this.getSearchFieldText(), fromSlot, false) || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && (!drop ? !toInventory && ButtonUtil.isHotbarSlot(fromEnd, fromSlot.index) : ButtonUtil.isExcludedSlot(this.screen, fromSlot.index) || ButtonUtil.isInventoryHotbarSlot(ButtonUtil.isInventoryScreen(this.screen), fromSlot.index))) continue;
            if (fromStack.isEmpty()) continue;
            for (int j = toStart; j < toEnd; ++j) {
                ClickType slotActionType;
                Slot toSlot = this.menu.getSlot(j);
                if (!drop && !toSlot.getItem().isEmpty()) continue;
                ClickType clickType = slotActionType = drop ? ClickType.THROW : ClickType.QUICK_MOVE;
                if (!this.menu.getCarried().isEmpty()) {
                    if (!fromStack.is(this.menu.getCarried().getItem())) continue;
                    ButtonUtil.sendClickSlotPacket(i, slotActionType);
                    continue block0;
                }
                ButtonUtil.sendClickSlotPacket(i, slotActionType);
                continue block0;
            }
        }
    }

    @Unique
    private boolean shouldButtonBeActive(boolean isPlayerInventory, @Nullable Inventory playerInventory, AbstractWidget button) {
        if (button == null) {
            return false;
        }
        int size = isPlayerInventory ? playerInventory.getNonEquipmentItems().size() : this.container.getContainerSize();
        int filledSlots = 0;
        for (int i = 0; i < size; ++i) {
            boolean isStackShulker;
            ItemStack stack = isPlayerInventory ? playerInventory.getItem(i) : this.menu.getSlot(i).getItem();
            boolean isShulkerScreen = this.screen instanceof ShulkerBoxScreen;
            boolean isCursorShulker = isShulkerScreen && this.menu.getCarried().is(ItemTags.SHULKER_BOXES);
            boolean bl = isStackShulker = isShulkerScreen && stack.is(ItemTags.SHULKER_BOXES);
            if (!this.menu.getCarried().isEmpty()) {
                if (!stack.is(this.menu.getCarried().getItem()) || isCursorShulker) continue;
                ++filledSlots;
                continue;
            }
            if (stack.isEmpty() || isStackShulker) continue;
            ++filledSlots;
        }
        return filledSlots != 0 && !this.areAllSlotsUnavailable(isPlayerInventory, (Inventory)(isPlayerInventory ? playerInventory : null));
    }

    @Unique
    private boolean areAllSlotsUnavailable(boolean isPlayerInventory, @Nullable Inventory playerInventory) {
        int foundQuerys = 0;
        ArrayList<Slot> playerSlots = new ArrayList<Slot>();
        if (isPlayerInventory) {
            for (Slot s : ((AbstractContainerMenu)this.menu).slots) {
                if (s.container != playerInventory) continue;
                playerSlots.add(s);
            }
            for (Slot slot : playerSlots) {
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        } else {
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                Slot slot = this.menu.getSlot(i);
                if (!this.search(this.getSearchFieldText(), slot, false)) continue;
                ++foundQuerys;
            }
        }
        return foundQuerys == 0;
    }

    @Unique
    private boolean search(String searchQuery, Slot slot, boolean dropping) {
        String[] terms;
        ItemStack stack = slot.getItem();
        if (stack.isEmpty() || !((Boolean)ModClientOptions.INCLUDE_HOTBAR.get()).booleanValue() && ((Boolean)ModClientOptions.SEARCH_INVENTORY.get()).booleanValue() && ButtonUtil.isHotbarSlot(((AbstractContainerMenu)this.menu).slots.size(), dropping ? slot.index + 1 : slot.index) && (!dropping || !ButtonUtil.isInventoryScreen(this.screen) || slot.index != 45)) {
            return false;
        }
        String itemName = stack.getHoverName().getString().toLowerCase();
        String customName = stack.getCustomName() != null ? stack.getCustomName().getString().toLowerCase() : "";
        for (String term : terms = searchQuery.split(",")) {
            if (!itemName.contains(term.trim().toLowerCase()) && !customName.contains(term.trim().toLowerCase())) continue;
            return true;
        }
        if (searchQuery.startsWith("!")) {
            return !itemName.contains(searchQuery.substring(1)) && !customName.contains(searchQuery.substring(1));
        }
        if (searchQuery.startsWith("#")) {
            String tagSearch = searchQuery.substring(1);
            RegistryAccess lookup = Minecraft.getInstance().level.registryAccess();
            Registry itemRegistry = lookup.lookupOrThrow(Registries.ITEM);
            for (HolderSet.Named tag : itemRegistry.getTags().toList()) {
                ResourceLocation location = tag.key().location();
                if (!location.getPath().toLowerCase().contains(tagSearch) && !location.toString().toLowerCase().contains(tagSearch) || !stack.is(tag.key())) continue;
                return true;
            }
        }
        if (stack.isEnchanted() || stack.is(Items.ENCHANTED_BOOK)) {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            for (Holder enchantment : enchantments.keySet()) {
                String encName = ((Enchantment)enchantment.value()).description().getString();
                String fullName = encName + " " + enchantments.getLevel(enchantment);
                if (!fullName.toLowerCase().contains(searchQuery)) continue;
                return true;
            }
        }
        return itemName.contains(searchQuery) || customName.contains(searchQuery);
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    private void grayOutSlot(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        boolean inventorySearchFieldPresent;
        boolean bl = inventorySearchFieldPresent = this.inventorySearchField != null;
        if (this.containerSearchField != null || inventorySearchFieldPresent) {
            for (int i = 0; i < ButtonUtil.getInventorySize(this.menu, this.container); ++i) {
                Slot slot = this.menu.getSlot(i);
                if (this.getSearchFieldText().isEmpty() || this.search(this.getSearchFieldText(), slot, this.inventorySearchField != null)) continue;
                ButtonUtil.makeSlotUnavailable(graphics, slot, false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"renderContents"}, at={@At(value="TAIL")})
    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        block9: {
            if (this.containerSearchField != null) {
                this.containerSearchField.render(graphics, mouseX, mouseY, deltaTicks);
            }
            if (this.inventorySearchField == null) break block9;
            v0 = this.width / 2 + ButtonUtil.getBarWidth(this.imageWidth) / 2;
            var7_6 = this.screen;
            if (!(var7_6 instanceof AbstractRecipeBookScreen)) ** GOTO lbl-1000
            recipeBookScreen = (AbstractRecipeBookScreen)var7_6;
            if (recipeBookScreen.recipeBookComponent.isVisible()) {
                v1 = -16;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 60;
            }
            this.inventorySearchField.setX(v0 - v1);
            this.inventorySearchField.render(graphics, mouseX, mouseY, deltaTicks);
        }
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.INVENTORY_MANAGEMENT.get()).booleanValue()) {
            playerInventory = this.minecraft.player.getInventory();
            containerScreen = ButtonUtil.isContainerScreen(this.screen);
            inventoryScreen = ButtonUtil.isInventoryScreen(this.screen);
            v2 = validScreen = containerScreen != false || inventoryScreen != false;
            if (containerScreen) {
                this.transferContainerButton = (TransferButton)this.addWidget((GuiEventListener)new TransferButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.imageWidth, this.width), ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "transfer_container", (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$renderWidgets$0(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractContainerScreenMixin)this), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$renderWidgets$1(), ()Ljava/lang/Boolean;)((AbstractContainerScreenMixin)this)));
                this.transferContainerButton.render(graphics, mouseX, mouseY, deltaTicks);
                this.transferInventoryButton = (TransferButton)this.addWidget((GuiEventListener)new TransferButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.transferContainerButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "transfer_inventory", (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$renderWidgets$2(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractContainerScreenMixin)this), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$renderWidgets$3(net.minecraft.world.entity.player.Inventory ), ()Ljava/lang/Boolean;)((AbstractContainerScreenMixin)this, (Inventory)playerInventory)));
                this.transferInventoryButton.render(graphics, mouseX, mouseY, deltaTicks);
            }
            if (validScreen) {
                if (((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() || ((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.includeHotbarButton = (TransferButton)this.addWidget((GuiEventListener)new IncludeHotbarButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getManagementButtonX(this.screen, this.imageWidth, this.width) - 24, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "include_hotbar", (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$renderWidgets$4(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()));
                    this.includeHotbarButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.SWAPPING.get()).booleanValue() && containerScreen) {
                    this.swapButton = (TransferButton)this.addWidget((GuiEventListener)new SwapButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - 12, ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "swap", (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$renderWidgets$5(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractContainerScreenMixin)this), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$renderWidgets$6(net.minecraft.world.entity.player.Inventory ), ()Ljava/lang/Boolean;)((AbstractContainerScreenMixin)this, (Inventory)playerInventory)));
                    this.swapButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
                if (((Boolean)ModClientOptions.QUICK_DROP.get()).booleanValue()) {
                    this.quickDropButton = (TransferButton)this.addWidget((GuiEventListener)new QuickDropButton((AbstractContainerMenu)this.menu, this.font, this.getSearchFieldText(), ButtonUtil.getButtonX(this.includeHotbarButton) - (containerScreen != false && (Boolean)ModClientOptions.SWAPPING.get() != false ? 24 : 12), ButtonUtil.getManagementButtonY(this.screen, this.container, this.topPos, this.titleLabelY), "quick_drop", (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$renderWidgets$7(boolean net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractContainerScreenMixin)this, (boolean)containerScreen), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$renderWidgets$8(boolean net.minecraft.world.entity.player.Inventory ), ()Ljava/lang/Boolean;)((AbstractContainerScreenMixin)this, (boolean)containerScreen, (Inventory)playerInventory)));
                    this.quickDropButton.render(graphics, mouseX, mouseY, deltaTicks);
                }
            }
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addAllItemTagsToTooltip(GuiGraphics graphics, int x, int y, CallbackInfo ci) {
        String searchQuery = this.getSearchFieldText();
        if (this.containerSearchField != null) {
            if (!searchQuery.startsWith("#")) {
                return;
            }
            Slot hoveredSlot = this.getSlotUnderMouse();
            if (hoveredSlot == null || !hoveredSlot.hasItem()) {
                return;
            }
            ItemStack stack = hoveredSlot.getItem();
            Registry itemRegistry = this.minecraft.level.registryAccess().lookupOrThrow(Registries.ITEM);
            List originalTooltip = stack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)this.minecraft.player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            boolean foundTags = false;
            for (HolderSet.Named tag : itemRegistry.getTags().toList()) {
                if (!stack.is(tag.key())) continue;
                String tagString = "#" + String.valueOf(tag.key().location());
                originalTooltip.add(1, Component.literal((String)tagString).withStyle(ChatFormatting.LIGHT_PURPLE));
                foundTags = true;
            }
            if (foundTags) {
                graphics.setTooltipForNextFrame(this.font, originalTooltip, Optional.empty(), x, y);
                ci.cancel();
            }
        }
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void closeButtonOnClickOutOfBounds(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_GUI_EXIT.get()).booleanValue() && this.menu.getCarried().isEmpty() && button == 0 && slot == null) {
            this.onClose();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseClicking(MouseButtonEvent event, boolean isDouble, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.minecraft)) {
            if (event.button() == 1 && this.hoveredSlot != null && ButtonUtil.isQuicklyEquippable(this.hoveredSlot.getItem())) {
                ButtonUtil.quickEquip(this.screen, this.hoveredSlot);
                cir.setReturnValue((Object)true);
            }
            if (this.inventorySearchField != null && this.inventorySearchField.mouseClicked(event, isDouble)) {
                this.inventorySearchField.setFocused(true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleKeyPressing(KeyEvent input, CallbackInfoReturnable<Boolean> cir) {
        block37: {
            block38: {
                if (!QoQ.modEnabled(this.minecraft)) break block37;
                if (Minecraft.getInstance().hasControlDown() && ((Boolean)ModClientOptions.SHORTCUT_KEYS.get()).booleanValue()) {
                    if (this.transferContainerButton != null && this.transferContainerButton.active && input.key() == ModKeybinds.MOVE_CONTAINER.getKey().getValue()) {
                        this.transferItems(true);
                    }
                    if (this.transferInventoryButton != null && this.transferInventoryButton.active && input.key() == ModKeybinds.MOVE_INVENTORY.getKey().getValue()) {
                        this.transferItems(false);
                    }
                    if (this.swapCooldown == 0 && this.swapButton != null && this.swapButton.active && input.key() == ModKeybinds.SWAP_ITEMS.getKey().getValue()) {
                        ButtonUtil.swapItems(this.menu, this.container);
                        this.swapCooldown = 120;
                    }
                    if (this.quickDropButton != null && this.quickDropButton.active && Minecraft.getInstance().hasAltDown() && input.key() == 81) {
                        this.dropItems(ButtonUtil.isContainerScreen(this.screen) == false);
                    }
                }
                if (input.key() == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
                    ButtonUtil.quickEquip(this.screen, this.hoveredSlot);
                }
                if (input.key() == 69 && ((Boolean)ModClientOptions.PREVENT_E_FROM_TYPING.get()).booleanValue() && (ButtonUtil.isInventoryScreen(this.screen) || ButtonUtil.isCreativeInventoryScreen(this.screen))) {
                    this.onClose();
                    cir.setReturnValue((Object)true);
                }
                ignoreTyping = ButtonUtil.hoveredSlotHasItem(this.hoveredSlot);
                secondaryIgnoreTyping = false;
                numberKeyPressed = false;
                hotbarKeyPressed = false;
                dropKeyPressed = false;
                swapKeyPressed = false;
                for (int key : QoQ.allDisallowedKeys) {
                    if (input.key() != key) continue;
                    ignoreTyping = true;
                    secondaryIgnoreTyping = true;
                    break;
                }
                if (this.menu.getCarried().isEmpty() && this.hoveredSlot != null) {
                    for (i = 0; i < 9; ++i) {
                        if (!this.minecraft.options.keyHotbarSlots[i].matches(input)) continue;
                        ignoreTyping = true;
                        secondaryIgnoreTyping = true;
                        hotbarKeyPressed = true;
                        break;
                    }
                    if (this.screen instanceof InventoryScreen && input.key() == ModKeybinds.QUICK_EQUIP.getKey().getValue()) {
                        ignoreTyping = true;
                    }
                }
                for (int key : QoQ.popularKeys) {
                    if (input.key() != key) continue;
                    secondaryIgnoreTyping = false;
                    cir.setReturnValue((Object)true);
                    break;
                }
                numbers = List.of(Integer.valueOf(49), Integer.valueOf(50), Integer.valueOf(51), Integer.valueOf(52), Integer.valueOf(53), Integer.valueOf(54), Integer.valueOf(55), Integer.valueOf(56), Integer.valueOf(57));
                for (int key : numbers) {
                    if (input.key() != key) continue;
                    numberKeyPressed = true;
                    break;
                }
                if (input.key() == Minecraft.getInstance().options.keyDrop.getKey().getValue()) {
                    secondaryIgnoreTyping = true;
                    dropKeyPressed = true;
                } else if (input.key() == Minecraft.getInstance().options.keySwapOffhand.getKey().getValue()) {
                    secondaryIgnoreTyping = true;
                    swapKeyPressed = true;
                }
                v0 = cannotType = (numberKeyPressed != false || hotbarKeyPressed != false || dropKeyPressed != false || swapKeyPressed != false) && ButtonUtil.hoveredSlotHasItem(this.hoveredSlot) != false;
                if (((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue() && (var12_18 = this.screen) instanceof AbstractRecipeBookScreen) {
                    recipeScreen = (AbstractRecipeBookScreen)var12_18;
                    if (!Minecraft.getInstance().hasControlDown()) {
                        v1 = swapKeyValid = swapKeyPressed != false && (ButtonUtil.hoveredSlotHasItem(this.hoveredSlot) != false || this.menu.getSlot(45).hasItem() != false);
                        if (!(ignoreTyping || swapKeyValid || recipeScreen.recipeBookComponent.isVisible() || this.inventorySearchField != null && this.inventorySearchField.isFocused())) {
                            recipeScreen.recipeBookComponent.toggleVisibility();
                            this.repositionElements();
                        }
                        if (recipeScreen.recipeBookComponent.searchBox != null) {
                            recipeScreen.recipeBookComponent.searchBox.setFocused(cannotType == false);
                            if (recipeScreen.recipeBookComponent.searchBox.isFocused()) {
                                cir.setReturnValue((Object)(recipeScreen.recipeBookComponent.keyPressed(input) != false || super.keyPressed(input) != false));
                            }
                        }
                    }
                }
                if (!((Boolean)ModClientOptions.INVENTORY_SEARCHING.get()).booleanValue() || this.inventorySearchField == null) break block38;
                if (Minecraft.getInstance().hasControlDown() || !((var12_18 = this.screen) instanceof AbstractRecipeBookScreen)) ** GOTO lbl-1000
                recipeScreen = (AbstractRecipeBookScreen)var12_18;
                if (recipeScreen.recipeBookComponent.isVisible() && !this.inventorySearchField.isFocused()) {
                    recipeScreen.recipeBookComponent.searchBox.setFocused(cannotType == false);
                } else if (!secondaryIgnoreTyping && (!Minecraft.getInstance().hasControlDown() || Minecraft.getInstance().hasControlDown() && input.key() == 65)) {
                    this.inventorySearchField.setFocused(true);
                    this.setFocused((GuiEventListener)this.inventorySearchField);
                } else if (this.inventorySearchField.isFocused() && cannotType) {
                    this.inventorySearchField.setFocused(false);
                }
                var12_18 = this.screen;
                if (var12_18 instanceof AbstractRecipeBookScreen) {
                    recipeScreen = (AbstractRecipeBookScreen)var12_18;
                    if (recipeScreen.recipeBookComponent.searchBox != null) {
                        if (this.inventorySearchField.isFocused()) {
                            recipeScreen.recipeBookComponent.searchBox.setFocused(false);
                        } else if (recipeScreen.recipeBookComponent.searchBox.isFocused() && this.inventorySearchField != null) {
                            this.inventorySearchField.setFocused(false);
                        }
                    }
                }
                if (this.inventorySearchField.isFocused() && this.inventorySearchField.keyPressed(input)) {
                    cir.setReturnValue((Object)true);
                }
            }
            if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && ButtonUtil.isContainerScreen(this.screen)) {
                if (!secondaryIgnoreTyping && (!Minecraft.getInstance().hasControlDown() || Minecraft.getInstance().hasControlDown() && input.key() == 65)) {
                    this.containerSearchField.setFocused(true);
                } else if (this.containerSearchField.isFocused() && cannotType) {
                    this.containerSearchField.setFocused(false);
                }
                if (this.containerSearchField.isFocused() && this.containerSearchField.keyPressed(input)) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    public boolean charTyped(CharacterEvent input) {
        if (((Boolean)ModClientOptions.CHEST_SEARCHING.get()).booleanValue() && this.containerSearchField != null && this.containerSearchField.isFocused()) {
            return this.containerSearchField.charTyped(input);
        }
        return super.charTyped(input);
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void saveSearchText(CallbackInfo ci) {
        if (((Boolean)ModClientOptions.SAVE_SEARCH_TEXT.get()).booleanValue()) {
            if (ButtonUtil.isInventoryScreen(this.screen) && this.inventorySearchField != null) {
                QoQ.SAVED_TEXT = this.inventorySearchField.getValue();
            } else if (ButtonUtil.isContainerScreen(this.screen) && this.containerSearchField != null) {
                QoQ.SAVED_TEXT = this.containerSearchField.getValue();
            }
        }
    }

    public void resize(Minecraft client, int width, int height) {
        if (this.containerSearchField != null) {
            String text = this.getSearchFieldText();
            boolean refocus = this.containerSearchField.isFocused();
            this.init(client, width, height);
            this.containerSearchField.setValue(text);
            this.containerSearchField.setFocused(refocus);
        }
    }

    private /* synthetic */ Boolean lambda$renderWidgets$8(boolean containerScreen, Inventory playerInventory) {
        return (ButtonUtil.isInventoryScreen(this.screen) ? ButtonUtil.isAnySlotFilled(this.menu, true, 9, 36) : ButtonUtil.isAnySlotFilled(this.menu, false, 0, ButtonUtil.getContainerSize(this.container))) && this.menu.getCarried().isEmpty() && this.shouldButtonBeActive(!containerScreen, containerScreen ? null : playerInventory, (AbstractWidget)this.quickDropButton);
    }

    private /* synthetic */ void lambda$renderWidgets$7(boolean containerScreen, Button b) {
        this.dropItems(!containerScreen);
    }

    private /* synthetic */ Boolean lambda$renderWidgets$6(Inventory playerInventory) {
        if (this.swapCooldown > 0) {
            --this.swapCooldown;
        }
        return (ButtonUtil.getContainerSize(this.container) != 27 || ButtonUtil.isAnySlotFilled(this.menu, false, 27, 54)) && this.menu.getCarried().isEmpty() && this.getSearchFieldText().isEmpty() && this.shouldButtonBeActive(false, null, (AbstractWidget)this.swapButton) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.swapButton);
    }

    private /* synthetic */ void lambda$renderWidgets$5(Button b) {
        ButtonUtil.swapItems(this.menu, this.container);
    }

    private static /* synthetic */ void lambda$renderWidgets$4(Button b) {
        ModClientOptions.INCLUDE_HOTBAR.set((Object)((Boolean)ModClientOptions.INCLUDE_HOTBAR.get() == false ? 1 : 0));
        QoQ.saveAll();
    }

    private /* synthetic */ Boolean lambda$renderWidgets$3(Inventory playerInventory) {
        return !ButtonUtil.isContainerFull(this.menu, this.container, false) && this.shouldButtonBeActive(true, playerInventory, (AbstractWidget)this.transferInventoryButton);
    }

    private /* synthetic */ void lambda$renderWidgets$2(Button b) {
        this.transferItems(false);
    }

    private /* synthetic */ Boolean lambda$renderWidgets$1() {
        return !ButtonUtil.isContainerFull(this.menu, this.container, true) && this.shouldButtonBeActive(false, null, (AbstractWidget)this.transferContainerButton);
    }

    private /* synthetic */ void lambda$renderWidgets$0(Button b) {
        this.transferItems(true);
    }
}

