/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.client;

import java.util.Objects;
import net.dillon.qualityofqueso.main.QoQ;
import net.dillon.qualityofqueso.option.ModClientOptions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeModeInventoryScreenMixin
extends AbstractContainerScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    private EditBox searchBox;
    @Shadow
    private static CreativeModeTab selectedTab;
    @Shadow
    private boolean ignoreTextInput;

    @Shadow
    protected abstract void refreshSearchResults();

    @Shadow
    protected abstract void selectTab(CreativeModeTab var1);

    public CreativeModeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void closeButtonOnClickOutOfBounds(Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_GUI_EXIT.get()).booleanValue() && ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).getCarried().isEmpty() && mouseButton == 0 && slot == null) {
            this.onClose();
        }
    }

    @Overwrite
    public boolean charTyped(CharacterEvent input) {
        if (this.ignoreTextInput || !((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue() && selectedTab.getType() != CreativeModeTab.Type.SEARCH) {
            return false;
        }
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue()) {
            this.selectTab(CreativeModeTabs.searchTab());
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.charTyped(input)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowCertainChars(KeyEvent input, CallbackInfoReturnable<Boolean> cir) {
        if (QoQ.modEnabled(this.minecraft) && ((Boolean)ModClientOptions.BETTER_SEARCHING.get()).booleanValue()) {
            if (this.hoveredSlot != null && this.hoveredSlot.getItem() != ItemStack.EMPTY && !this.searchBox.isFocused()) {
                this.ignoreTextInput = true;
                cir.setReturnValue((Object)super.keyPressed(input));
            }
            for (int key : QoQ.popularKeys) {
                if (input.key() != key) continue;
                this.ignoreTextInput = false;
                cir.setReturnValue((Object)true);
            }
            for (int key : QoQ.disallowedKeys) {
                if (input.key() != key) continue;
                this.ignoreTextInput = true;
                cir.setReturnValue((Object)super.keyPressed(input));
            }
        }
    }
}

