/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.mixin.main;

import net.dillon.qualityofqueso.util.GlowCountdown;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFrame.class})
public abstract class ItemFrameMixin
extends HangingEntity
implements GlowCountdown {
    @Unique
    private int glowTicksRemaining = -1;

    public ItemFrameMixin(EntityType<? extends HangingEntity> p_31703_, Level p_31704_) {
        super(p_31703_, p_31704_);
    }

    public void tick() {
        if (this.glowTicksRemaining > 0) {
            --this.glowTicksRemaining;
            if (this.glowTicksRemaining == 0) {
                ((ItemFrame)this).setGlowingTag(false);
            }
        }
        super.tick();
    }

    @Override
    public void startGlowCountdown(int ticks) {
        this.glowTicksRemaining = ticks;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeGlowTicks(ValueOutput output, CallbackInfo ci) {
        output.putInt("GlowTicksRemaining", this.glowTicksRemaining);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readGlowTicks(ValueInput input, CallbackInfo ci) {
        this.glowTicksRemaining = input.getIntOr("GlowTicksRemaining", -1);
    }
}

