/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.qualityofqueso.packet;

import java.util.List;
import net.dillon.qualityofqueso.option.ModCommonOptions;
import net.dillon.qualityofqueso.util.GlowCountdown;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record GlowSearchC2SPayload(String query, boolean matchCase, boolean clear, int timer, int radius) {
    public GlowSearchC2SPayload(FriendlyByteBuf buf) {
        this(buf.readUtf(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.query);
        buf.writeBoolean(this.matchCase);
        buf.writeBoolean(this.clear);
        buf.writeInt(this.timer);
        buf.writeInt(this.radius);
    }

    public void handle(CustomPayloadEvent.Context context) {
        if (((Boolean)ModCommonOptions.ITEM_FRAME_SEARCHING.get()).booleanValue()) {
            ServerPlayer player = context.getSender();
            ServerLevel world = player.level();
            Vec3 playerPos = player.position();
            List nearbyFrames = world.getEntitiesOfClass(ItemFrame.class, new AABB(playerPos.add((double)(-this.radius), (double)(-this.radius), (double)(-this.radius)), playerPos.add((double)this.radius, (double)this.radius, (double)this.radius)), frame -> {
                String[] terms = this.query.split(",");
                if (this.clear) {
                    return true;
                }
                ItemStack stack = frame.getItem();
                if (stack.isEmpty()) {
                    return false;
                }
                String itemName = stack.getItem().getName().getString().toLowerCase();
                String itemId = ForgeRegistries.ITEMS.getResourceKey((Object)stack.getItem()).toString().toLowerCase();
                for (String term : terms) {
                    String trimmed = term.trim().toLowerCase();
                    if (!(this.matchCase ? itemName.matches(trimmed) || itemId.matches(trimmed) : itemName.contains(trimmed) || itemId.matches(trimmed))) continue;
                    return true;
                }
                if (this.query.startsWith("#")) {
                    String tagSearch = this.query.substring(1);
                    Registry itemRegistry = world.registryAccess().lookupOrThrow(Registries.ITEM);
                    for (HolderSet.Named tag : itemRegistry.getTags().toList()) {
                        ResourceLocation id = tag.key().location();
                        if (!(this.matchCase ? id.getPath().toLowerCase().matches(tagSearch) || id.toString().toLowerCase().matches(tagSearch) : id.getPath().toLowerCase().contains(tagSearch) || id.toString().toLowerCase().contains(tagSearch)) || !stack.is(tag.key())) continue;
                        return true;
                    }
                }
                return false;
            });
            int searched = 0;
            for (ItemFrame frame2 : nearbyFrames) {
                boolean alreadyGlowing = frame2.isCurrentlyGlowing();
                frame2.setGlowingTag(!this.clear);
                ++searched;
                if (this.clear && !alreadyGlowing) {
                    --searched;
                }
                if (this.clear || this.timer == 0) continue;
                ((GlowCountdown)frame2).startGlowCountdown(this.timer * 20);
            }
            if (nearbyFrames.isEmpty()) {
                player.sendSystemMessage((Component)(this.matchCase ? Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.found_none.match_case", (Object[])new Object[]{searched, this.query}) : Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.found_none", (Object[])new Object[]{searched, this.query})), false);
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.get(), SoundSource.AMBIENT, 2.0f, 1.0f);
            } else if (this.clear) {
                player.sendSystemMessage((Component)Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.cleared", (Object[])new Object[]{searched}), false);
                player.playNotifySound(SoundEvents.PLAYER_SPLASH, SoundSource.AMBIENT, 1.0f, 1.0f);
            } else {
                if (this.timer == 0) {
                    player.sendSystemMessage((Component)(this.matchCase ? Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.without_timer.match_case", (Object[])new Object[]{searched, this.query}) : Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.without_timer", (Object[])new Object[]{searched, this.query})));
                } else {
                    player.sendSystemMessage((Component)(this.matchCase ? Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.with_timer.match_case", (Object[])new Object[]{searched, this.query, this.timer}) : Component.translatable((String)"qualityofqueso.item_frame_searcher.executed.with_timer", (Object[])new Object[]{searched, this.query, this.timer})), false);
                }
                player.playNotifySound(SoundEvents.ARROW_HIT_PLAYER, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }
}

