/*
 * Decompiled with CFR 0.152.
 */
package bullfighter.droppablevillagertrades.mixin;

import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
public class VillagerDeathMixin {
    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void dropVillagerTrade(DamageSource pCause, CallbackInfo info) {
        MerchantOffers offers;
        AbstractVillager villager = (AbstractVillager)this;
        if (!villager.level().isClientSide() && !(offers = villager.getOffers()).isEmpty()) {
            int times = RandomSource.create().nextInt(3) + 1;
            for (int i = 0; i < times; ++i) {
                int randomIndex = RandomSource.create().nextInt(offers.size());
                MerchantOffer offer = (MerchantOffer)offers.get(randomIndex);
                ItemStack droppedItem = offer.getResult().copy();
                int count = RandomSource.create().nextInt(droppedItem.getCount() * offer.getMaxUses()) + 1;
                if (count > droppedItem.getMaxStackSize() * 3) {
                    count = RandomSource.create().nextInt(droppedItem.getMaxStackSize() * 5) + 1;
                }
                droppedItem.setCount(count);
                villager.level().addFreshEntity((Entity)new ItemEntity(villager.level(), villager.getX(), villager.getY(), villager.getZ(), droppedItem));
            }
        }
    }
}

