/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import me.andy.shopshelves.api.ShopshelvesApi;
import me.andy.shopshelves.command.ShopshelvesCommand;
import me.andy.shopshelves.config.MessageFormattingManager;
import me.andy.shopshelves.config.ShopPricing;
import me.andy.shopshelves.config.ShopshelvesConfig;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.AdminModeManager;
import me.andy.shopshelves.util.MessageUtil;
import me.andy.shopshelves.util.ShopDataManager;
import me.andy.shopshelves.util.ShopLinkUtil;
import me.andy.shopshelves.util.ShopPermissionUtil;
import me.andy.shopshelves.util.ShopShelf;
import me.andy.shopshelves.util.TextDisplayManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_11585;
import net.minecraft.class_11586;
import net.minecraft.class_11597;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shopshelves
implements ModInitializer {
    public static final String MOD_ID = "shopshelves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shopshelves");
    public static final String TEXT_DISPLAY_TAG = "shopshelf_display";
    public static final Optional<class_2248> SHELF_BLOCK = Optional.of((class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)"oak_shelf")));
    public static final Optional<class_1792> SHELF_ITEM = Optional.of(class_1802.field_61327);
    public static final String PERMISSION_COMMAND_BASE = "shopshelves.command";
    public static final String PERMISSION_ADMIN = "shopshelves.admin";
    public static final String PERMISSION_MODE = "shopshelves.mode";
    public static final String PERMISSION_RELOAD = "shopshelves.reload";
    public static final String PERMISSION_UPDATE = "shopshelves.update";
    public static final String PERMISSION_ITEMPRICE = "shopshelves.itemprice";
    public static final String PERMISSION_PRICE_STAMP = "shopshelves.price";
    public static final String PERMISSION_PLAYERSHELF_CREATE = "shopshelves.playershelf";
    public static final String PERMISSION_PLAYERSHELF_LIMIT = "shopshelves.playershelves.";
    private static ShopshelvesApi API_INSTANCE;

    public static ShopshelvesApi api() {
        if (API_INSTANCE == null) {
            API_INSTANCE = ShopshelvesApi.getInstance();
        }
        return API_INSTANCE;
    }

    public void onInitialize() {
        LOGGER.info("{} loaded!", (Object)MOD_ID);
        ShopshelvesConfig.load();
        MessageFormattingManager.initialize();
        ShopPricing.load();
        ShopshelvesCommand.init();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ShopDataManager.get().load(server);
            Shopshelves.updateAllShops(server);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            ShopDataManager.get().save(server);
            ShopDataManager.get().clear();
            AdminModeManager.clearAdmins();
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_11597 shelf;
            class_2586 be;
            class_3218 serverWorld;
            block17: {
                block16: {
                    if (world.method_8608() || player.method_7325()) {
                        return class_1269.field_5811;
                    }
                    serverWorld = (class_3218)world;
                    class_2680 clickedState = world.method_8320(pos);
                    List<class_2338> positionsToCheck = clickedState.method_26204() instanceof class_2281 ? ShopLinkUtil.getContainerPositions(world, pos) : List.of(pos);
                    Optional<Object> shelfPosOpt = Optional.empty();
                    for (class_2338 checkPos : positionsToCheck) {
                        shelfPosOpt = ShopDataManager.get().getShelfForContainer(serverWorld, checkPos);
                        if (!shelfPosOpt.isPresent()) continue;
                        break;
                    }
                    if (shelfPosOpt.isPresent()) {
                        class_2586 shelfBe = world.method_8321((class_2338)shelfPosOpt.get());
                        if (shelfBe instanceof ShopShelf) {
                            ShopShelf shopShelf = (ShopShelf)shelfBe;
                            boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
                            boolean isAdmin = AdminModeManager.isAdmin(player);
                            if (!isOwner && !isAdmin) {
                                MessageUtil.sendError(((class_3222)player).method_64396(), "error_container_protected");
                                return class_1269.field_5814;
                            }
                        } else {
                            ShopDataManager.get().removeLink(serverWorld, positionsToCheck);
                        }
                    }
                    if (!((be = world.method_8321(pos)) instanceof class_11597)) break block16;
                    shelf = (class_11597)be;
                    if (be instanceof ShopShelf) break block17;
                }
                return class_1269.field_5811;
            }
            ShopShelf shopShelf = (ShopShelf)be;
            ShopHelper.ShopMode mode = shopShelf.getShopMode();
            if (mode == ShopHelper.ShopMode.NONE) {
                return class_1269.field_5811;
            }
            boolean isAdmin = AdminModeManager.isAdmin(player);
            boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_11586 && state.method_11654((class_2769)class_11586.field_61425) == direction) {
                boolean isSellingToOwnPlayerShop;
                boolean canSell = mode == ShopHelper.ShopMode.SELL || mode == ShopHelper.ShopMode.DUAL || mode == ShopHelper.ShopMode.PLAYERSHELF;
                boolean bl = isSellingToOwnPlayerShop = mode == ShopHelper.ShopMode.PLAYERSHELF && isOwner;
                if (canSell && !isAdmin && !isSellingToOwnPlayerShop) {
                    if (player instanceof class_3222) {
                        class_2248 patt0$temp;
                        class_3965 blockHit;
                        class_3222 serverPlayer = (class_3222)player;
                        class_239 hit = player.method_5745(player.method_55754(), 0.0f, false);
                        if (hit.method_17783() == class_239.class_240.field_1332 && (blockHit = (class_3965)hit).method_17777().equals((Object)pos) && (patt0$temp = state.method_26204()) instanceof class_11585) {
                            class_11585 container = (class_11585)patt0$temp;
                            container.method_72611(blockHit, direction).ifPresent(slot -> {
                                if (mode == ShopHelper.ShopMode.PLAYERSHELF) {
                                    ShopHelper.handlePlayerShelfSell(serverWorld, serverPlayer, shelf, slot);
                                } else {
                                    ShopHelper.handleSellInteraction(serverWorld, serverPlayer, shelf, slot, player.method_5715());
                                }
                            });
                        }
                    }
                    return class_1269.field_5814;
                }
            }
            if (mode == ShopHelper.ShopMode.PLAYERSHELF ? !isOwner && !isAdmin : !isAdmin) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2248 clickedBlock;
            class_2586 shelfBe;
            class_2680 clickedState;
            class_1750 context;
            if (world.method_8608() || player.method_7325() || hand == class_1268.field_5810) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            class_3222 serverPlayer = (class_3222)player;
            class_3218 serverWorld = (class_3218)world;
            class_1799 heldStack = player.method_5998(hand);
            class_2248 heldBlock = class_2248.method_9503((class_1792)heldStack.method_7909());
            if (heldBlock instanceof class_2281 && (context = new class_1750(player, hand, heldStack, hitResult)).method_7716()) {
                class_2338 placePos = context.method_8037();
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    ShopShelf shopShelf;
                    boolean isOwner;
                    class_2586 be;
                    Optional<class_2338> neighborShelfPos;
                    class_2338 neighborPos = placePos.method_10093(dir);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (!(neighborState.method_26204() instanceof class_2281) || !(neighborShelfPos = ShopDataManager.get().getShelfForContainer(serverWorld, neighborPos)).isPresent() || !((be = world.method_8321(neighborShelfPos.get())) instanceof ShopShelf) || (isOwner = (shopShelf = (ShopShelf)be).getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false).booleanValue())) continue;
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_container_protected");
                    return class_1269.field_5814;
                }
            }
            List<class_2338> positionsToCheck = (clickedState = world.method_8320(pos)).method_26204() instanceof class_2281 ? ShopLinkUtil.getContainerPositions(world, pos) : List.of(pos);
            Optional<Object> shelfPosOpt = Optional.empty();
            for (class_2338 checkPos : positionsToCheck) {
                shelfPosOpt = ShopDataManager.get().getShelfForContainer(serverWorld, checkPos);
                if (!shelfPosOpt.isPresent()) continue;
                break;
            }
            if (shelfPosOpt.isPresent() && !(heldBlock instanceof class_11586) && (shelfBe = world.method_8321((class_2338)shelfPosOpt.get())) instanceof ShopShelf) {
                ShopShelf shopShelf = (ShopShelf)shelfBe;
                boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
                boolean isAdmin = AdminModeManager.isAdmin(player);
                if (!isOwner && !isAdmin) {
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_container_protected");
                    return class_1269.field_5814;
                }
            }
            if (player.method_5715() && heldBlock instanceof class_11586 && ((clickedBlock = world.method_8320(pos).method_26204()) instanceof class_2281 || clickedBlock instanceof class_3708)) {
                int currentShopCount;
                List<class_2338> containerPositions = ShopLinkUtil.getContainerPositions(world, pos);
                for (class_2338 containerPos : containerPositions) {
                    if (!ShopDataManager.get().isContainerLinked(serverWorld, containerPos)) continue;
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_container_already_linked");
                    return class_1269.field_5814;
                }
                int limit = ShopPermissionUtil.getPlayerShelfLimit(serverPlayer);
                if (limit <= 0 && !Shopshelves.checkPermission(serverPlayer.method_64396(), PERMISSION_PLAYERSHELF_CREATE, 0)) {
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_no_permission_create_playershop");
                    return class_1269.field_5814;
                }
                if (limit <= 0 && (limit = ShopshelvesConfig.get().getDefaultPlayerShelfLimit()) <= 0) {
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_no_permission_create_playershop");
                    return class_1269.field_5814;
                }
                if (limit != Integer.MAX_VALUE && (currentShopCount = ShopDataManager.get().countPlayerShelves(serverPlayer.method_5667(), world.method_8503())) >= limit) {
                    MessageUtil.sendError(serverPlayer.method_64396(), "error_playershop_limit_reached", Map.of("%limit%", String.valueOf(limit)));
                    return class_1269.field_5814;
                }
                class_1750 context2 = new class_1750(player, hand, heldStack, hitResult);
                class_2338 placePos = context2.method_8037();
                class_2680 shelfState = heldBlock.method_9605(context2);
                if (shelfState != null && world.method_8320(placePos).method_45474()) {
                    world.method_8652(placePos, shelfState, 3);
                    class_2586 newBe = world.method_8321(placePos);
                    if (newBe instanceof class_11597) {
                        class_11597 shopShelfEntity = (class_11597)newBe;
                        if (newBe instanceof ShopShelf) {
                            ShopShelf shopShelf = (ShopShelf)newBe;
                            shopShelf.setShopMode(ShopHelper.ShopMode.PLAYERSHELF);
                            shopShelf.setOwner(player.method_5667());
                            shopShelf.setLinkedContainerPos(pos);
                            if (!player.method_68878()) {
                                heldStack.method_7934(1);
                            }
                            ShopDataManager.get().addLink(serverWorld, containerPositions, placePos);
                            world.method_8396(null, placePos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
                            shopShelfEntity.method_5431();
                            return class_1269.field_5812;
                        }
                    }
                }
                return class_1269.field_5814;
            }
            class_2586 be = world.method_8321(pos);
            if (be instanceof class_11597) {
                class_11597 blockEntity = (class_11597)be;
                if (be instanceof ShopShelf) {
                    class_2680 state;
                    ShopShelf shopShelf = (ShopShelf)be;
                    boolean isOwner = shopShelf.getOwner().map(uuid -> uuid.equals(player.method_5667())).orElse(false);
                    if (!AdminModeManager.isAdmin(player) && shopShelf.getOwner().isPresent() && (shopShelf.getShopMode() != ShopHelper.ShopMode.PLAYERSHELF || !isOwner) && (state = world.method_8320(pos)).method_26204() instanceof class_11586 && state.method_11654((class_2769)class_11586.field_61425) == hitResult.method_17780()) {
                        class_11585 container;
                        OptionalInt slotOpt;
                        class_2248 patt0$temp;
                        ShopHelper.ShopMode mode = shopShelf.getShopMode();
                        if ((mode == ShopHelper.ShopMode.BUY || mode == ShopHelper.ShopMode.DUAL || mode == ShopHelper.ShopMode.PLAYERSHELF) && (patt0$temp = state.method_26204()) instanceof class_11585 && (slotOpt = (container = (class_11585)patt0$temp).method_72611(hitResult, (class_2350)state.method_11654((class_2769)class_11586.field_61425))).isPresent()) {
                            if (mode == ShopHelper.ShopMode.PLAYERSHELF) {
                                ShopHelper.handlePlayerShelfBuy(serverWorld, serverPlayer, blockEntity, slotOpt.getAsInt());
                            } else {
                                ShopHelper.handleBuyInteraction(serverWorld, serverPlayer, blockEntity, slotOpt.getAsInt(), player.method_5715());
                            }
                        }
                        return class_1269.field_5814;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public static boolean hasPriceStamp(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData != null) {
            return customData.method_57461().method_10562("shopshelves:price_stamp").isPresent();
        }
        return false;
    }

    public static void removePriceStamp(class_1799 stack) {
        if (!Shopshelves.hasPriceStamp(stack)) {
            return;
        }
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData != null) {
            class_2487 mutableNbt = customData.method_57461();
            mutableNbt.method_10551("shopshelves:price_stamp");
            if (mutableNbt.method_33133()) {
                stack.method_57381(class_9334.field_49628);
            } else {
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)mutableNbt));
            }
        }
    }

    public static void updateAllShops(MinecraftServer server) {
        LOGGER.info("Starting full ShopShelves display update...");
        for (class_3218 world : server.method_3738()) {
            world.method_18198((class_5575)class_1299.field_42457, entity -> entity.method_5752().contains(TEXT_DISPLAY_TAG)).forEach(entity -> entity.method_31472());
        }
        Map<String, Map<class_2338, List<UUID>>> allShops = ShopDataManager.get().getAllShops();
        for (class_3218 world : server.method_3738()) {
            String worldId = world.method_27983().method_29177().toString();
            Map<class_2338, List<UUID>> worldShops = allShops.get(worldId);
            if (worldShops == null) continue;
            for (class_2338 pos : new ArrayList<class_2338>(worldShops.keySet())) {
                ShopShelf shopShelf;
                class_2586 be;
                if (!world.method_22340(pos) || !((be = world.method_8321(pos)) instanceof class_11597)) continue;
                class_11597 shelf = (class_11597)be;
                if (!(be instanceof ShopShelf) || (shopShelf = (ShopShelf)be).getShopMode() == ShopHelper.ShopMode.NONE) continue;
                TextDisplayManager.updateShopDisplay(world, pos, shelf);
            }
        }
        LOGGER.info("Full ShopShelves display update complete.");
    }

    public static boolean checkPermission(class_2168 source, String permissionNode, int defaultOpLevel) {
        return ShopPermissionUtil.checkPermission(source, permissionNode, defaultOpLevel);
    }
}

