/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.config.MessageFormattingData;
import net.fabricmc.loader.api.FabricLoader;

public class MessageFormattingManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FILE_NAME = "message_formatting.json";
    private static File configFile;
    private static MessageFormattingData messages;

    public static void initialize() {
        Path modConfigDir = FabricLoader.getInstance().getConfigDir().resolve("shopshelves");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to create config directory for ShopShelves.", (Throwable)e);
        }
        configFile = modConfigDir.resolve(FILE_NAME).toFile();
        MessageFormattingManager.load();
    }

    public static MessageFormattingData getMessages() {
        if (messages == null) {
            MessageFormattingManager.load();
        }
        return messages;
    }

    public static void load() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                messages = (MessageFormattingData)GSON.fromJson((Reader)reader, MessageFormattingData.class);
                if (messages == null) {
                    messages = MessageFormattingData.createDefault();
                    Shopshelves.LOGGER.warn("Message formatting file was empty or corrupted. Loaded defaults.");
                }
            }
            catch (Exception e) {
                Shopshelves.LOGGER.error("Failed to load message formatting file. Using default values.", (Throwable)e);
                messages = MessageFormattingData.createDefault();
            }
        } else {
            messages = MessageFormattingData.createDefault();
            MessageFormattingManager.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)messages, (Appendable)writer);
        }
        catch (IOException e) {
            Shopshelves.LOGGER.error("Failed to save message formatting file.", (Throwable)e);
        }
    }
}

