/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.mixin;

import java.util.Optional;
import java.util.UUID;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.ShopShelf;
import me.andy.shopshelves.util.TextDisplayManager;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11597;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11597.class})
public abstract class ShelfBlockEntityMixin
extends class_2586
implements ShopShelf {
    @Unique
    private ShopHelper.ShopMode shopMode = ShopHelper.ShopMode.NONE;
    @Unique
    @Nullable
    private UUID owner = null;
    @Unique
    private class_2487 customSlotPrices = new class_2487();
    @Unique
    @Nullable
    private class_2338 linkedContainerPos = null;
    @Unique
    private static final String NBT_KEY_SHOP_MODE = "ShopShelves_ShopMode";
    @Unique
    private static final String NBT_KEY_OWNER = "ShopShelves_Owner";
    @Unique
    private static final String NBT_KEY_LINKED_POS = "ShopShelves_LinkedPos";
    @Unique
    private static final String PRICE_KEY_PREFIX = "shopshelves:price_slot_";

    public ShelfBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public ShopHelper.ShopMode getShopMode() {
        return this.shopMode;
    }

    @Override
    public void setShopMode(ShopHelper.ShopMode mode) {
        this.shopMode = mode;
        this.method_5431();
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.method_5431();
    }

    @Override
    public Optional<class_2487> getCustomPrice(int slot) {
        String slotKey = String.valueOf(slot);
        Optional priceNbtOpt = this.customSlotPrices.method_10562(slotKey);
        return priceNbtOpt.map(class_2487::method_10553);
    }

    @Override
    public void setCustomPrice(int slot, @Nullable class_2487 priceData) {
        String slotKey = String.valueOf(slot);
        if (priceData != null && !priceData.method_33133()) {
            this.customSlotPrices.method_10566(slotKey, (class_2520)priceData);
        } else {
            this.customSlotPrices.method_10551(slotKey);
        }
        this.method_5431();
    }

    @Override
    public Optional<class_2338> getLinkedContainerPos() {
        return Optional.ofNullable(this.linkedContainerPos);
    }

    @Override
    public void setLinkedContainerPos(@Nullable class_2338 pos) {
        this.linkedContainerPos = pos;
        this.method_5431();
    }

    @Inject(method={"writeData(Lnet/minecraft/storage/WriteView;)V"}, at={@At(value="TAIL")})
    private void writeCustomData(class_11372 view, CallbackInfo ci) {
        view.method_71469(NBT_KEY_SHOP_MODE, this.shopMode.name());
        if (this.owner != null) {
            view.method_71469(NBT_KEY_OWNER, this.owner.toString());
        }
        if (this.linkedContainerPos != null) {
            view.method_71466(NBT_KEY_LINKED_POS, this.linkedContainerPos.method_10063());
        }
        for (int i = 0; i < 3; ++i) {
            int slotIndex = i;
            String slotKey = String.valueOf(slotIndex);
            Optional priceDataOpt = this.customSlotPrices.method_10562(slotKey);
            if (priceDataOpt.isPresent()) {
                class_2487 priceData = (class_2487)priceDataOpt.get();
                priceData.method_10574("buy").ifPresent(price -> view.method_71469(PRICE_KEY_PREFIX + slotIndex + "_buy", String.valueOf(price)));
                priceData.method_10574("sell").ifPresent(price -> view.method_71469(PRICE_KEY_PREFIX + slotIndex + "_sell", String.valueOf(price)));
                continue;
            }
            view.method_71478(PRICE_KEY_PREFIX + slotIndex + "_buy");
            view.method_71478(PRICE_KEY_PREFIX + slotIndex + "_sell");
        }
    }

    @Inject(method={"readData(Lnet/minecraft/storage/ReadView;)V"}, at={@At(value="TAIL")})
    private void readCustomData(class_11368 view, CallbackInfo ci) {
        view.method_71441(NBT_KEY_SHOP_MODE).ifPresent(modeStr -> {
            try {
                this.shopMode = ShopHelper.ShopMode.valueOf(modeStr);
            }
            catch (IllegalArgumentException e) {
                this.shopMode = ShopHelper.ShopMode.NONE;
            }
        });
        view.method_71441(NBT_KEY_OWNER).ifPresent(uuidStr -> {
            try {
                this.owner = UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException e) {
                this.owner = null;
            }
        });
        view.method_71440(NBT_KEY_LINKED_POS).ifPresent(posLong -> {
            this.linkedContainerPos = class_2338.method_10092((long)posLong);
        });
        this.customSlotPrices = new class_2487();
        for (int i = 0; i < 3; ++i) {
            class_2487 slotPrices = new class_2487();
            view.method_71441(PRICE_KEY_PREFIX + i + "_buy").ifPresent(priceStr -> {
                try {
                    slotPrices.method_10549("buy", Double.parseDouble(priceStr));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            view.method_71441(PRICE_KEY_PREFIX + i + "_sell").ifPresent(priceStr -> {
                try {
                    slotPrices.method_10549("sell", Double.parseDouble(priceStr));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            if (slotPrices.method_33133()) continue;
            this.customSlotPrices.method_10566(String.valueOf(i), (class_2520)slotPrices);
        }
    }

    @Inject(method={"markDirty()V"}, at={@At(value="TAIL")})
    public void onMarkDirty(CallbackInfo ci) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            TextDisplayManager.updateShopDisplay(sw, this.field_11867, (class_11597)this);
        }
    }
}

