/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.config.MessageFormattingData;
import me.andy.shopshelves.config.MessageFormattingManager;
import me.andy.shopshelves.config.ShopshelvesConfig;
import me.andy.shopshelves.util.MessageFormatter;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MessageUtil {
    public static void sendMessage(class_2168 source, String key, Map<String, String> placeholders) {
        class_5250 formattedText;
        Object messageObject = MessageUtil.getMessageObject(key);
        if (messageObject == null || !(messageObject instanceof MessageFormattingData.MessageEntry)) {
            return;
        }
        MessageFormattingData.MessageEntry messageEntry = (MessageFormattingData.MessageEntry)messageObject;
        ShopshelvesConfig.MessageDeliveryMode mode = ShopshelvesConfig.get().getMessageDeliveryMode();
        class_3222 player = source.method_44023();
        if (!(mode != ShopshelvesConfig.MessageDeliveryMode.CHAT && mode != ShopshelvesConfig.MessageDeliveryMode.BOTH || messageEntry.chat() == null || messageEntry.chat().isEmpty())) {
            String rawChatMessage = MessageUtil.replacePlaceholders(messageEntry.chat(), placeholders);
            formattedText = MessageFormatter.parseSingleLine(rawChatMessage, player, source.method_9211(), false);
            source.method_9226(() -> MessageUtil.lambda$sendMessage$0((class_2561)formattedText), false);
        }
        if (!(player == null || mode != ShopshelvesConfig.MessageDeliveryMode.ACTIONBAR && mode != ShopshelvesConfig.MessageDeliveryMode.BOTH || messageEntry.actionbar() == null || messageEntry.actionbar().isEmpty())) {
            String rawActionbarMessage = MessageUtil.replacePlaceholders(messageEntry.actionbar(), placeholders);
            formattedText = MessageFormatter.parseSingleLine(rawActionbarMessage, player, source.method_9211(), false);
            player.method_7353((class_2561)formattedText, true);
        }
    }

    public static void sendError(class_2168 source, String key, Map<String, String> placeholders) {
        Object messageObject = MessageUtil.getMessageObject(key);
        if (messageObject == null || !(messageObject instanceof MessageFormattingData.MessageEntry)) {
            return;
        }
        MessageFormattingData.MessageEntry messageEntry = (MessageFormattingData.MessageEntry)messageObject;
        String rawErrorMessage = messageEntry.chat();
        if (rawErrorMessage == null || rawErrorMessage.isEmpty()) {
            rawErrorMessage = messageEntry.actionbar();
        }
        if (rawErrorMessage == null) {
            return;
        }
        rawErrorMessage = MessageUtil.replacePlaceholders(rawErrorMessage, placeholders);
        class_5250 formattedText = MessageFormatter.parseSingleLine(rawErrorMessage, source.method_44023(), source.method_9211(), false);
        source.method_9213((class_2561)formattedText);
    }

    private static String replacePlaceholders(String text, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        return text;
    }

    public static void sendPlayerMessage(class_3222 player, String key, Map<String, String> placeholders) {
        MessageUtil.sendMessage(player.method_64396(), key, placeholders);
    }

    public static void sendMessage(class_2168 source, String key) {
        MessageUtil.sendMessage(source, key, Collections.emptyMap());
    }

    public static void sendError(class_2168 source, String key) {
        MessageUtil.sendError(source, key, Collections.emptyMap());
    }

    private static Object getMessageObject(String key) {
        try {
            Field field = MessageFormattingData.class.getDeclaredField(key);
            field.setAccessible(true);
            return field.get(MessageFormattingManager.getMessages());
        }
        catch (NoSuchFieldException e) {
            Shopshelves.LOGGER.error("FATAL: Message key '{}' does not exist in MessageFormattingData.java. This is a developer error.", (Object)key);
            return new MessageFormattingData.MessageEntry("&c[Message key missing: " + key + "]", "&c[Missing key: " + key + "]");
        }
        catch (IllegalAccessException e) {
            Shopshelves.LOGGER.error("FATAL: Could not access message key '{}' via reflection.", (Object)key, (Object)e);
            return new MessageFormattingData.MessageEntry("&c[Message access error: " + key + "]", "&c[Access error: " + key + "]");
        }
    }

    private static /* synthetic */ class_2561 lambda$sendMessage$0(class_2561 formattedText) {
        return formattedText;
    }
}

