/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import me.andy.shopshelves.config.ShopshelvesConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;

public class ShopPermissionUtil {
    private static Boolean isPermissionsApiLoaded = null;
    private static boolean hasPermissionApiFailed = false;

    private static boolean checkPermissionsApiLoaded() {
        if (isPermissionsApiLoaded == null) {
            isPermissionsApiLoaded = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
        }
        return isPermissionsApiLoaded != false && !hasPermissionApiFailed;
    }

    public static boolean checkPermission(class_2168 source, String permissionNode, int defaultOpLevel) {
        if (ShopPermissionUtil.checkPermissionsApiLoaded()) {
            try {
                return Permissions.check((class_2172)source, (String)permissionNode, (int)defaultOpLevel);
            }
            catch (Throwable e) {
                hasPermissionApiFailed = true;
            }
        }
        return source.method_9259(defaultOpLevel);
    }

    public static int getPlayerShelfLimit(class_3222 player) {
        class_2168 source = player.method_64396();
        String playershelvesBase = "shopshelves.playershelves";
        int configDefault = ShopshelvesConfig.get().getDefaultPlayerShelfLimit();
        if (!ShopPermissionUtil.checkPermissionsApiLoaded()) {
            if (source.method_9259(2)) {
                return configDefault;
            }
            return 0;
        }
        if (ShopPermissionUtil.checkPermission(source, playershelvesBase + ".unlimited", 4)) {
            return Integer.MAX_VALUE;
        }
        int maxAllowed = -1;
        for (int i = 256; i >= 1; --i) {
            if (!ShopPermissionUtil.checkPermission(source, playershelvesBase + "." + i, 2)) continue;
            maxAllowed = i;
            break;
        }
        if (maxAllowed != -1) {
            return maxAllowed;
        }
        if (ShopPermissionUtil.checkPermission(source, "shopshelves.playershelf", 2)) {
            return configDefault;
        }
        return 0;
    }
}

