/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopshelves.util;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.andy.shopshelves.Shopshelves;
import me.andy.shopshelves.config.MessageFormattingData;
import me.andy.shopshelves.config.MessageFormattingManager;
import me.andy.shopshelves.config.ShopshelvesConfig;
import me.andy.shopshelves.logic.ShopHelper;
import me.andy.shopshelves.util.MessageFormatter;
import me.andy.shopshelves.util.ShopDataManager;
import me.andy.shopshelves.util.ShopShelf;
import net.minecraft.class_11586;
import net.minecraft.class_11597;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TextDisplayManager {
    private static final float TEXT_OFFSET = -0.1875f;
    private static class_2940<Vector3f> TRANSLATION;
    private static class_2940<Vector3f> SCALE;
    private static class_2940<Quaternionf> LEFT_ROTATION;
    private static class_2940<Quaternionf> RIGHT_ROTATION;
    private static class_2940<class_2561> TEXT;
    private static class_2940<Integer> LINE_WIDTH;
    private static class_2940<Integer> BACKGROUND;
    private static class_2940<Integer> INTERPOLATION_DURATION;
    private static class_2940<Byte> TEXT_DISPLAY_FLAGS;
    private static final float PRICE_VIEW_RANGE_MULTIPLIER;
    private static final float DEFAULT_VIEW_RANGE_MULTIPLIER;
    private static final float BASE_MAIN_DISPLAY_SCALE = 0.42f;
    private static final float BASE_AMOUNT_DISPLAY_SCALE = 0.5f;
    private static final float BASE_PRICE_DISPLAY_SCALE = 0.3f;
    private static final float PLAYERSHELF_BASE_SCALE = 0.42f;
    private static final float PLAYERSHELF_MIN_SCALE = 0.36f;

    private static float calculateScaleFactor(int configValue, float baseScale) {
        configValue = Math.max(1, Math.min(10, configValue));
        float ratio = (float)(configValue - 1) / 9.0f;
        float multiplier_min = 0.5f;
        float multiplier_max = 2.0f;
        float scaleMultiplier = multiplier_min + (multiplier_max - multiplier_min) * ratio;
        return baseScale * scaleMultiplier;
    }

    private static <T> class_2940<T> getTrackedDataField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (class_2940)field.get(null);
    }

    public static void updateShopDisplay(class_3218 world, class_2338 pos, class_11597 blockEntity) {
        ShopshelvesConfig config = ShopshelvesConfig.get();
        ShopDataManager.get().removeShopDisplayUuids(world, pos).ifPresent(uuids -> uuids.forEach(uuid -> {
            class_1297 oldDisplay = world.method_66347(uuid);
            if (oldDisplay != null) {
                oldDisplay.method_31472();
            }
        }));
        ShopShelf shopShelf = (ShopShelf)blockEntity;
        ShopHelper.ShopMode mode = shopShelf.getShopMode();
        if (mode == ShopHelper.ShopMode.NONE && blockEntity.method_5442()) {
            return;
        }
        class_2680 state = blockEntity.method_11010();
        if (!(state.method_26204() instanceof class_11586)) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_11586.field_61425);
        ArrayList<UUID> newDisplayUuids = new ArrayList<UUID>();
        double mainDisplayYOffset = 0.3125;
        class_243 mainDisplayPos = class_243.method_24953((class_2382)pos).method_1019(class_243.method_24954((class_2382)facing.method_10153().method_62675()).method_1021((double)Math.abs(-0.1875f))).method_1031(0.0, mainDisplayYOffset, 0.0);
        String ownerName = null;
        if (mode == ShopHelper.ShopMode.PLAYERSHELF) {
            ownerName = shopShelf.getOwner().flatMap(uuid -> Optional.ofNullable(world.method_8503().method_3760().method_14602(uuid)).map(player -> player.method_5477().getString()).or(() -> world.method_8503().method_73550().comp_4624().method_73290(uuid).map(GameProfile::name))).orElse(null);
        }
        float mainDisplayScale = TextDisplayManager.calculateScaleFactor(config.getMainDisplayScale(), 0.42f);
        float amountDisplayScale = TextDisplayManager.calculateScaleFactor(config.getAmountDisplayScale(), 0.5f);
        float priceDisplayScale = TextDisplayManager.calculateScaleFactor(config.getPriceDisplayScale(), 0.3f);
        if (mode == ShopHelper.ShopMode.PLAYERSHELF) {
            String nameForScaling;
            float playerShelfNameScale = 0.42f;
            String string = nameForScaling = ownerName != null ? ownerName : "Unknown";
            if (nameForScaling.length() > 8) {
                float reduction = (float)(nameForScaling.length() - 8) * 0.009999995f;
                playerShelfNameScale = Math.max(0.36f, 0.42f - reduction);
            }
            mainDisplayScale = playerShelfNameScale;
        }
        class_8113.class_8123 mainDisplay = TextDisplayManager.createBaseDisplay(world, facing, ownerName, DEFAULT_VIEW_RANGE_MULTIPLIER, mainDisplayScale);
        mainDisplay.method_23327(mainDisplayPos.field_1352, mainDisplayPos.field_1351, mainDisplayPos.field_1350);
        boolean isOutOfOrder = ShopHelper.isPlayerShelfOutOfOrder(world, shopShelf);
        if (TEXT != null) {
            mainDisplay.method_5841().method_12778(TEXT, (Object)TextDisplayManager.buildShopText(isOutOfOrder, mode, ownerName));
        }
        world.method_8649((class_1297)mainDisplay);
        newDisplayUuids.add(mainDisplay.method_5667());
        ShopshelvesConfig.PriceDisplayMode displayMode = ShopshelvesConfig.get().getPriceDisplayMode();
        if (!isOutOfOrder && !blockEntity.method_5442()) {
            double amountDisplayYOffset = mainDisplayYOffset - 0.71875;
            double priceDisplayYOffset = amountDisplayYOffset - 0.078125;
            class_243 rightVector = class_243.method_24954((class_2382)facing.method_10160().method_62675());
            if (displayMode == ShopshelvesConfig.PriceDisplayMode.SINGLEPRICE) {
                boolean allItemsSame = true;
                List itemsOnShelf = IntStream.range(0, blockEntity.method_5439()).mapToObj(arg_0 -> ((class_11597)blockEntity).method_5438(arg_0)).filter(s -> !s.method_7960()).collect(Collectors.toList());
                if (itemsOnShelf.size() > 1) {
                    class_1799 firstItem = (class_1799)itemsOnShelf.get(0);
                    for (int i2 = 1; i2 < itemsOnShelf.size(); ++i2) {
                        if (class_1799.method_31577((class_1799)firstItem, (class_1799)((class_1799)itemsOnShelf.get(i2)))) continue;
                        allItemsSame = false;
                        break;
                    }
                }
                if (mode == ShopHelper.ShopMode.PLAYERSHELF || allItemsSame && !itemsOnShelf.isEmpty()) {
                    int firstSlot = IntStream.range(0, blockEntity.method_5439()).filter(i -> !blockEntity.method_5438(i).method_7960()).findFirst().orElse(0);
                    Optional<Double> buyPriceOpt = ShopHelper.getUnitPrice(blockEntity, firstSlot, true);
                    Optional<Double> sellPriceOpt = ShopHelper.getUnitPrice(blockEntity, firstSlot, false);
                    if (buyPriceOpt.isPresent() || sellPriceOpt.isPresent()) {
                        newDisplayUuids.add(TextDisplayManager.createSinglePriceDisplay(world, pos, facing, 0.0, priceDisplayYOffset, rightVector, mode, buyPriceOpt, sellPriceOpt, priceDisplayScale));
                    }
                    for (int i3 = 0; i3 < 3; ++i3) {
                        class_1799 stack = blockEntity.method_5438(i3);
                        if (stack.method_7960()) continue;
                        double slotCenterOffset = i3 == 0 ? -0.3125 : (i3 == 2 ? 0.3125 : 0.0);
                        newDisplayUuids.add(TextDisplayManager.createDisplay(world, pos, facing, slotCenterOffset, amountDisplayYOffset, rightVector, mode, String.valueOf(stack.method_7947()), null, null, ownerName, DEFAULT_VIEW_RANGE_MULTIPLIER, amountDisplayScale));
                    }
                } else {
                    for (int i4 = 0; i4 < 3; ++i4) {
                        if (blockEntity.method_5438(i4).method_7960()) continue;
                        Optional<Double> buyPriceOpt = ShopHelper.getUnitPrice(blockEntity, i4, true);
                        Optional<Double> sellPriceOpt = ShopHelper.getUnitPrice(blockEntity, i4, false);
                        double slotCenterOffset = i4 == 0 ? -0.3125 : (i4 == 2 ? 0.3125 : 0.0);
                        newDisplayUuids.add(TextDisplayManager.createDisplay(world, pos, facing, slotCenterOffset, amountDisplayYOffset, rightVector, mode, String.valueOf(blockEntity.method_5438(i4).method_7947()), null, null, null, DEFAULT_VIEW_RANGE_MULTIPLIER, amountDisplayScale));
                        if (!buyPriceOpt.isPresent() && !sellPriceOpt.isPresent()) continue;
                        newDisplayUuids.add(TextDisplayManager.createDisplay(world, pos, facing, slotCenterOffset, priceDisplayYOffset, rightVector, mode, null, buyPriceOpt, sellPriceOpt, null, PRICE_VIEW_RANGE_MULTIPLIER, priceDisplayScale));
                    }
                }
            } else {
                for (int i5 = 0; i5 < 3; ++i5) {
                    class_1799 stack = blockEntity.method_5438(i5);
                    if (stack.method_7960()) continue;
                    Optional<Double> buyPriceOpt = ShopHelper.getPrice(blockEntity, i5, mode, true);
                    Optional<Double> sellPriceOpt = ShopHelper.getPrice(blockEntity, i5, mode, false);
                    double slotCenterOffset = i5 == 0 ? -0.3125 : (i5 == 2 ? 0.3125 : 0.0);
                    newDisplayUuids.add(TextDisplayManager.createDisplay(world, pos, facing, slotCenterOffset, amountDisplayYOffset, rightVector, mode, String.valueOf(stack.method_7947()), null, null, ownerName, DEFAULT_VIEW_RANGE_MULTIPLIER, amountDisplayScale));
                    if ((mode == ShopHelper.ShopMode.SELL || !buyPriceOpt.isPresent()) && (mode == ShopHelper.ShopMode.BUY || !sellPriceOpt.isPresent())) continue;
                    newDisplayUuids.add(TextDisplayManager.createDisplay(world, pos, facing, slotCenterOffset, priceDisplayYOffset, rightVector, mode, null, buyPriceOpt, sellPriceOpt, ownerName, PRICE_VIEW_RANGE_MULTIPLIER, priceDisplayScale));
                }
            }
        }
        if (!newDisplayUuids.isEmpty()) {
            ShopDataManager.get().setShopDisplayUuids(world, pos, newDisplayUuids);
        }
    }

    private static UUID createSinglePriceDisplay(class_3218 world, class_2338 blockPos, class_2350 facing, double horizontalOffset, double verticalOffset, class_243 rightVector, ShopHelper.ShopMode shopMode, Optional<Double> buyPriceOpt, Optional<Double> sellPriceOpt, float scale) {
        String format;
        class_8113.class_8123 display = TextDisplayManager.createBaseDisplay(world, facing, null, PRICE_VIEW_RANGE_MULTIPLIER, scale);
        class_243 displayPos = class_243.method_24953((class_2382)blockPos).method_1019(class_243.method_24954((class_2382)facing.method_10153().method_62675()).method_1021((double)Math.abs(-0.1875f))).method_1031(0.0, verticalOffset, 0.0).method_1019(rightVector.method_1021(horizontalOffset));
        display.method_23327(displayPos.field_1352, displayPos.field_1351, displayPos.field_1350);
        MessageFormattingData.PriceDisplayFormats formats = MessageFormattingManager.getMessages().singleprice_display_formats();
        if (shopMode == ShopHelper.ShopMode.PLAYERSHELF) {
            boolean hasBuy = buyPriceOpt.isPresent();
            boolean hasSell = sellPriceOpt.isPresent();
            format = hasBuy && hasSell ? formats.playershelf_dual() : (hasBuy ? formats.playershelf_buy() : (hasSell ? formats.playershelf_sell() : formats.dual()));
        } else {
            format = TextDisplayManager.getFormatStringFromFormats(formats, shopMode);
        }
        if (format == null) {
            format = "&bB:&6$%buy_price% &eS:&6$%sell_price%";
        }
        String buyPrice = buyPriceOpt.map(ShopHelper::formatPrice).orElse("N/A");
        String sellPrice = sellPriceOpt.map(ShopHelper::formatPrice).orElse("N/A");
        String rawText = format.replace("%buy_price%", buyPrice).replace("%sell_price%", sellPrice).replace("%price%", buyPrice.equals("N/A") ? sellPrice : buyPrice);
        if (TEXT != null) {
            display.method_5841().method_12778(TEXT, (Object)MessageFormatter.parseSingleLine(rawText, null, null, false));
        }
        world.method_8649((class_1297)display);
        return display.method_5667();
    }

    private static UUID createDisplay(class_3218 world, class_2338 blockPos, class_2350 facing, double horizontalOffset, double verticalOffset, class_243 rightVector, ShopHelper.ShopMode mode, @Nullable String amount, @Nullable Optional<Double> buyPriceOpt, @Nullable Optional<Double> sellPriceOpt, @Nullable String ownerName, float viewRangeMultiplier, float scale) {
        ShopshelvesConfig.PriceDisplayMode displayMode;
        MessageFormattingData.PriceDisplayFormats formats;
        String format;
        class_8113.class_8123 lowerDisplay = TextDisplayManager.createBaseDisplay(world, facing, ownerName, viewRangeMultiplier, scale);
        class_243 displayPos = class_243.method_24953((class_2382)blockPos).method_1019(class_243.method_24954((class_2382)facing.method_10153().method_62675()).method_1021((double)Math.abs(-0.1875f))).method_1031(0.0, verticalOffset, 0.0).method_1019(rightVector.method_1021(horizontalOffset));
        lowerDisplay.method_23327(displayPos.field_1352, displayPos.field_1351, displayPos.field_1350);
        MessageFormattingData messages = MessageFormattingManager.getMessages();
        String rawFormat = "";
        if (amount != null) {
            rawFormat = switch (mode) {
                case ShopHelper.ShopMode.BUY -> messages.buy_amount_format();
                case ShopHelper.ShopMode.SELL -> messages.sell_amount_format();
                case ShopHelper.ShopMode.DUAL, ShopHelper.ShopMode.PLAYERSHELF -> messages.dual_amount_format();
                default -> "";
            };
            rawFormat = rawFormat.replace("%amount%", amount);
        } else if ((buyPriceOpt != null || sellPriceOpt != null) && (format = TextDisplayManager.getFormatStringFromFormats(formats = (displayMode = ShopshelvesConfig.get().getPriceDisplayMode()) == ShopshelvesConfig.PriceDisplayMode.SINGLEPRICE ? messages.singleprice_display_formats() : messages.tripleprice_display_formats(), mode, buyPriceOpt.isPresent(), sellPriceOpt.isPresent())) != null) {
            String buyPrice = buyPriceOpt.map(ShopHelper::formatPrice).orElse("N/A");
            String sellPrice = sellPriceOpt.map(ShopHelper::formatPrice).orElse("N/A");
            rawFormat = format.replace("%buy_price%", buyPrice).replace("%sell_price%", sellPrice).replace("%price%", buyPrice.equals("N/A") ? sellPrice : buyPrice);
        }
        if (TEXT != null && !rawFormat.isEmpty()) {
            lowerDisplay.method_5841().method_12778(TEXT, (Object)MessageFormatter.parseSingleLine(rawFormat, null, null, false));
        }
        world.method_8649((class_1297)lowerDisplay);
        return lowerDisplay.method_5667();
    }

    private static String getFormatStringFromFormats(MessageFormattingData.PriceDisplayFormats formats, ShopHelper.ShopMode shopMode, boolean hasBuy, boolean hasSell) {
        if (formats == null) {
            return null;
        }
        if (shopMode == ShopHelper.ShopMode.PLAYERSHELF) {
            if (hasBuy && hasSell) {
                return formats.playershelf_dual();
            }
            if (hasBuy) {
                return formats.playershelf_buy();
            }
            if (hasSell) {
                return formats.playershelf_sell();
            }
            return formats.playershelf_dual();
        }
        return switch (shopMode) {
            case ShopHelper.ShopMode.BUY -> formats.buy();
            case ShopHelper.ShopMode.SELL -> formats.sell();
            case ShopHelper.ShopMode.DUAL -> formats.dual();
            default -> null;
        };
    }

    private static String getFormatStringFromFormats(MessageFormattingData.PriceDisplayFormats formats, ShopHelper.ShopMode shopMode) {
        return TextDisplayManager.getFormatStringFromFormats(formats, shopMode, true, true);
    }

    private static class_8113.class_8123 createBaseDisplay(class_3218 world, class_2350 facing, @Nullable String ownerName, float viewRangeMultiplier, float scale) {
        class_8113.class_8123 display = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
        display.method_5780("shopshelf_display");
        if (ownerName != null) {
            display.method_5780(ownerName.toLowerCase());
        }
        display.method_48847(class_8113.class_8114.field_42406);
        display.method_36456(facing.method_10144());
        display.method_48861(viewRangeMultiplier);
        if (LINE_WIDTH != null) {
            display.method_5841().method_12778(LINE_WIDTH, (Object)100);
        }
        if (BACKGROUND != null) {
            display.method_5841().method_12778(BACKGROUND, (Object)0);
        }
        if (INTERPOLATION_DURATION != null) {
            display.method_5841().method_12778(INTERPOLATION_DURATION, (Object)0);
        }
        if (TEXT_DISPLAY_FLAGS != null) {
            byte flags = 3;
            display.method_5841().method_12778(TEXT_DISPLAY_FLAGS, (Object)flags);
        }
        if (SCALE != null) {
            display.method_5841().method_12778(TRANSLATION, (Object)new Vector3f());
            display.method_5841().method_12778(LEFT_ROTATION, (Object)new Quaternionf());
            display.method_5841().method_12778(SCALE, (Object)new Vector3f(scale, scale, scale));
            display.method_5841().method_12778(RIGHT_ROTATION, (Object)new Quaternionf());
        }
        return display;
    }

    private static class_2561 buildShopText(boolean isOutOfOrder, ShopHelper.ShopMode mode, @Nullable String ownerName) {
        MessageFormattingData messages = MessageFormattingManager.getMessages();
        if (isOutOfOrder) {
            return MessageFormatter.parseSingleLine(messages.playershelf_outoforder_format(), null, null, false);
        }
        String format = switch (mode) {
            case ShopHelper.ShopMode.BUY -> messages.buy_display_format();
            case ShopHelper.ShopMode.SELL -> messages.sell_display_format();
            case ShopHelper.ShopMode.DUAL -> messages.dual_display_format();
            case ShopHelper.ShopMode.PLAYERSHELF -> {
                String displayName = ownerName != null ? ownerName : "Unknown";
                yield messages.playershelf_display_format().replace("%player%", displayName);
            }
            default -> "";
        };
        return MessageFormatter.parseSingleLine(format, null, null, false);
    }

    static {
        ShopshelvesConfig config = ShopshelvesConfig.get();
        int defaultRenderDistanceBlocks = config.getTextDisplayRenderDistanceBlocks();
        defaultRenderDistanceBlocks = Math.max(1, Math.min(defaultRenderDistanceBlocks, 256));
        int priceRenderDistanceBlocks = config.getPriceDisplayRenderDistanceBlocks();
        priceRenderDistanceBlocks = Math.max(1, Math.min(priceRenderDistanceBlocks, 256));
        DEFAULT_VIEW_RANGE_MULTIPLIER = (float)defaultRenderDistanceBlocks / 96.0f;
        PRICE_VIEW_RANGE_MULTIPLIER = (float)priceRenderDistanceBlocks / 96.0f;
        try {
            TRANSLATION = TextDisplayManager.getTrackedDataField(class_8113.class, "field_42401");
            SCALE = TextDisplayManager.getTrackedDataField(class_8113.class, "field_42402");
            LEFT_ROTATION = TextDisplayManager.getTrackedDataField(class_8113.class, "field_42403");
            RIGHT_ROTATION = TextDisplayManager.getTrackedDataField(class_8113.class, "field_42367");
            INTERPOLATION_DURATION = TextDisplayManager.getTrackedDataField(class_8113.class, "field_45113");
            Class<class_8113.class_8123> textDisplayClass = class_8113.class_8123.class;
            TEXT = TextDisplayManager.getTrackedDataField(textDisplayClass, "field_42435");
            LINE_WIDTH = TextDisplayManager.getTrackedDataField(textDisplayClass, "field_42436");
            BACKGROUND = TextDisplayManager.getTrackedDataField(textDisplayClass, "field_42437");
            TEXT_DISPLAY_FLAGS = TextDisplayManager.getTrackedDataField(textDisplayClass, "field_42439");
        }
        catch (Exception e) {
            Shopshelves.LOGGER.error("!!! CRITICAL: Failed to access DisplayEntity fields via reflection.", (Throwable)e);
        }
    }
}

