/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.logic.ShopHelper;
import me.andy.shopShelvesSpigot.util.AdminModeManager;
import me.andy.shopShelvesSpigot.util.MessageUtil;
import me.andy.shopShelvesSpigot.util.ShopDataManager;
import me.andy.shopShelvesSpigot.util.ShopPermissionUtil;
import me.andy.shopShelvesSpigot.util.ShopUtility;
import me.andy.shopShelvesSpigot.util.TextDisplayManager;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Shelf;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ShopListener
implements Listener {
    private final ShopShelvesSpigot plugin;
    private static final NamespacedKey PRICE_STAMP_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "price_stamp");
    private static Object UNCONNECTED;
    private static Object CENTER;
    private static Object LEFT;
    private static Object RIGHT;
    private static Method SET_SIDE_CHAIN_METHOD;
    private static Method GET_SIDE_CHAIN_METHOD;
    private static boolean IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED;
    private static Class<?> CHAIN_PART_CLASS;

    public static void setShelfSideChainSafely(BlockState state, boolean disconnect) {
        if (!IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED) {
            return;
        }
        BlockData blockData = state.getBlockData();
        if (blockData instanceof Shelf) {
            Shelf shelfData = (Shelf)blockData;
            try {
                Object value = disconnect ? UNCONNECTED : CENTER;
                SET_SIDE_CHAIN_METHOD.invoke((Object)shelfData, value);
                state.setBlockData((BlockData)shelfData);
            }
            catch (Exception e) {
                ShopShelvesSpigot.getInstance().getLogger().log(Level.SEVERE, "Failed to set Shelf SideChain reflectively.", e);
            }
        }
    }

    private Object getShelfSideChainReflectively(Shelf shelfData) {
        if (!IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED) {
            return null;
        }
        try {
            return GET_SIDE_CHAIN_METHOD.invoke((Object)shelfData, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get Shelf SideChain reflectively.", e);
            return null;
        }
    }

    public ShopListener(ShopShelvesSpigot plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        if (this.isShopShelfInventory(event.getSource())) {
            event.setCancelled(true);
            return;
        }
        if (this.isShopShelfInventory(event.getDestination())) {
            event.setCancelled(true);
        }
    }

    private boolean isShopShelfInventory(Inventory inventory) {
        BlockState state;
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (inventoryHolder instanceof BlockState && ShopHelper.isShelf((state = (BlockState)inventoryHolder).getType())) {
            return ShopHelper.hasShopData(state);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        BlockData blockData;
        if (!IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED) {
            if (ShopHelper.isShelf(event.getBlock().getType()) && ShopHelper.hasShopData(event.getBlock().getState())) {
                event.setCancelled(true);
            }
            return;
        }
        Block block = event.getBlock();
        if (ShopHelper.isShelf(block.getType()) && (blockData = block.getBlockData()) instanceof Shelf) {
            Shelf shelfData = (Shelf)blockData;
            this.handleSideChainFix(block, shelfData, event);
        }
    }

    private void handleSideChainFix(Block block, Shelf shelfData, BlockPhysicsEvent event) {
        Shelf chainData = shelfData;
        if (ShopHelper.hasShopData(block.getState())) {
            Object currentChain = this.getShelfSideChainReflectively(chainData);
            if (currentChain != null && !currentChain.equals(UNCONNECTED)) {
                ShopListener.setShelfSideChainSafely(block.getState(), true);
                block.setBlockData((BlockData)shelfData, false);
            }
            event.setCancelled(true);
            return;
        }
        BlockFace facing = shelfData.getFacing();
        BlockFace rightFace = this.getRightFace(facing);
        BlockFace leftFace = this.getLeftFace(facing);
        boolean shopOnRight = this.isShop(block.getRelative(rightFace));
        boolean shopOnLeft = this.isShop(block.getRelative(leftFace));
        if (!shopOnRight && !shopOnLeft) {
            return;
        }
        Object currentChain = this.getShelfSideChainReflectively(chainData);
        if (currentChain == null) {
            return;
        }
        Object newChain = currentChain;
        if (currentChain.equals(CENTER)) {
            if (shopOnRight && shopOnLeft) {
                newChain = UNCONNECTED;
            } else if (shopOnRight) {
                newChain = LEFT;
            } else if (shopOnLeft) {
                newChain = RIGHT;
            }
        } else if (currentChain.equals(RIGHT)) {
            if (shopOnRight) {
                newChain = UNCONNECTED;
            }
        } else if (currentChain.equals(LEFT) && shopOnLeft) {
            newChain = UNCONNECTED;
        }
        if (!newChain.equals(currentChain)) {
            try {
                SET_SIDE_CHAIN_METHOD.invoke((Object)chainData, newChain);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to set Shelf SideChain reflectively during physics.", e);
            }
            block.setBlockData((BlockData)shelfData, false);
            event.setCancelled(true);
        }
    }

    private boolean isShop(Block block) {
        if (block == null) {
            return false;
        }
        if (!ShopHelper.isShelf(block.getType())) {
            return false;
        }
        return ShopHelper.hasShopData(block.getState());
    }

    private BlockFace getRightFace(BlockFace facing) {
        return switch (facing) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            case BlockFace.EAST -> BlockFace.SOUTH;
            default -> BlockFace.SELF;
        };
    }

    private BlockFace getLeftFace(BlockFace facing) {
        return switch (facing) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            case BlockFace.EAST -> BlockFace.NORTH;
            default -> BlockFace.SELF;
        };
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (BlockState state : event.getChunk().getTileEntities()) {
                if (!ShopHelper.isShelf(state.getType())) continue;
                TextDisplayManager.updateShopDisplay(state.getWorld(), state.getLocation(), state);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (BlockState state : event.getChunk().getTileEntities()) {
            if (!ShopHelper.isShelf(state.getType())) continue;
            ShopDataManager.get().getShopDisplayConfigs(state.getLocation()).ifPresent(configs -> configs.forEach(config -> {
                if (config.getLiveUuid() != null) {
                    Entity display = Bukkit.getEntity((UUID)config.getLiveUuid());
                    if (display != null) {
                        display.remove();
                    }
                    config.setLiveUuid(null);
                }
            }));
        }
    }

    private boolean isAuthorized(Player player, BlockState state) {
        boolean isOwner;
        if (AdminModeManager.isAdmin(player)) {
            return true;
        }
        UUID ownerUuid = ShopHelper.getOwner(state).orElse(null);
        boolean bl = isOwner = ownerUuid != null && ownerUuid.equals(player.getUniqueId());
        if (ShopHelper.getShopMode(state) != ShopHelper.ShopMode.PLAYERSHELF && ShopHelper.hasShopData(state)) {
            return false;
        }
        return isOwner;
    }

    private boolean isProtectedBlock(Block block) {
        BlockState state = block.getState();
        if (ShopHelper.isShelf(block.getType()) && ShopHelper.getShopMode(state) != ShopHelper.ShopMode.NONE) {
            return true;
        }
        return ShopDataManager.get().isContainerLinked(block.getLocation());
    }

    private int getShelfHitSlot(Player player, Block clickedBlock, BlockState shelfState) {
        double horizontalCoordinate;
        if (!(shelfState instanceof org.bukkit.block.Shelf)) {
            return -1;
        }
        org.bukkit.block.Shelf shelf = (org.bukkit.block.Shelf)shelfState;
        Vector rayDirection = player.getEyeLocation().getDirection();
        RayTraceResult result = clickedBlock.rayTrace(player.getEyeLocation(), rayDirection, 5.0, FluidCollisionMode.NEVER);
        if (result == null || result.getHitBlock() == null || !result.getHitBlock().equals((Object)clickedBlock)) {
            return -1;
        }
        Vector hitPos = result.getHitPosition();
        if (!this.isFrontFaceAndCentrallyHit(clickedBlock, result.getHitBlockFace(), hitPos)) {
            return -1;
        }
        double relativeX = hitPos.getX() - (double)clickedBlock.getX();
        double relativeZ = hitPos.getZ() - (double)clickedBlock.getZ();
        BlockData blockData = clickedBlock.getBlockData();
        if (!(blockData instanceof Directional)) {
            return -1;
        }
        Directional directional = (Directional)blockData;
        BlockFace facing = directional.getFacing();
        switch (facing) {
            case NORTH: {
                horizontalCoordinate = relativeX;
                break;
            }
            case SOUTH: {
                horizontalCoordinate = 1.0 - relativeX;
                break;
            }
            case EAST: {
                horizontalCoordinate = 1.0 - relativeZ;
                break;
            }
            case WEST: {
                horizontalCoordinate = relativeZ;
                break;
            }
            default: {
                return -1;
            }
        }
        if (horizontalCoordinate < 0.3333333333333333) {
            return 0;
        }
        if (horizontalCoordinate < 0.6666666666666666) {
            return 1;
        }
        return 2;
    }

    private boolean isFrontFaceAndCentrallyHit(Block block, BlockFace hitFace, Vector hitPosition) {
        double areaVertical;
        double areaHorizontal;
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Directional)) {
            return false;
        }
        Directional directional = (Directional)blockData;
        BlockFace frontFace = directional.getFacing();
        if (hitFace != frontFace) {
            return false;
        }
        double relX = hitPosition.getX() - (double)block.getX();
        double relY = hitPosition.getY() - (double)block.getY();
        double relZ = hitPosition.getZ() - (double)block.getZ();
        if (frontFace == BlockFace.NORTH || frontFace == BlockFace.SOUTH) {
            areaHorizontal = relX;
            areaVertical = relY;
        } else {
            areaHorizontal = relZ;
            areaVertical = relY;
        }
        return areaHorizontal >= 0.0 && areaHorizontal <= 1.0 && areaVertical >= 0.0 && areaVertical <= 1.0;
    }

    private void clearShopBlockData(BlockState state) {
        ShopHelper.getPDC(state).ifPresent(pdc -> {
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "shop_mode"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "owner_uuid"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "owner_name"));
            pdc.remove(new NamespacedKey((Plugin)this.plugin, "linked_pos"));
            pdc.remove(ShopHelper.SHOPSHELF_TAG_KEY);
            for (int i = 0; i < 3; ++i) {
                pdc.remove(new NamespacedKey((Plugin)this.plugin, "price_slot_" + i));
            }
            ShopListener.setShelfSideChainSafely(state, false);
            state.update(true);
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        List<Location> containerLocations;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Player player = event.getPlayer();
        BlockState clickedState = clickedBlock.getState();
        ItemStack itemInHand = event.getItem();
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            if (ShopHelper.isShelf(clickedBlock.getType())) {
                event.setCancelled(true);
            }
            return;
        }
        Material clickedType = clickedBlock.getType();
        if (clickedType == Material.CHEST || clickedType == Material.BARREL) {
            BlockState shelfState;
            Block shelfBlock;
            containerLocations = ShopUtility.getContainerLocations(clickedBlock);
            boolean isLinked = ShopDataManager.get().isContainerLinked(containerLocations);
            if (isLinked && (shelfBlock = (Block)ShopDataManager.get().getShelfForContainer(containerLocations.get(0)).map(Location::getBlock).orElse(null)) != null && ShopHelper.getShopMode(shelfState = shelfBlock.getState()) != ShopHelper.ShopMode.NONE && !this.isAuthorized(player, shelfState)) {
                MessageUtil.sendError((CommandSender)player, "error_container_protected");
                event.setCancelled(true);
                return;
            }
        }
        if (player.isSneaking() && itemInHand != null && ShopHelper.isShelf(itemInHand.getType()) && (clickedType == Material.CHEST || clickedType == Material.BARREL)) {
            int currentShopCount;
            containerLocations = ShopUtility.getContainerLocations(clickedBlock);
            if (ShopDataManager.get().isContainerLinked(containerLocations)) {
                MessageUtil.sendError((CommandSender)player, "error_container_already_linked");
                event.setCancelled(true);
                return;
            }
            int limit = ShopPermissionUtil.getPlayerShelfLimit(player);
            if (limit <= 0) {
                MessageUtil.sendError((CommandSender)player, "error_no_permission_create_playershop");
                event.setCancelled(true);
                return;
            }
            if (limit != Integer.MAX_VALUE && (currentShopCount = ShopDataManager.get().countPlayerShelves(player.getUniqueId())) >= limit) {
                MessageUtil.sendError((CommandSender)player, "error_playershop_limit_reached", Map.of("%limit%", String.valueOf(limit)));
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (ShopHelper.isShelf(clickedType)) {
            boolean wasStampApplied;
            boolean isHandEmpty;
            BlockState shelfState = clickedState;
            ShopHelper.ShopMode mode = ShopHelper.getShopMode(shelfState);
            int slot = this.getShelfHitSlot(player, clickedBlock, shelfState);
            boolean isOwner = ShopHelper.getOwner(shelfState).map(uuid -> uuid.equals(player.getUniqueId())).orElse(false);
            boolean isAdmin = AdminModeManager.isAdmin(player);
            if (mode == ShopHelper.ShopMode.NONE && !isAdmin) {
                return;
            }
            if (slot == -1 && !player.isSneaking()) {
                if (!this.isAuthorized(player, shelfState)) {
                    event.setCancelled(true);
                }
                return;
            }
            boolean isHoldingPriceStamp = itemInHand != null && itemInHand.getItemMeta() != null && itemInHand.getItemMeta().getPersistentDataContainer().has(PRICE_STAMP_KEY, PersistentDataType.STRING);
            boolean bl = isHandEmpty = itemInHand == null || itemInHand.getType() == Material.AIR;
            if (isAdmin && (player.isSneaking() || slot == -1 || isHoldingPriceStamp)) {
                ShopHelper.handleAdminSetup(player, clickedBlock, shelfState, itemInHand, event.getHand(), slot);
                event.setCancelled(true);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    BlockState newState = clickedBlock.getState();
                    TextDisplayManager.updateShopDisplay(clickedBlock.getWorld(), clickedBlock.getLocation(), newState);
                });
                return;
            }
            if (mode == ShopHelper.ShopMode.PLAYERSHELF && isOwner && slot != -1 && (wasStampApplied = ShopHelper.applyAndCleanPlayerShopPriceStamp(shelfState, itemInHand, player))) {
                event.setCancelled(true);
                return;
            }
            if ((isOwner || isAdmin) && slot != -1) {
                org.bukkit.block.Shelf shelf;
                if (mode == ShopHelper.ShopMode.PLAYERSHELF && !isHandEmpty && !isHoldingPriceStamp && shelfState instanceof org.bukkit.block.Shelf && !ShopHelper.isItemAllowedInPlayerShelf((Inventory)(shelf = (org.bukkit.block.Shelf)shelfState).getInventory(), itemInHand)) {
                    String existingItemName = Arrays.stream(shelf.getInventory().getContents()).filter(i -> i != null && !i.getType().isAir()).findFirst().map(i -> i.getType().name()).orElse("Unknown");
                    MessageUtil.sendError((CommandSender)player, "error_item_type_mismatch", Map.of("%item%", existingItemName));
                    event.setCancelled(true);
                    return;
                }
                boolean isRemovalAttempt = isHandEmpty;
                if (shelfState instanceof org.bukkit.block.Shelf) {
                    org.bukkit.block.Shelf shelf2 = (org.bukkit.block.Shelf)shelfState;
                    ShopHelper.ShopMode modeBefore = ShopHelper.getShopMode(shelfState);
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        boolean isSlotNowEmpty;
                        BlockState newState = clickedBlock.getState();
                        ItemStack itemAfterInteraction = ((org.bukkit.block.Shelf)newState).getInventory().getItem(slot);
                        boolean bl = isSlotNowEmpty = itemAfterInteraction == null || itemAfterInteraction.getType().isAir();
                        if (isSlotNowEmpty || !isRemovalAttempt && !isHoldingPriceStamp) {
                            ShopHelper.setCustomPriceData(newState, slot, null);
                        }
                        if (isAdmin && modeBefore == ShopHelper.ShopMode.NONE && !isSlotNowEmpty) {
                            ShopHelper.setShopMode(newState, ShopHelper.ShopMode.BUY);
                            newState.update(true);
                            MessageUtil.sendPlayerMessage(player, "shop_mode_set", Map.of("%mode%", ShopHelper.ShopMode.BUY.name()));
                        }
                        if (mode == ShopHelper.ShopMode.PLAYERSHELF || isAdmin) {
                            Map<String, String> placeholders;
                            String messageKey = !isSlotNowEmpty ? "shop_slot_set" : "shop_slot_cleared";
                            Map<String, String> map = placeholders = !isSlotNowEmpty ? Map.of("%slot%", String.valueOf(slot + 1), "%item%", itemAfterInteraction.getType().name(), "%count%", String.valueOf(itemAfterInteraction.getAmount())) : Map.of("%slot%", String.valueOf(slot + 1));
                            if (!isSlotNowEmpty || isRemovalAttempt) {
                                MessageUtil.sendPlayerMessage(player, messageKey, placeholders);
                            }
                        }
                        TextDisplayManager.updateShopDisplay(clickedBlock.getWorld(), clickedBlock.getLocation(), newState);
                    }, 1L);
                }
                return;
            }
            if (slot != -1 && !isOwner) {
                boolean isHoldingItem;
                boolean bl2 = isHoldingItem = !isHandEmpty;
                if ((mode == ShopHelper.ShopMode.BUY || mode == ShopHelper.ShopMode.DUAL || mode == ShopHelper.ShopMode.PLAYERSHELF) && event.getHand() == EquipmentSlot.HAND) {
                    boolean isShiftClick = player.isSneaking();
                    ShopHelper.handleBuyInteraction(player, shelfState, slot, isShiftClick);
                    event.setCancelled(true);
                    return;
                }
                if (isHoldingItem) {
                    event.setCancelled(true);
                    MessageUtil.sendError((CommandSender)player, "error_container_protected");
                    return;
                }
            }
            if (!isOwner) {
                event.setCancelled(true);
                MessageUtil.sendError((CommandSender)player, "error_container_protected");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerAttack(PlayerInteractEvent event) {
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            if (ShopHelper.isShelf(clickedBlock.getType())) {
                event.setCancelled(true);
            }
            return;
        }
        Player player = event.getPlayer();
        BlockState clickedState = clickedBlock.getState();
        Material clickedType = clickedBlock.getType();
        if (this.isProtectedBlock(clickedBlock)) {
            if (ShopHelper.isShelf(clickedType)) {
                if (this.isAuthorized(player, clickedState)) {
                    return;
                }
            } else {
                event.setCancelled(true);
                return;
            }
        }
        if (ShopHelper.isShelf(clickedType)) {
            BlockState shelfState = clickedState;
            ShopHelper.ShopMode mode = ShopHelper.getShopMode(shelfState);
            int slot = this.getShelfHitSlot(player, clickedBlock, shelfState);
            boolean isOwner = ShopHelper.getOwner(shelfState).map(uuid -> uuid.equals(player.getUniqueId())).orElse(false);
            boolean isAdmin = AdminModeManager.isAdmin(player);
            if (mode == ShopHelper.ShopMode.NONE && !isAdmin) {
                return;
            }
            if (isAdmin || isOwner) {
                if (mode == ShopHelper.ShopMode.SELL || mode == ShopHelper.ShopMode.DUAL || mode == ShopHelper.ShopMode.PLAYERSHELF) {
                    ItemStack shelfStack;
                    if (shelfState instanceof org.bukkit.block.Shelf) {
                        org.bukkit.block.Shelf shelf = (org.bukkit.block.Shelf)shelfState;
                        v0 = shelf.getInventory().getItem(slot);
                    } else {
                        v0 = shelfStack = null;
                    }
                    if (shelfStack != null && !shelfStack.getType().isAir()) {
                        boolean isShiftClick = player.isSneaking();
                        ShopHelper.handleSellInteraction(player, shelfState, slot, isShiftClick);
                        event.setCancelled(true);
                        return;
                    }
                }
                return;
            }
            if (slot != -1) {
                if ((mode == ShopHelper.ShopMode.SELL || mode == ShopHelper.ShopMode.DUAL || mode == ShopHelper.ShopMode.PLAYERSHELF) && event.getHand() == EquipmentSlot.HAND) {
                    boolean isShiftClick = player.isSneaking();
                    ShopHelper.handleSellInteraction(player, shelfState, slot, isShiftClick);
                    event.setCancelled(true);
                    return;
                }
                if (mode == ShopHelper.ShopMode.BUY) {
                    event.setCancelled(true);
                    MessageUtil.sendError((CommandSender)player, "error_shop_not_buying");
                    return;
                }
            }
            event.setCancelled(true);
            MessageUtil.sendError((CommandSender)player, "error_container_protected");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onShelfPlace(BlockPlaceEvent event) {
        Directional directional;
        Block targetBlock;
        BlockData blockData;
        Block placedBlock = event.getBlockPlaced();
        Player player = event.getPlayer();
        BlockState placedState = placedBlock.getState();
        if (ShopHelper.isShelf(placedBlock.getType()) && player.isSneaking() && (blockData = placedBlock.getBlockData()) instanceof Directional && ((targetBlock = placedBlock.getRelative((directional = (Directional)blockData).getFacing().getOppositeFace())).getType() == Material.CHEST || targetBlock.getType() == Material.BARREL)) {
            List<Location> containerLocations = ShopUtility.getContainerLocations(targetBlock);
            if (ShopDataManager.get().isContainerLinked(containerLocations)) {
                event.setCancelled(true);
                return;
            }
            int limit = ShopPermissionUtil.getPlayerShelfLimit(player);
            if (limit <= 0) {
                event.setCancelled(true);
                return;
            }
            if (limit != Integer.MAX_VALUE && ShopDataManager.get().countPlayerShelves(player.getUniqueId()) >= limit) {
                event.setCancelled(true);
                return;
            }
            ShopHelper.setShopMode(placedState, ShopHelper.ShopMode.PLAYERSHELF);
            ShopHelper.setOwner(placedState, player.getUniqueId(), player.getName());
            ShopHelper.setLinkedContainerPos(placedState, targetBlock.getLocation());
            ShopHelper.getPDC(placedState).ifPresent(pdc -> pdc.set(ShopHelper.SHOPSHELF_TAG_KEY, PersistentDataType.BYTE, (Object)1));
            ShopListener.setShelfSideChainSafely(placedState, true);
            placedState.update(true);
            ShopDataManager.get().addLink(containerLocations, placedBlock.getLocation());
            placedBlock.getWorld().playSound(placedBlock.getLocation(), Sound.BLOCK_WOOD_PLACE, 1.0f, 1.0f);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> TextDisplayManager.updateShopDisplay(placedBlock.getWorld(), placedBlock.getLocation(), placedState));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onShopBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        Player player = event.getPlayer();
        if (ShopHelper.isShelf(brokenBlock.getType())) {
            BlockState state = brokenBlock.getState();
            boolean isShopActive = ShopHelper.hasShopData(state);
            if (isShopActive) {
                if (!this.isAuthorized(player, state)) {
                    event.setCancelled(true);
                    MessageUtil.sendError((CommandSender)player, "error_container_protected");
                    return;
                }
                ShopHelper.getLinkedContainerInventory(state).ifPresent(inventory -> {
                    Location holderLoc = inventory.getHolder().getInventory().getLocation();
                    if (holderLoc != null) {
                        Block containerBlock = holderLoc.getBlock();
                        List<Location> containerLocations = ShopUtility.getContainerLocations(containerBlock);
                        ShopDataManager.get().removeLink(containerLocations);
                    }
                });
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ShopDataManager.get().removeShopDisplayConfigs(brokenBlock.getLocation()).ifPresent(configs -> configs.forEach(config -> {
                    Entity oldDisplay;
                    UUID oldUuid = config.getLiveUuid();
                    if (oldUuid != null && (oldDisplay = Bukkit.getEntity((UUID)oldUuid)) != null) {
                        oldDisplay.remove();
                    }
                })));
            }
            this.clearShopBlockData(brokenBlock.getState());
        }
        List<Location> containerLocations = ShopUtility.getContainerLocations(brokenBlock);
        if (ShopDataManager.get().isContainerLinked(containerLocations)) {
            ShopDataManager.get().getShelfForContainer(containerLocations.get(0)).ifPresent(shelfLoc -> {
                BlockState shelfState = shelfLoc.getBlock().getState();
                if (ShopHelper.getShopMode(shelfState) != ShopHelper.ShopMode.NONE && !this.isAuthorized(player, shelfState)) {
                    event.setCancelled(true);
                    MessageUtil.sendError((CommandSender)player, "error_container_protected");
                } else {
                    ShopDataManager.get().removeLink(containerLocations);
                    ShopHelper.setLinkedContainerPos(shelfState, null);
                    if (ShopHelper.getShopMode(shelfState) == ShopHelper.ShopMode.PLAYERSHELF) {
                        ShopHelper.setShopMode(shelfState, ShopHelper.ShopMode.NONE);
                        ShopHelper.setOwner(shelfState, null, null);
                    }
                    shelfState.update(true);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> TextDisplayManager.updateShopDisplay(shelfLoc.getWorld(), shelfLoc, shelfState));
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockExplode(BlockExplodeEvent event) {
        this.preventShopExplosion(event.blockList());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        this.preventShopExplosion(event.blockList());
    }

    private void preventShopExplosion(List<Block> blocks) {
        blocks.removeIf(this::isProtectedBlock);
    }

    static {
        SET_SIDE_CHAIN_METHOD = null;
        GET_SIDE_CHAIN_METHOD = null;
        IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED = false;
        CHAIN_PART_CLASS = null;
        try {
            CHAIN_PART_CLASS = Class.forName("org.bukkit.block.data.SideChaining$ChainPart");
            Class<?> shelfDataClass = Class.forName("org.bukkit.block.data.type.Shelf");
            UNCONNECTED = Enum.valueOf(CHAIN_PART_CLASS, "UNCONNECTED");
            CENTER = Enum.valueOf(CHAIN_PART_CLASS, "CENTER");
            LEFT = Enum.valueOf(CHAIN_PART_CLASS, "LEFT");
            RIGHT = Enum.valueOf(CHAIN_PART_CLASS, "RIGHT");
            SET_SIDE_CHAIN_METHOD = shelfDataClass.getMethod("setSideChain", CHAIN_PART_CLASS);
            GET_SIDE_CHAIN_METHOD = shelfDataClass.getMethod("getSideChain", new Class[0]);
            IS_SIDE_CHAINING_API_AVAILABLE_AND_LOADED = true;
            ShopShelvesSpigot.getInstance().getLogger().log(Level.INFO, "ShopShelves: Side Chaining API successfully loaded for Shelf blocks.");
        }
        catch (Exception e) {
            ShopShelvesSpigot.getInstance().getLogger().log(Level.INFO, "ShopShelves: Running with Shelf Side Chaining feature disabled due to API version mismatch. (" + e.getMessage() + ")");
        }
    }
}

