/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.config.MessageFormattingManager;
import me.andy.shopShelvesSpigot.config.ShopPricing;
import me.andy.shopShelvesSpigot.config.ShopshelvesConfig;
import me.andy.shopShelvesSpigot.logic.ShopHelper;
import me.andy.shopShelvesSpigot.util.AdminModeManager;
import me.andy.shopShelvesSpigot.util.MessageUtil;
import me.andy.shopShelvesSpigot.util.ShopUtility;
import me.andy.shopShelvesSpigot.util.TextDisplayManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShopshelvesCommand
implements CommandExecutor,
TabCompleter {
    private final ShopShelvesSpigot plugin;
    private static final List<String> HELP_PAGE_1 = List.of(" ", "&6&m               &r  &6ShopShelves Helpful Commands &6&m               ", "&a/shops{Opens this help page.}<action:suggest_command,/shops>", "&a/shops itemprice{See the current settings for this item.}<action:suggest_command,/shops itemprice>", "&a/shops itemprice <price> <buy/sell/both> [amount]{Sets global price for held item.}<action:suggest_command,/shops itemprice >", "&a/shops price <price> <buy/sell/both> [amount]{Sets a custom one-time price for the held item.}<action:suggest_command,/shops price >", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/shops reload{Reloads configs.}<action:suggest_command,/shops reload>", "&a/shops update{Forces a refresh of all shop displays.}<action:suggest_command,/shops update>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&a/shops mode{See the messages and shelf display mode.}<action:suggest_command,/shops mode>", "&a/shops mode <mode>{Set messages or shelf display mode.}<action:suggest_command,/shops mode >", "&a/shops admin{Toggles shop setup mode.}<action:suggest_command,/shops admin>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&e/shops is an Alias :)                  &6[ShopShelves Help Link]{This is my discord i dont have a github etc yet will look into it :)}<action:open_url,https://discord.gg/GpryZU8QHK>", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>");
    private static final List<String> SUBCOMMANDS = List.of("help", "admin", "reload", "update", "mode", "itemprice", "price");
    public static final String PRICE_STAMP_KEY = "price_stamp";
    private static final String MESSAGE_KEY_ITEM_PRICE_NOT_SET = "item_price_not_set";
    private static final String MESSAGE_KEY_ITEM_PRICE_STATUS = "item_price_status";
    private static final String MESSAGE_KEY_CURRENT_MODES_STATUS = "current_modes_status";
    private static final List<String> PRICE_TYPES = List.of("sell", "buy", "both");

    public ShopshelvesCommand(ShopShelvesSpigot plugin) {
        this.plugin = plugin;
    }

    private NamespacedKey getStampPdcKey() {
        return new NamespacedKey((Plugin)this.plugin, PRICE_STAMP_KEY);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.isInitializationSuccessful()) {
            MessageUtil.sendError(sender, "error_critical_startup");
            return true;
        }
        if (!sender.hasPermission("shopshelves.command")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            return this.showHelp(sender, label);
        }
        String subCommand = args[0].toLowerCase(Locale.ROOT);
        try {
            switch (subCommand) {
                case "admin": {
                    return this.toggleAdminMode(sender);
                }
                case "reload": {
                    return this.reloadConfigsAndUpdate(sender);
                }
                case "update": {
                    return this.updateAllShopsCommand(sender);
                }
                case "mode": {
                    return this.handleModeCommand(sender, args);
                }
                case "itemprice": {
                    return this.handleItemPriceCommand(sender, args);
                }
                case "price": {
                    return this.handlePriceStampCommand(sender, args);
                }
            }
            MessageUtil.sendError(sender, "error_unknown_subcommand", Map.of("%arg%", args[0]));
            return this.showHelp(sender, label);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error executing command /" + label + " " + String.join((CharSequence)" ", args) + ": " + e.getMessage());
            MessageUtil.sendError(sender, "error_command_internal");
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("shopshelves.command")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return SUBCOMMANDS.stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length > 1) {
            String subCommand = args[0].toLowerCase(Locale.ROOT);
            ArrayList<String> completions = new ArrayList<String>();
            switch (subCommand) {
                case "mode": {
                    if (args.length != 2) break;
                    completions.addAll(Arrays.stream(ShopshelvesConfig.MessageDeliveryMode.values()).map(Enum::name).collect(Collectors.toList()));
                    completions.addAll(Arrays.stream(ShopshelvesConfig.PriceDisplayMode.values()).map(Enum::name).collect(Collectors.toList()));
                    break;
                }
                case "itemprice": 
                case "price": {
                    if (args.length != 3) break;
                    completions.addAll(PRICE_TYPES);
                }
            }
            return completions.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[args.length - 1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean showHelp(CommandSender sender, String label) {
        List<String> formattedLines = HELP_PAGE_1.stream().map(line -> line.replace("/shops", "/" + label)).collect(Collectors.toList());
        MessageUtil.sendRichTextLines(sender, formattedLines);
        return true;
    }

    private boolean toggleAdminMode(CommandSender sender) {
        if (!sender.hasPermission("shopshelves.admin")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            MessageUtil.sendError(sender, "error_command_player_only");
            return true;
        }
        Player player = (Player)sender;
        boolean isAdmin = AdminModeManager.toggleAdminMode(player);
        String messageKey = isAdmin ? "admin_mode_enabled" : "admin_mode_disabled";
        MessageUtil.sendPlayerMessage(player, messageKey);
        return true;
    }

    private boolean reloadConfigsAndUpdate(CommandSender sender) {
        if (!sender.hasPermission("shopshelves.reload")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        ShopshelvesConfig.load();
        MessageFormattingManager.load();
        ShopPricing.load();
        MessageUtil.sendMessage(sender, "reload_success");
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            TextDisplayManager.updateAllShops(this.plugin.getServer());
            MessageUtil.sendMessage(sender, "update_complete");
        });
        return true;
    }

    private boolean updateAllShopsCommand(CommandSender sender) {
        if (!sender.hasPermission("shopshelves.update")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        MessageUtil.sendMessage(sender, "update_start");
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            TextDisplayManager.updateAllShops(this.plugin.getServer());
            MessageUtil.sendMessage(sender, "update_complete");
        });
        return true;
    }

    private boolean handleModeCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("shopshelves.mode")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        if (args.length == 1) {
            ShopshelvesConfig config = ShopshelvesConfig.get();
            MessageUtil.sendMessage(sender, MESSAGE_KEY_CURRENT_MODES_STATUS, Map.of("%message_mode%", config.getMessageDeliveryMode().name(), "%price_mode%", config.getPriceDisplayMode().name()));
            return true;
        }
        if (args.length == 2) {
            String modeStr = args[1].toUpperCase(Locale.ROOT);
            ShopshelvesConfig config = ShopshelvesConfig.get();
            try {
                ShopshelvesConfig.MessageDeliveryMode newMsgMode = ShopshelvesConfig.MessageDeliveryMode.valueOf(modeStr);
                config.setMessageDeliveryMode(newMsgMode);
                ShopshelvesConfig.save();
                MessageUtil.sendMessage(sender, "message_mode_set", Map.of("%mode%", newMsgMode.name()));
                return true;
            }
            catch (IllegalArgumentException newMsgMode) {
                try {
                    ShopshelvesConfig.PriceDisplayMode newPriceMode = ShopshelvesConfig.PriceDisplayMode.valueOf(modeStr);
                    config.setPriceDisplayMode(newPriceMode);
                    ShopshelvesConfig.save();
                    MessageUtil.sendMessage(sender, "price_display_mode_set", Map.of("%mode%", newPriceMode.name()));
                    return this.updateAllShopsCommand(sender);
                }
                catch (IllegalArgumentException e) {
                    MessageUtil.sendError(sender, "error_invalid_message_mode", Map.of("%mode%", modeStr));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean handlePriceStampCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("shopshelves.price")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            MessageUtil.sendError(sender, "error_command_player_only");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            return false;
        }
        return this.executePriceStamp(player, args);
    }

    private boolean executePriceStamp(Player player, String[] args) {
        boolean heldStackHasStamp;
        double price;
        ItemStack heldStack = player.getInventory().getItemInMainHand();
        if (heldStack.getType() == Material.AIR) {
            MessageUtil.sendError((CommandSender)player, "error_must_hold_item");
            return true;
        }
        String type = "sell";
        int amount = -1;
        try {
            price = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (args.length >= 3) {
            type = args[2];
        }
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        ItemMeta meta = heldStack.getItemMeta();
        PersistentDataContainer itemPDC = meta.getPersistentDataContainer();
        String existingStampYaml = (String)itemPDC.get(this.getStampPdcKey(), PersistentDataType.STRING);
        Map<Object, Object> priceStampData = new HashMap();
        if (existingStampYaml != null) {
            priceStampData = ShopUtility.deserializeStamp(existingStampYaml);
        }
        if (!(heldStackHasStamp = itemPDC.has(this.getStampPdcKey(), PersistentDataType.STRING))) {
            for (ItemStack stack : player.getInventory().getContents()) {
                if (stack == null || stack == heldStack || !stack.hasItemMeta() || !stack.getItemMeta().getPersistentDataContainer().has(this.getStampPdcKey(), PersistentDataType.STRING)) continue;
                MessageUtil.sendError((CommandSender)player, "error_existing_price_stamp");
                return true;
            }
        }
        int currentAmount = priceStampData.containsKey("amount") ? Integer.parseInt((String)priceStampData.get("amount")) : heldStack.getAmount();
        int finalAmount = amount > 0 ? amount : currentAmount;
        Double sellPrice = priceStampData.containsKey("sell") ? Double.valueOf(Double.parseDouble((String)priceStampData.get("sell"))) : null;
        Double buyPrice = priceStampData.containsKey("buy") ? Double.valueOf(Double.parseDouble((String)priceStampData.get("buy"))) : null;
        switch (type.toLowerCase(Locale.ROOT)) {
            case "s": 
            case "sell": {
                priceStampData.put("sell", String.valueOf(price));
                sellPrice = price;
                break;
            }
            case "b": 
            case "buy": {
                priceStampData.put("buy", String.valueOf(price));
                buyPrice = price;
                break;
            }
            case "sb": 
            case "both": {
                priceStampData.put("sell", String.valueOf(price));
                priceStampData.put("buy", String.valueOf(price));
                sellPrice = price;
                buyPrice = price;
                break;
            }
            default: {
                MessageUtil.sendError((CommandSender)player, "error_invalid_price_type");
                return true;
            }
        }
        priceStampData.put("amount", String.valueOf(finalAmount));
        String newStampYaml = ShopUtility.serializeStamp(priceStampData);
        itemPDC.set(this.getStampPdcKey(), PersistentDataType.STRING, (Object)newStampYaml);
        heldStack.setItemMeta(meta);
        MessageUtil.sendMessage((CommandSender)player, "item_price_updated", Map.of("%item%", "Held " + heldStack.getType().name(), "%amount%", String.valueOf(finalAmount), "%sell_price%", sellPrice != null ? ShopHelper.formatPrice(sellPrice) : "N/A", "%buy_price%", buyPrice != null ? ShopHelper.formatPrice(buyPrice) : "N/A"));
        return true;
    }

    private boolean handleItemPriceCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("shopshelves.itemprice")) {
            MessageUtil.sendError(sender, "error_no_permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            MessageUtil.sendError(sender, "error_command_player_only");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            return this.showItemPrice(player);
        }
        return this.executeItemPrice(player, args);
    }

    private boolean showItemPrice(Player player) {
        ItemStack heldStack = player.getInventory().getItemInMainHand();
        if (heldStack.getType() == Material.AIR) {
            MessageUtil.sendError((CommandSender)player, "error_must_hold_item");
            return true;
        }
        ShopPricing.PriceEntry entry = ShopPricing.getPriceEntry(heldStack).orElse(null);
        if (entry == null) {
            MessageUtil.sendMessage((CommandSender)player, MESSAGE_KEY_ITEM_PRICE_NOT_SET, Map.of("%item%", heldStack.getType().name()));
            return true;
        }
        String sellPrice = entry.sellPrice() != null ? ShopHelper.formatPrice(entry.sellPrice()) : "N/A";
        String buyPrice = entry.buyPrice() != null ? ShopHelper.formatPrice(entry.buyPrice()) : "N/A";
        MessageUtil.sendMessage((CommandSender)player, MESSAGE_KEY_ITEM_PRICE_STATUS, Map.of("%item%", heldStack.getType().name(), "%amount%", String.valueOf(entry.amount()), "%sell_price%", sellPrice, "%buy_price%", buyPrice));
        return true;
    }

    private boolean executeItemPrice(Player player, String[] args) {
        double price;
        ItemStack heldStack = player.getInventory().getItemInMainHand();
        if (heldStack.getType() == Material.AIR) {
            MessageUtil.sendError((CommandSender)player, "error_must_hold_item");
            return true;
        }
        String type = "sell";
        int amount = -1;
        try {
            price = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (args.length >= 3) {
            type = args[2];
        }
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        ShopPricing.PriceEntry existingEntry = ShopPricing.getPriceEntry(heldStack.getType()).orElse(new ShopPricing.PriceEntry(1, null, null));
        int finalAmount = amount > 0 ? amount : existingEntry.amount();
        Double sellPrice = existingEntry.sellPrice();
        Double buyPrice = existingEntry.buyPrice();
        switch (type.toLowerCase(Locale.ROOT)) {
            case "s": 
            case "sell": {
                sellPrice = price;
                break;
            }
            case "b": 
            case "buy": {
                buyPrice = price;
                break;
            }
            case "sb": 
            case "both": {
                sellPrice = price;
                buyPrice = price;
                break;
            }
            default: {
                MessageUtil.sendError((CommandSender)player, "error_invalid_price_type");
                return true;
            }
        }
        ShopPricing.setPrice(heldStack, finalAmount, sellPrice, buyPrice);
        ShopPricing.save();
        MessageUtil.sendMessage((CommandSender)player, "item_price_updated", Map.of("%item%", heldStack.getType().name(), "%amount%", String.valueOf(finalAmount), "%sell_price%", sellPrice != null ? ShopHelper.formatPrice(sellPrice) : "N/A", "%buy_price%", buyPrice != null ? ShopHelper.formatPrice(buyPrice) : "N/A"));
        return true;
    }
}

