/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.config.MessageFormattingData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageFormattingManager {
    private static final String FILE_NAME = "messages.yml";
    private static File configFile;
    private static YamlConfiguration messageConfig;
    private static MessageFormattingData messages;

    public static void initialize() {
        ShopShelvesSpigot plugin = ShopShelvesSpigot.getInstance();
        configFile = new File(plugin.getDataFolder(), FILE_NAME);
        if (!configFile.exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                configFile.createNewFile();
                messages = MessageFormattingData.createDefault();
                messageConfig = new YamlConfiguration();
                MessageFormattingManager.saveDefaultsToYaml();
                messageConfig.save(configFile);
                plugin.getLogger().info("Generated default messages.yml.");
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Could not create default messages.yml: " + e.getMessage());
                throw new RuntimeException("Failed to generate MessageFormattingManager.yml", e);
            }
        }
        MessageFormattingManager.load();
    }

    public static MessageFormattingData getMessages() {
        if (messages == null) {
            MessageFormattingManager.load();
        }
        return messages;
    }

    public static void load() {
        messages = MessageFormattingData.createDefault();
        messageConfig = YamlConfiguration.loadConfiguration((File)configFile);
        for (Field field : MessageFormattingData.class.getFields()) {
            String path = field.getName();
            try {
                ConfigurationSection section;
                Object defaults;
                if (field.getType() == MessageFormattingData.MessageEntry.class) {
                    defaults = (MessageFormattingData.MessageEntry)field.get(messages);
                    section = messageConfig.getConfigurationSection(path);
                    if (section == null) continue;
                    String chat = section.getString("chat", ((MessageFormattingData.MessageEntry)defaults).chat);
                    String actionbar = section.getString("actionbar", ((MessageFormattingData.MessageEntry)defaults).actionbar);
                    field.set(messages, new MessageFormattingData.MessageEntry(chat, actionbar));
                    continue;
                }
                if (field.getType() == MessageFormattingData.PriceDisplayFormats.class) {
                    defaults = (MessageFormattingData.PriceDisplayFormats)field.get(messages);
                    section = messageConfig.getConfigurationSection(path);
                    if (section == null) continue;
                    String buy = section.getString("buy", ((MessageFormattingData.PriceDisplayFormats)defaults).buy);
                    String sell = section.getString("sell", ((MessageFormattingData.PriceDisplayFormats)defaults).sell);
                    String dual = section.getString("dual", ((MessageFormattingData.PriceDisplayFormats)defaults).dual);
                    String playershelf_buy = section.getString("playershelf_buy", ((MessageFormattingData.PriceDisplayFormats)defaults).playershelf_buy);
                    String playershelf_sell = section.getString("playershelf_sell", ((MessageFormattingData.PriceDisplayFormats)defaults).playershelf_sell);
                    String playershelf_dual = section.getString("playershelf_dual", ((MessageFormattingData.PriceDisplayFormats)defaults).playershelf_dual);
                    field.set(messages, new MessageFormattingData.PriceDisplayFormats(buy, sell, dual, playershelf_buy, playershelf_sell, playershelf_dual));
                    continue;
                }
                if (field.getType() != String.class) continue;
                defaults = (String)field.get(messages);
                String value = messageConfig.getString(path, (String)defaults);
                field.set(messages, value);
            }
            catch (Exception e) {
                ShopShelvesSpigot.getInstance().getLogger().warning("Error processing message key '" + path + "': " + e.getMessage());
            }
        }
    }

    private static void saveDefaultsToYaml() {
        if (messages == null) {
            return;
        }
        for (Field field : MessageFormattingData.class.getFields()) {
            String path = field.getName();
            try {
                ConfigurationSection section;
                if (field.getType() == MessageFormattingData.MessageEntry.class) {
                    MessageFormattingData.MessageEntry entry = (MessageFormattingData.MessageEntry)field.get(messages);
                    section = messageConfig.createSection(path);
                    section.set("chat", (Object)entry.chat());
                    section.set("actionbar", (Object)entry.actionbar());
                    continue;
                }
                if (field.getType() == MessageFormattingData.PriceDisplayFormats.class) {
                    MessageFormattingData.PriceDisplayFormats formats = (MessageFormattingData.PriceDisplayFormats)field.get(messages);
                    section = messageConfig.createSection(path);
                    section.set("buy", (Object)formats.buy());
                    section.set("sell", (Object)formats.sell());
                    section.set("dual", (Object)formats.dual());
                    section.set("playershelf_buy", (Object)formats.playershelf_buy());
                    section.set("playershelf_sell", (Object)formats.playershelf_sell());
                    section.set("playershelf_dual", (Object)formats.playershelf_dual());
                    continue;
                }
                if (field.getType() != String.class) continue;
                String value = (String)field.get(messages);
                messageConfig.set(path, (Object)value);
            }
            catch (Exception e) {
                ShopShelvesSpigot.getInstance().getLogger().severe("Failed to write default message field: " + path);
            }
        }
    }

    public static void save() {
        try {
            messageConfig.save(configFile);
        }
        catch (IOException e) {
            ShopShelvesSpigot.getInstance().getLogger().severe("Could not save messages.yml: " + e.getMessage());
        }
    }
}

