/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.util;

import java.util.UUID;
import java.util.logging.Level;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ShopEconomy {
    private static final Economy economy = ShopShelvesSpigot.getEconomy();

    public static boolean isEconomyEnabled() {
        return economy != null;
    }

    public static boolean hasEnough(Player player, double amount) {
        if (amount < 0.0) {
            return true;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().log(Level.WARNING, "Attempted to check balance for {0} but Vault is not available.", player.getName());
            return false;
        }
        return economy.has((OfflinePlayer)player, amount);
    }

    public static boolean hasEnough(UUID uuid, double amount) {
        if (amount < 0.0) {
            return true;
        }
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Attempted to check balance for UUID " + String.valueOf(uuid) + " but Vault is not available.");
            return false;
        }
        OfflinePlayer owner = ShopShelvesSpigot.getInstance().getServer().getOfflinePlayer(uuid);
        return economy.has(owner, amount);
    }

    public static void deposit(Player player, double amount) {
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Attempted to deposit funds to " + player.getName() + " but Vault is not available.");
            return;
        }
        economy.depositPlayer((OfflinePlayer)player, amount);
    }

    public static void deposit(UUID uuid, double amount) {
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Attempted to deposit funds to UUID " + String.valueOf(uuid) + " but Vault is not available.");
            return;
        }
        OfflinePlayer owner = ShopShelvesSpigot.getInstance().getServer().getOfflinePlayer(uuid);
        economy.depositPlayer(owner, amount);
    }

    public static boolean withdraw(Player player, double amount) {
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Attempted to withdraw funds from " + player.getName() + " but Vault is not available.");
            return false;
        }
        return economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public static boolean withdraw(UUID uuid, double amount) {
        if (!ShopEconomy.isEconomyEnabled()) {
            ShopShelvesSpigot.getInstance().getLogger().warning("Attempted to withdraw funds from UUID " + String.valueOf(uuid) + " but Vault is not available.");
            return false;
        }
        OfflinePlayer owner = ShopShelvesSpigot.getInstance().getServer().getOfflinePlayer(uuid);
        return economy.withdrawPlayer(owner, amount).transactionSuccess();
    }
}

