/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ShopUtility {
    private static final NamespacedKey LINKED_POS_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "linked_pos");
    private static final NamespacedKey OWNER_UUID_KEY = new NamespacedKey((Plugin)ShopShelvesSpigot.getInstance(), "owner_uuid");

    public static Map<String, String> deserializeStamp(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject jsonObject = (JSONObject)parser.parse(json);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object key : jsonObject.keySet()) {
                map.put(key.toString(), jsonObject.get(key).toString());
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String serializeStamp(Map<String, String> data) {
        JSONObject jsonObject = new JSONObject(data);
        return jsonObject.toJSONString();
    }

    public static int countItems(Inventory inventory, ItemStack stackToCount) {
        int amountFound = 0;
        for (ItemStack currentStack : inventory.getContents()) {
            if (currentStack == null || !currentStack.isSimilar(stackToCount)) continue;
            amountFound += currentStack.getAmount();
        }
        return amountFound;
    }

    public static boolean removeItems(Inventory inventory, ItemStack stackToRemove) {
        ItemStack copy = stackToRemove.clone();
        return inventory.removeItem(new ItemStack[]{copy}).isEmpty();
    }

    public static void addItems(Inventory inventory, ItemStack stackToAdd) {
        inventory.addItem(new ItemStack[]{stackToAdd});
    }

    public static boolean hasEnoughSpace(Inventory inventory, ItemStack stackToCheck) {
        ItemStack[] contents = inventory.getContents();
        int remaining = stackToCheck.getAmount();
        int maxStackSize = stackToCheck.getMaxStackSize();
        for (ItemStack slot : contents) {
            int space;
            if (slot == null || !slot.isSimilar(stackToCheck) || (space = maxStackSize - slot.getAmount()) <= 0 || (remaining -= space) > 0) continue;
            return true;
        }
        for (ItemStack slot : contents) {
            if (slot != null && !slot.getType().isAir() || (remaining -= maxStackSize) > 0) continue;
            return true;
        }
        return remaining <= 0;
    }

    public static List<Location> getContainerLocations(Block block) {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(block.getLocation());
        BlockState state = block.getState();
        if (state instanceof Chest) {
            Chest chest = (Chest)state;
            InventoryHolder holder = chest.getInventory().getHolder();
            if (holder instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)holder;
                locations.clear();
                locations.add(((Chest)doubleChest.getLeftSide()).getLocation());
                locations.add(((Chest)doubleChest.getRightSide()).getLocation());
                return locations;
            }
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Directional) {
                Directional blockData2 = (Directional)blockData;
                BlockFace facing = blockData2.getFacing();
                BlockFace left = ShopUtility.getPerpendicular(facing, true);
                BlockFace right = ShopUtility.getPerpendicular(facing, false);
                for (BlockFace face : new BlockFace[]{left, right}) {
                    Directional neighborData;
                    BlockData blockData3;
                    Block neighborBlock = block.getRelative(face);
                    if (neighborBlock.getType() != block.getType() || !((blockData3 = neighborBlock.getBlockData()) instanceof Directional) || (neighborData = (Directional)blockData3).getFacing() != facing) continue;
                    locations.add(neighborBlock.getLocation());
                    return locations;
                }
            }
        }
        return locations;
    }

    private static BlockFace getPerpendicular(BlockFace facing, boolean isLeft) {
        return switch (facing) {
            case BlockFace.NORTH -> {
                if (isLeft) {
                    yield BlockFace.EAST;
                }
                yield BlockFace.WEST;
            }
            case BlockFace.SOUTH -> {
                if (isLeft) {
                    yield BlockFace.WEST;
                }
                yield BlockFace.EAST;
            }
            case BlockFace.EAST -> {
                if (isLeft) {
                    yield BlockFace.SOUTH;
                }
                yield BlockFace.NORTH;
            }
            case BlockFace.WEST -> {
                if (isLeft) {
                    yield BlockFace.NORTH;
                }
                yield BlockFace.SOUTH;
            }
            default -> BlockFace.SELF;
        };
    }
}

