/*
 * Decompiled with CFR 0.152.
 */
package me.andy.shopShelvesSpigot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.andy.shopShelvesSpigot.ShopShelvesSpigot;
import me.andy.shopShelvesSpigot.config.MessageFormattingData;
import me.andy.shopShelvesSpigot.config.MessageFormattingManager;
import me.andy.shopShelvesSpigot.config.ShopshelvesConfig;
import me.andy.shopShelvesSpigot.logic.ShopHelper;
import me.andy.shopShelvesSpigot.util.MessageUtil;
import me.andy.shopShelvesSpigot.util.ShopDataManager;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Shelf;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TextDisplayManager {
    private static final float TEXT_OFFSET = -0.1875f;
    private static final String TEXT_DISPLAY_TAG = "shopshelf_display";
    private static final float BASE_ENTITY_RENDER_DISTANCE = 96.0f;
    private static final float BASE_MAIN_DISPLAY_SCALE = 0.42f;
    private static final float BASE_AMOUNT_DISPLAY_SCALE = 0.5f;
    private static final float BASE_PRICE_DISPLAY_SCALE = 0.3f;
    private static final float PLAYERSHELF_BASE_SCALE = 0.42f;
    private static final float PLAYERSHELF_MIN_SCALE = 0.36f;

    private static float calculateScaleFactor(int configValue, float baseScale) {
        configValue = Math.max(1, Math.min(10, configValue));
        float ratio = (float)(configValue - 1) / 9.0f;
        float multiplier_min = 0.5f;
        float multiplier_max = 2.0f;
        float scaleMultiplier = multiplier_min + (multiplier_max - multiplier_min) * ratio;
        return baseScale * scaleMultiplier;
    }

    public static void updateAllShops(Server server) {
        ShopShelvesSpigot.getInstance().getLogger().info("Starting full ShopShelves display update (Synchronous config refresh)...");
        HashSet allShopLocations = new HashSet();
        ShopDataManager.get().getAllShopsConfig().values().stream().flatMap(map -> map.keySet().stream()).forEach(locKey -> ShopDataManager.get().keyToLocation((String)locKey).ifPresent(allShopLocations::add));
        ShopDataManager.get().getAllPlayerShelfLocations().forEach(allShopLocations::add);
        Bukkit.getScheduler().runTask((Plugin)ShopShelvesSpigot.getInstance(), () -> {
            for (Location pos : allShopLocations) {
                World world = pos.getWorld();
                if (world == null || !pos.getChunk().isLoaded()) continue;
                BlockState state = pos.getBlock().getState();
                TextDisplayManager.updateShopDisplay(world, pos, state);
            }
            ShopShelvesSpigot.getInstance().getLogger().info("Full ShopShelves display update complete.");
        });
    }

    public static void updateShopDisplay(World world, Location pos, BlockState blockState) {
        ShopDataManager.get().getShopDisplayConfigs(pos).ifPresent(configs -> configs.forEach(config -> {
            UUID oldUuid = config.getLiveUuid();
            if (oldUuid != null) {
                Entity oldDisplay = Bukkit.getEntity((UUID)oldUuid);
                if (oldDisplay != null) {
                    oldDisplay.remove();
                }
                config.setLiveUuid(null);
            }
        }));
        ShopHelper.ShopMode mode = ShopHelper.getShopMode(blockState);
        if (mode == ShopHelper.ShopMode.NONE) {
            ShopDataManager.get().removeShopDisplayConfigs(pos);
            return;
        }
        List<ShopDataManager.DisplayConfig> newConfigs = TextDisplayManager.generateDisplayConfigs(blockState, pos, mode);
        ShopDataManager.get().setShopDisplayConfigs(pos, newConfigs);
        BlockData blockData = blockState.getBlockData();
        if (!(blockData instanceof Directional)) {
            return;
        }
        Directional directional = (Directional)blockData;
        for (ShopDataManager.DisplayConfig config : newConfigs) {
            TextDisplay display = TextDisplayManager.createBaseDisplay(world, config.getYaw(), config.getOwnerTag(), config.getViewRange(), config.getScale());
            Vector initialLocation = pos.toVector().add(new Vector(0.5, 0.5, 0.5));
            Vector offsetVector = new Vector(config.getOffsetX(), config.getOffsetY(), config.getOffsetZ());
            display.teleport(initialLocation.add(offsetVector).toLocation(world));
            display.setText(MessageUtil.translateColorCodes(config.getText()));
            display.setRotation(config.getYaw(), 0.0f);
            config.setLiveUuid(display.getUniqueId());
        }
    }

    private static List<ShopDataManager.DisplayConfig> generateDisplayConfigs(BlockState blockState, Location pos, ShopHelper.ShopMode mode) {
        ArrayList<ShopDataManager.DisplayConfig> configs = new ArrayList<ShopDataManager.DisplayConfig>();
        ShopshelvesConfig config = ShopshelvesConfig.get();
        BlockData blockData = blockState.getBlockData();
        if (!(blockData instanceof Directional)) {
            return configs;
        }
        Directional directional = (Directional)blockData;
        BlockFace facing = directional.getFacing();
        Vector facingVec = facing.getDirection();
        float yaw = TextDisplayManager.getYawForFacing(facing);
        double mainDisplayYOffset = 0.8125;
        double depthOffset = -0.1875;
        String ownerName = ShopHelper.getOwnerName(blockState).or(() -> ShopHelper.getOwner(blockState).map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName())).orElse(null);
        float mainDisplayScale = TextDisplayManager.calculateScaleFactor(config.getMainDisplayScale(), 0.42f);
        float amountDisplayScale = TextDisplayManager.calculateScaleFactor(config.getAmountDisplayScale(), 0.5f);
        float priceDisplayScale = TextDisplayManager.calculateScaleFactor(config.getPriceDisplayScale(), 0.3f);
        int defaultViewRange = config.getTextDisplayRenderDistanceBlocks();
        int priceViewRange = config.getPriceDisplayRenderDistanceBlocks();
        if (mode == ShopHelper.ShopMode.PLAYERSHELF) {
            String nameForScaling;
            float playerShelfNameScale = 0.42f;
            String string = nameForScaling = ownerName != null ? ownerName : "Unknown";
            if (nameForScaling.length() > 8) {
                float reduction = (float)(nameForScaling.length() - 8) * 0.009999995f;
                playerShelfNameScale = Math.max(0.36f, 0.42f - reduction);
            }
            mainDisplayScale = playerShelfNameScale;
        }
        double mainDisplayOffsetX = facingVec.getX() * depthOffset;
        double mainDisplayOffsetZ = facingVec.getZ() * depthOffset;
        String mainText = TextDisplayManager.buildShopText(ShopHelper.isPlayerShelfOutOfOrder(blockState), mode, ownerName);
        configs.add(new ShopDataManager.DisplayConfig(null, mainText, mainDisplayOffsetX, mainDisplayYOffset - 0.5, mainDisplayOffsetZ, mainDisplayScale, defaultViewRange, yaw, ownerName));
        if (!ShopHelper.isPlayerShelfOutOfOrder(blockState) && blockState instanceof Shelf) {
            Shelf shelf = (Shelf)blockState;
            ItemStack[] shelfItems = shelf.getInventory().getContents();
            Vector rightVector = TextDisplayManager.getRightVector(facingVec);
            boolean hasAnyItem = false;
            ArrayList<ItemStack> nonAirStacks = new ArrayList<ItemStack>();
            for (ItemStack item : shelfItems) {
                if (item == null || item.getType().isAir()) continue;
                hasAnyItem = true;
                nonAirStacks.add(item);
            }
            if (!hasAnyItem) {
                return configs;
            }
            boolean allItemsSame = nonAirStacks.size() > 0 && nonAirStacks.stream().allMatch(stack -> stack.isSimilar((ItemStack)nonAirStacks.get(0)));
            double amountDisplayYOffset = mainDisplayYOffset - 0.71875;
            double priceDisplayYOffset = amountDisplayYOffset - 0.078125;
            Function<Integer, Double> getSlotOffset = i -> i == 0 ? -0.3125 : (i == 2 ? 0.3125 : 0.0);
            ShopshelvesConfig.PriceDisplayMode displayMode = config.getPriceDisplayMode();
            for (int i2 = 0; i2 < shelfItems.length; ++i2) {
                Optional<Double> sellPriceOpt;
                Optional<Double> buyPriceOpt;
                ItemStack stack2 = shelfItems[i2];
                if (stack2 == null || stack2.getType().isAir()) continue;
                double slotCenterOffset = getSlotOffset.apply(i2);
                double slotOffsetX = rightVector.getX() * slotCenterOffset + facingVec.getX() * depthOffset;
                double slotOffsetZ = rightVector.getZ() * slotCenterOffset + facingVec.getZ() * depthOffset;
                String amountText = TextDisplayManager.buildAmountText(mode, String.valueOf(stack2.getAmount()));
                configs.add(new ShopDataManager.DisplayConfig(null, amountText, slotOffsetX, amountDisplayYOffset - 0.5, slotOffsetZ, amountDisplayScale, defaultViewRange, yaw, ownerName));
                if (displayMode == ShopshelvesConfig.PriceDisplayMode.TRIPLEPRICE) {
                    buyPriceOpt = ShopHelper.getPrice(blockState, i2, mode, true);
                    sellPriceOpt = ShopHelper.getPrice(blockState, i2, mode, false);
                } else {
                    buyPriceOpt = ShopHelper.getUnitPrice(blockState, i2, true);
                    sellPriceOpt = ShopHelper.getUnitPrice(blockState, i2, false);
                }
                if (displayMode != ShopshelvesConfig.PriceDisplayMode.TRIPLEPRICE && (displayMode != ShopshelvesConfig.PriceDisplayMode.SINGLEPRICE || allItemsSame && mode != ShopHelper.ShopMode.PLAYERSHELF) || !buyPriceOpt.isPresent() && !sellPriceOpt.isPresent()) continue;
                String priceText = TextDisplayManager.buildPriceText(mode, displayMode, buyPriceOpt, sellPriceOpt, allItemsSame);
                configs.add(new ShopDataManager.DisplayConfig(null, priceText, slotOffsetX, priceDisplayYOffset - 0.5, slotOffsetZ, priceDisplayScale, priceViewRange, yaw, ownerName));
            }
            if (displayMode == ShopshelvesConfig.PriceDisplayMode.SINGLEPRICE && allItemsSame && nonAirStacks.size() > 0) {
                int firstSlotIndex = IntStream.range(0, shelfItems.length).filter(i -> shelfItems[i] != null && !shelfItems[i].getType().isAir()).findFirst().orElse(0);
                Optional<Double> unitBuyPriceOpt = ShopHelper.getUnitPrice(blockState, firstSlotIndex, true);
                Optional<Double> unitSellPriceOpt = ShopHelper.getUnitPrice(blockState, firstSlotIndex, false);
                if (unitBuyPriceOpt.isPresent() || unitSellPriceOpt.isPresent()) {
                    String priceText = TextDisplayManager.buildPriceText(mode, displayMode, unitBuyPriceOpt, unitSellPriceOpt, allItemsSame);
                    configs.add(new ShopDataManager.DisplayConfig(null, priceText, facingVec.getX() * depthOffset, priceDisplayYOffset - 0.5, facingVec.getZ() * depthOffset, priceDisplayScale, priceViewRange, yaw, ownerName));
                }
            }
        }
        return configs;
    }

    private static float getYawForFacing(BlockFace facing) {
        return switch (facing) {
            case BlockFace.NORTH -> 180.0f;
            case BlockFace.SOUTH -> 0.0f;
            case BlockFace.WEST -> 90.0f;
            case BlockFace.EAST -> -90.0f;
            default -> 0.0f;
        };
    }

    private static Vector getRightVector(Vector facingVec) {
        return new Vector(facingVec.getZ(), 0.0, -facingVec.getX());
    }

    private static TextDisplay createBaseDisplay(World world, float yaw, @Nullable String ownerTag, int viewRangeBlocks, float scale) {
        TextDisplay display = (TextDisplay)world.spawnEntity(world.getSpawnLocation(), EntityType.TEXT_DISPLAY);
        display.setPersistent(false);
        display.addScoreboardTag(TEXT_DISPLAY_TAG);
        if (ownerTag != null) {
            display.addScoreboardTag(ownerTag.toLowerCase());
        }
        display.setBillboard(Display.Billboard.FIXED);
        float viewRangeMultiplier = (float)viewRangeBlocks / 96.0f;
        display.setViewRange(viewRangeMultiplier);
        display.setLineWidth(100);
        display.setTextOpacity((byte)-1);
        display.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        display.setDefaultBackground(false);
        display.setShadowed(true);
        display.setSeeThrough(true);
        display.setAlignment(TextDisplay.TextAlignment.CENTER);
        Transformation transformation = display.getTransformation();
        transformation.getScale().set((Vector3fc)new Vector3f(scale, scale, scale));
        display.setTransformation(transformation);
        return display;
    }

    private static String buildAmountText(ShopHelper.ShopMode mode, String amount) {
        MessageFormattingData messages = MessageFormattingManager.getMessages();
        String rawFormat = switch (mode) {
            case ShopHelper.ShopMode.BUY -> messages.buy_amount_format;
            case ShopHelper.ShopMode.SELL -> messages.sell_amount_format;
            case ShopHelper.ShopMode.DUAL -> messages.dual_amount_format;
            case ShopHelper.ShopMode.PLAYERSHELF -> messages.playershelf_amount_format;
            default -> "";
        };
        return rawFormat.replace("%amount%", amount);
    }

    private static String buildPriceText(ShopHelper.ShopMode shopMode, ShopshelvesConfig.PriceDisplayMode displayMode, Optional<Double> buyPriceOpt, Optional<Double> sellPriceOpt, boolean isPerUnit) {
        String buyPriceStr;
        boolean hasSell;
        MessageFormattingData messages = MessageFormattingManager.getMessages();
        MessageFormattingData.PriceDisplayFormats formats = displayMode == ShopshelvesConfig.PriceDisplayMode.SINGLEPRICE ? messages.singleprice_display_formats : messages.tripleprice_display_formats;
        String unsetDisplay = messages.price_unset_display;
        String buyPriceFormatted = buyPriceOpt.map(p -> ShopHelper.formatDisplayPrice(p, shopMode)).orElse(unsetDisplay);
        String sellPriceFormatted = sellPriceOpt.map(p -> ShopHelper.formatDisplayPrice(p, shopMode)).orElse(unsetDisplay);
        boolean hasBuy = buyPriceFormatted != null;
        boolean bl = hasSell = sellPriceFormatted != null;
        String string = hasBuy ? buyPriceFormatted : (buyPriceStr = shopMode == ShopHelper.ShopMode.PLAYERSHELF ? "" : unsetDisplay);
        String sellPriceStr = hasSell ? sellPriceFormatted : (shopMode == ShopHelper.ShopMode.PLAYERSHELF ? "" : unsetDisplay);
        String format = TextDisplayManager.getFormatStringFromFormats(formats, shopMode, hasBuy, hasSell);
        if (format == null) {
            format = "&bB:&6%buy_price% &eS:&6%sell_price%";
        }
        String primaryPrice = switch (shopMode) {
            case ShopHelper.ShopMode.SELL -> sellPriceStr;
            case ShopHelper.ShopMode.BUY -> buyPriceStr;
            case ShopHelper.ShopMode.DUAL -> buyPriceStr;
            case ShopHelper.ShopMode.PLAYERSHELF -> {
                if (hasBuy) {
                    yield buyPriceStr;
                }
                if (hasSell) {
                    yield sellPriceStr;
                }
                yield unsetDisplay;
            }
            default -> unsetDisplay;
        };
        String rawText = format.replace("%buy_price%", buyPriceStr).replace("%sell_price%", sellPriceStr).replace("%price%", primaryPrice);
        return rawText;
    }

    private static String getFormatStringFromFormats(MessageFormattingData.PriceDisplayFormats formats, ShopHelper.ShopMode shopMode, boolean hasBuy, boolean hasSell) {
        if (formats == null) {
            return null;
        }
        if (shopMode == ShopHelper.ShopMode.PLAYERSHELF) {
            if (hasBuy && hasSell) {
                return formats.playershelf_dual;
            }
            if (hasBuy) {
                return formats.playershelf_buy;
            }
            if (hasSell) {
                return formats.playershelf_sell;
            }
            return null;
        }
        return switch (shopMode) {
            case ShopHelper.ShopMode.BUY -> formats.buy;
            case ShopHelper.ShopMode.SELL -> formats.sell;
            case ShopHelper.ShopMode.DUAL -> formats.dual;
            default -> null;
        };
    }

    private static String buildShopText(boolean isOutOfOrder, ShopHelper.ShopMode mode, @Nullable String ownerName) {
        MessageFormattingData messages = MessageFormattingManager.getMessages();
        if (isOutOfOrder) {
            return messages.playershelf_outoforder_format;
        }
        String format = switch (mode) {
            case ShopHelper.ShopMode.BUY -> messages.buy_display_format;
            case ShopHelper.ShopMode.SELL -> messages.sell_display_format;
            case ShopHelper.ShopMode.DUAL -> messages.dual_display_format;
            case ShopHelper.ShopMode.PLAYERSHELF -> {
                String displayName = ownerName != null ? ownerName : "Unknown";
                yield messages.playershelf_display_format.replace("%player%", displayName);
            }
            default -> "";
        };
        return format;
    }

    public static void cleanupAllDisplays() {
        ShopShelvesSpigot.getInstance().getLogger().info("Cleaning up all active ShopShelves displays...");
        ShopDataManager.get().getAllShopsConfig().values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).forEach(config -> {
            if (config.getLiveUuid() != null) {
                Entity display = Bukkit.getEntity((UUID)config.getLiveUuid());
                if (display != null) {
                    display.remove();
                }
                config.setLiveUuid(null);
            }
        });
        ShopDataManager.get().clearRuntimeDisplayData();
    }
}

